/***************************************************************************
                                newpounceimp.h
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef NEWPOUNCEIMP_H
#define NEWPOUNCEIMP_H

#include <newpounce.h>
#include <qmultilineedit.h>

class QString;
class QComboBox;

/**
 * \struct pounce
 * \brief Stores data on a pounce.
 */
struct pounce{
 
  /// Buddy name
  QString buddyName;

  /// Pounce on sign-on
  bool signOn;

  /// Pounce on return from away
  bool returnAway;

  /// Pounce on return from idle
  bool returnIdle;

  /// Open a chat window on pounce
  bool openChat;

  /// Whether to send message
  bool sendMessage;

  /// Message to send
  QString message;

  /// Execute a command on pounce
  bool execCommand;

  /// Command to execute
  QString command;

  /// Do not remove this pounce after activation
  bool doNotRemove;

  /// The delete menu ID
  int deleteMenuId;

  /// The edit menu ID
  int editMenuId;

  /// Whether to hide
  bool hidden;

  /// The signon sound (?)
  QString signOnSound;

  /// The signoff sound (?)
  QString signOffSound;

  /// Whether to ignore settings (?)
  bool ignoreSettings; 
};

/**
 * This class manages the NewPounce dialog.  Inherits the uic
 * generated NewPounce class, which does all the GUI work.
 * @author Benjamin Meyer
 */
class NewPounceImp : public NewPounce  {

Q_OBJECT
	
signals:
 
  /// Emitted once the pounce to be added has been verified.
  void addPounce(pounce newPounce);

public:
  /// Constructor. 
  NewPounceImp(QWidget *parent=0, const char *name=0, QString pounceName=0);
  
  /// Destructor.
  ~NewPounceImp();

  /// Set the window pounce information with this pounce.
  void setPounce(pounce *newpounce);

private slots:

  /// Called to copy the settings from the form.
  void verify();
  
  /// Called to close the window.
  void cancelAndClose();

};

#endif

// newpounceimp.h

