/***************************************************************************
                           networkoptionsimp.cpp
                             -------------------
    begin                : Sunday Feb 11 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>

#include "networkoptionsimp.h"

/******************************************************************************
 * Constructor
 ******************************************************************************/
NetworkOptionsImp::NetworkOptionsImp(QWidget *parent, const char *name) : NetworkOptions( parent,name,false ){
	i_aimSettings = setup::settings();
	connect(login_name, SIGNAL(textChanged( const QString &)), this, SLOT(readPassword(const QString&)));
  connect(login_password, SIGNAL(textChanged(const QString &)), this, SLOT(passwordChanged(const QString &)));
  proxy_socks5->setChecked(true);
  proxy_none->setChecked(true);

  ProxyButtonGroup->hide();
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
NetworkOptionsImp::~NetworkOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void NetworkOptionsImp::updateData(){
	i_aimSettings = setup::settings();

	proxy_socks5->setChecked(true);
	
	login_server_toc->setText(i_aimSettings->login_server_toc);
	login_server_login->setText(i_aimSettings->login_server_login);
	login_port_toc->setValue(i_aimSettings->login_port_toc.toInt());
	login_port_login->setValue(i_aimSettings->login_port_login.toInt());
	login_enable_save->setChecked(i_aimSettings->login_enable_save);
	login_enable_auto->setChecked(i_aimSettings->login_enable_auto);
	if (i_aimSettings->proxy_Choice == 0)
			proxy_none->setChecked(true);
	//if (i_aimSettings->proxy_Choice == 1)
	//		proxy_socks4->setChecked(true);
	if (i_aimSettings->proxy_Choice == 2)
			proxy_socks5->setChecked(true);
	proxy_server->setText(i_aimSettings->proxy_server);
	proxy_port->setText(i_aimSettings->proxy_port);
	
  login_name->clear(); 
	login_name->insertStringList( setup::instance()->registeredUsers() );

  for (int i = login_name->count(); i > 0; i--){
    if (login_name->text(i-1) == i_aimSettings->login_name)
      login_name->setCurrentItem(i-1);
  }
  if (login_name->count() == 0)
    login_name->insertItem("<new user>");
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void NetworkOptionsImp::getData(){
  i_aimSettings->login_server_toc = login_server_toc->text();
  i_aimSettings->login_server_login = login_server_login->text();
  i_aimSettings->login_port_toc = login_port_toc->text();
  i_aimSettings->login_port_login = login_port_login->text();
  //i_aimSettings->login_enable_save = login_enable_save->isChecked();
  i_aimSettings->login_enable_auto = login_enable_auto->isChecked();
  //i_aimSettings->login_name = login_name->text();
  //i_aimSettings->login_password = login_password->text();
  if (proxy_none->isChecked())
  i_aimSettings->proxy_Choice = 0;
  //if (proxy_socks4->isChecked())
  //  i_aimSettings->proxy_Choice = 1;
  if (proxy_socks5->isChecked())
    i_aimSettings->proxy_Choice = 2;
  i_aimSettings->proxy_server = proxy_server->text();
  i_aimSettings->proxy_port = proxy_port->text();
}

void NetworkOptionsImp::passwordChanged(const QString &){
  if (login_enable_save->isChecked() == true)
    savePassword(login_name->currentText());
}

/******************************************************************************
 * Saves the password
 ******************************************************************************/
void NetworkOptionsImp::savePassword(const QString &name){
	// The point of this "encryption" is not to accually encrypt the data, but
	// simply to not have the password in plain text 	
	QString plainPass = login_password->text();
	QString crypted;
	int len = plainPass.length();
  for (int i = 0; i < len; i ++){
    int intemp((plainPass.at(i)).unicode());
		intemp += 13;
		QChar temp = intemp;
		crypted += temp;
 	}
	setup::instance()->savePassword(name, crypted);
}

/******************************************************************************
 * Reads the password 
 ******************************************************************************/
void NetworkOptionsImp::readPassword(const QString &name){
	QString password = setup::instance()->readPassword(name);
	// The point of this "encryption" is not to accually encrypt the data, but
	// simply to not have the saved password in plain text 	
	QString decrypted;
	int len = password.length();
  for (int i = 0; i < len; i ++){
    int foo = ((password.at(i)).unicode());
		foo -= 13;
		decrypted += foo;
  }
	login_password->setText(decrypted);
	if (password.isEmpty()){
		login_enable_auto->setChecked(false);
		login_enable_save->setChecked(false);
	} else {
		login_enable_save->setChecked(true);
	}
}

/******************************************************************************
 * Remove the password 
 ******************************************************************************/
void NetworkOptionsImp::removePassword(QString name){
	setup::instance()->removePassword(name);
}

// NetworkOptionsImp.cpp
