/***************************************************************************
                               plugincombobox.h
                             -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAPLUGINCOMBOBOX_H
#define KINKATTAPLUGINCOMBOBOX_H

#include <qcombobox.h>

/**
 * This class is provided as a convenience for plugin developers.  It can
 * be used to put combo boxes in chat windows and be told when a user changes
 * the combo box with that user.  buddy needs to be set for it to work.
 * @author Benjamin Meyer
 */

class KinkattaComboBox : public QComboBox {

Q_OBJECT

signals:
  /// When the selection changes a signal is emitted with the buddy name.
  void changed( QString choice, QString buddy );

public:
  /// Constructor.
  KinkattaComboBox( QWidget *parent=0, const char *name=0 );
  
  /// Deconstructor.
  ~KinkattaComboBox();

  /// The name of the buddy that is used when a signal is emitted.
  QString buddy;

private slots:
  /// Helper function. 
  void choiceChanged( const QString &choice );

};

#endif

// plugincombobox.h

