#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kpcalendarentryinfodialog.h"
#include "kpcalendarview.h"
#include "kpguiutils.h"

#include "../kptraininglog.h"
#include "../kipina-i18n.h"
#include "../kpsettings.h"
#include "../kputil.h"
#include "../kpworkout.h"


static void split_list_row_selected (GtkTreeSelection *selection,
                                     KPCalendarEntryInfoDialog *dialog);

static void set_dialog_splits_view (KPCalendarEntryInfoDialog *dialog,
                                    KPWorkout *wo);

static void set_dialog_fields (KPCalendarEntryInfoDialog *dialog,
                               KPWorkout *wo);
static void kp_calendar_entry_info_dialog_class_init (
                    KPCalendarEntryInfoDialogClass * klass);
static void kp_calendar_entry_info_dialog_init (KPCalendarEntryInfoDialog * dialog);
static void kp_calendar_entry_info_dialog_finalize (GObject * object);
static void kp_calendar_entry_info_dialog_response_cb (GtkDialog * gtkdialog,
                                            int response_id,
                                            KPCalendarEntryInfoDialog * dialog);

typedef struct KPCalendarEntryInfoDialogPrivateData_
{
  GDate *date;

  GtkWidget *date_label;
  GtkWidget *time_label;
  GtkWidget *activity_label;
  GtkWidget *distance_label;
  GtkWidget *duration_label;
  
  GtkWidget *description_label;
  GtkWidget *description_sw;
  
  GtkWidget *splits_view_sw;
  GtkWidget *splits_label;
  GtkWidget *splits_view;

  GtkWidget *hrm_vbox;
  
} KPCalendarEntryInfoDialogPrivateData;

#define KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA(widget) (((KPCalendarEntryInfoDialogPrivateData*) \
        (KP_CALENDAR_ENTRY_INFO_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_calendar_entry_info_dialog_get_type (void)
{
  static GType kp_calendar_entry_info_dialog_type = 0;

  if (kp_calendar_entry_info_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPCalendarEntryInfoDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_calendar_entry_info_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPCalendarEntryInfoDialog),
      0,
      (GInstanceInitFunc) kp_calendar_entry_info_dialog_init,
      NULL,
    };

    kp_calendar_entry_info_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                         "KPCalendarEntryInfoDialog",
                                                         &our_info, 0);
  }

  return kp_calendar_entry_info_dialog_type;
}

static void
kp_calendar_entry_info_dialog_class_init (KPCalendarEntryInfoDialogClass * klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  object_class->finalize = kp_calendar_entry_info_dialog_finalize;
}


static void
kp_calendar_entry_info_dialog_init (KPCalendarEntryInfoDialog * dialog)
{
  KPCalendarEntryInfoDialogPrivateData *p_data;
  GtkWidget *closebutton;
  GladeXML *xml;

  xml = kp_gui_load ("calendar_entry_info_dialog", "calendar_entry_info");

  dialog->private_data = g_new0 (KPCalendarEntryInfoDialogPrivateData, 1);
  p_data = KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA (dialog);

  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Add a new comment to the log."));
  gtk_window_set_modal (GTK_WINDOW (dialog), FALSE);
  
  closebutton = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                       GTK_STOCK_CLOSE,
                                       GTK_RESPONSE_CLOSE);

  p_data->date_label = KP_W (xml, "date_label");
  p_data->time_label = KP_W (xml, "time_label");
  p_data->activity_label = KP_W (xml, "activity_label");
  p_data->distance_label = KP_W (xml, "distance_label");
  p_data->duration_label = KP_W (xml, "duration_label");
  p_data->description_label = KP_W (xml, "description_label");
  p_data->description_sw = KP_W (xml, "description_sw");
  p_data->splits_label = KP_W (xml, "splits_label");
  p_data->splits_view_sw = KP_W (xml, "splits_view_sw");
  p_data->splits_view = KP_W (xml, "splits_view");
  p_data->hrm_vbox = KP_W (xml, "hrm_vbox");
  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "calendar_entry_info"));

  g_signal_connect (G_OBJECT (dialog),
                   "response",
                    G_CALLBACK (kp_calendar_entry_info_dialog_response_cb),
                    dialog);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);

  g_object_unref (G_OBJECT (xml));
}


static void
kp_calendar_entry_info_dialog_finalize (GObject * object)
{
  KPCalendarEntryInfoDialog *dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (KP_IS_CALENDAR_ENTRY_INFO_DIALOG (object));

  dialog = KP_CALENDAR_ENTRY_INFO_DIALOG (object);

  g_return_if_fail (dialog->private_data != NULL);
  g_free (dialog->private_data);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
kp_calendar_entry_info_dialog_new (KPCalendarEntry *entry)
{
  KPCalendarEntryInfoDialogPrivateData *p_data;
  KPCalendarEntryInfoDialog *dialog;

  dialog = g_object_new (KP_TYPE_CALENDAR_ENTRY_INFO_DIALOG, NULL);

  p_data = KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA (dialog);

  if (KP_IS_WORKOUT (entry)) {
    set_dialog_fields (dialog, KP_WORKOUT (entry));
    set_dialog_splits_view (dialog, KP_WORKOUT (entry));
  }
  
  return GTK_WIDGET (dialog);
}

static void
set_dialog_fields (KPCalendarEntryInfoDialog *dialog, KPWorkout *wo)
{
  KPCalendarEntryInfoDialogPrivateData *p_data;
  KPCalendarTime *ct;
  gchar distance[16];
  gchar time[16];
  gchar date[16];
  gchar *duration;
  gdouble dist;
    
  p_data = KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA (dialog);
  ct = KP_CALENDAR_ENTRY (wo)->datetime;

  dist = kp_workout_get_param_double (wo, "distance");
  duration = kp_workout_get_param (wo, "duration");

  g_snprintf (distance, sizeof (distance)-1, "%.3f", dist);
  g_snprintf (time, sizeof (time)-1, "%.2u:%.2u:%.2u", ct->h, ct->m, ct->s);
  g_snprintf (date, sizeof (date)-1, "%u.%u.%u", g_date_get_day (ct->date),
                                                 g_date_get_month (ct->date),
                                                 g_date_get_year (ct->date));

  gtk_label_set_text (GTK_LABEL (p_data->distance_label), distance);
  gtk_label_set_text (GTK_LABEL (p_data->duration_label), duration);
  gtk_label_set_text (GTK_LABEL (p_data->date_label), date);
  gtk_label_set_text (GTK_LABEL (p_data->time_label), time);
  gtk_label_set_text (GTK_LABEL (p_data->activity_label),
                      kp_workout_get_sport (wo));
}


static void
set_dialog_splits_view (KPCalendarEntryInfoDialog *dialog, KPWorkout *wo)
{
  KPCalendarEntryInfoDialogPrivateData *p_data;
  GtkCellRenderer *r_text;
  GtkTreeViewColumn *col;
  GtkTreeSelection *sel;
  GtkTreeIter iter;
  GtkListStore *store;
  KPWorkoutSplit *split;
  gchar *time_str;
  guint i;
  gchar buf[32];
  gchar *title[5] = {N_("Split"),
                     N_("Type"),
                     N_("Distance"),
                     N_("Time"),
                     N_("Comment")};
  GSList *list;
 
  list = kp_workout_get_splits (wo);
  if (list == NULL)
    return;
  
  p_data = KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA (dialog);

  store = gtk_list_store_new (5, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_FLOAT,
                              G_TYPE_STRING, G_TYPE_STRING);

  gtk_tree_view_set_model (GTK_TREE_VIEW (p_data->splits_view),
                           GTK_TREE_MODEL (store));

  r_text = gtk_cell_renderer_text_new ();

  for (i=0; i < 5; i++) {
    col = gtk_tree_view_column_new_with_attributes (title[i], r_text, "text",
                                                    i, NULL);
    gtk_tree_view_column_set_clickable (col, TRUE);
    gtk_tree_view_column_set_sort_column_id (col, i);
    gtk_tree_view_append_column (GTK_TREE_VIEW (p_data->splits_view), col);
  }
  sel = gtk_tree_view_get_selection (GTK_TREE_VIEW (p_data->splits_view));
  gtk_tree_selection_set_mode (sel, GTK_SELECTION_SINGLE);
  
  g_signal_connect (G_OBJECT (sel), "changed",
                    G_CALLBACK (split_list_row_selected), dialog);
 
  while (list) {
    split = (KPWorkoutSplit *) list->data; 
 
    if (split->time)
      time_str = kp_calendar_time_to_str_hmst (split->time);
    else
      time_str = g_strdup ("");
    
    switch (split->type) {
      case KP_WORKOUT_SPLIT_TYPE_NORMAL:
        g_snprintf (buf, sizeof(buf)-1, "%s", _("Normal"));
      break;

      case KP_WORKOUT_SPLIT_TYPE_WARM_UP:
        g_snprintf (buf, sizeof(buf)-1, "%s", _("Warm Up"));
      break;
      
      case KP_WORKOUT_SPLIT_TYPE_COOL_DOWN:
        g_snprintf (buf, sizeof(buf)-1, "%s", _("Cool Down"));
      break;
      
      case KP_WORKOUT_SPLIT_TYPE_RECOVERY:
        g_snprintf (buf, sizeof(buf)-1, "%s", _("Recovery"));
      break;
      
      default:  
        g_snprintf (buf, sizeof(buf)-1, "%s", _("Unknown"));
    }
    
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter,
                        0, split->n,
                        1, buf,
                        2, split->distance,
                        3, time_str,
                        4, split->comment,
                       -1);
    list = list->next;
  }
  
  gtk_widget_show_all (p_data->splits_view_sw);
  gtk_widget_show (p_data->splits_label);
}

static void
split_list_row_selected (GtkTreeSelection *selection,
                         KPCalendarEntryInfoDialog *dialog)
{
  /* Do something */
}

static void
kp_calendar_entry_info_dialog_response_cb (GtkDialog * gtk_dialog,
                                           int response_id,
                                           KPCalendarEntryInfoDialog *dialog)
{
  KPCalendarEntryInfoDialogPrivateData *p_data;
  p_data = KP_CALENDAR_ENTRY_INFO_DIALOG_PRIVATE_DATA (dialog);
}

