/* cmdline.h */

/* File autogenerated by gengetopt version 2.14  */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
#define CMDLINE_PARSER_PACKAGE "lcalc"
#endif

#ifndef CMDLINE_PARSER_VERSION
#define CMDLINE_PARSER_VERSION "1.11 Feb 5, 2008"
#endif

struct gengetopt_args_info
{
  int value_flag;	/* compute L-function at x+iy. Should be used in conjuction with x and y options (default=off).  */
  char * x_arg;	/* Used with value,value-line-segment, and zeros-interval options (default='.5').  */
  char * x_orig;	/* Used with value,value-line-segment, and zeros-interval options original value given at command line.  */
  char * y_arg;	/* Used with value,value-line-segment, and zeros-interval options (default='0').  */
  char * y_orig;	/* Used with value,value-line-segment, and zeros-interval options original value given at command line.  */
  char * value_file_arg;	/* compute L-function at points specified in file.  */
  char * value_file_orig;	/* compute L-function at points specified in file original value given at command line.  */
  int value_line_segment_flag;	/* compute L-function along a line segment connecting (x,y) to (X,Y) at number-sample points (default=off).  */
  char * X_arg;	/* Used with value-line-segment (default='.5').  */
  char * X_orig;	/* Used with value-line-segment original value given at command line.  */
  char * Y_arg;	/* Used with value-line-segment (default='100').  */
  char * Y_orig;	/* Used with value-line-segment original value given at command line.  */
  int number_samples_arg;	/* Used with value-line-segment, and interpolate options (default='1000').  */
  char * number_samples_orig;	/* Used with value-line-segment, and interpolate options original value given at command line.  */
  int zeros_arg;	/* number of zeros to find.  */
  char * zeros_orig;	/* number of zeros to find original value given at command line.  */
  int zeros_interval_flag;	/* number of zeros to find in an interval (1/2+ix,1/2+iy) using steps of size stepsize. Use with the x,y, and stepsize options (default=off).  */
  char * stepsize_arg;	/* Used with zeros-interval.  */
  char * stepsize_orig;	/* Used with zeros-interval original value given at command line.  */
  int derivative_arg;	/* compute derivative. use -d -1 to specify logarithmic derivative..  */
  char * derivative_orig;	/* compute derivative. use -d -1 to specify logarithmic derivative. original value given at command line.  */
  int elliptic_curve_flag;	/* specify an elliptic curve over Q. Use with the a1 a2 a3 a4 a6 options (default=off).  */
  char * a1_arg;	/* Used with the elliptic-curve option.  */
  char * a1_orig;	/* Used with the elliptic-curve option original value given at command line.  */
  char * a2_arg;	/* Used with the elliptic-curve option.  */
  char * a2_orig;	/* Used with the elliptic-curve option original value given at command line.  */
  char * a3_arg;	/* Used with the elliptic-curve option.  */
  char * a3_orig;	/* Used with the elliptic-curve option original value given at command line.  */
  char * a4_arg;	/* Used with the elliptic-curve option.  */
  char * a4_orig;	/* Used with the elliptic-curve option original value given at command line.  */
  char * a6_arg;	/* Used with the elliptic-curve option.  */
  char * a6_orig;	/* Used with the elliptic-curve option original value given at command line.  */
  char * file_input_arg;	/* input a file with basic L-function data.  */
  char * file_input_orig;	/* input a file with basic L-function data original value given at command line.  */
  char * url_arg;	/* input a web based file with basic L-function data. Specify the url of the file.  */
  char * url_orig;	/* input a web based file with basic L-function data. Specify the url of the file original value given at command line.  */
  char * interpolate_arg;	/* interpolate between two L-functions and find their zeros. Should be used in conjunction with file-input.  */
  char * interpolate_orig;	/* interpolate between two L-functions and find their zeros. Should be used in conjunction with file-input original value given at command line.  */
  char * output_character_arg;	/* if twisting, output the character (default='1').  */
  char * output_character_orig;	/* if twisting, output the character original value given at command line.  */
  int output_data_arg;	/* output basic data for the underlying L-function (default='10').  */
  char * output_data_orig;	/* output basic data for the underlying L-function original value given at command line.  */
  int verbose_arg;	/* verbosity > 0 outputs extra info (default='0').  */
  char * verbose_orig;	/* verbosity > 0 outputs extra info original value given at command line.  */
  int precision_arg;	/* number digits precision (default='14').  */
  char * precision_orig;	/* number digits precision original value given at command line.  */
  int sacrifice_arg;	/* number digits to sacrifice (default='2').  */
  char * sacrifice_orig;	/* number digits to sacrifice original value given at command line.  */
  int rank_compute_flag;	/* compute the rank (default=off).  */
  int rank_verify_arg;	/* verify if specified rank is correct.  */
  char * rank_verify_orig;	/* verify if specified rank is correct original value given at command line.  */
  int rank_limit_arg;	/* when doing quadratic twists limit to L-functions with specified rank.  */
  char * rank_limit_orig;	/* when doing quadratic twists limit to L-functions with specified rank original value given at command line.  */
  int tau_flag;	/* Ramanujan tau L-function (weight 12, full level) (default=off).  */
  int twist_quadratic_flag;	/* twist by fundamental quadratic characters, start <= discriminant <= finish. Use with start and finish options. (default=off).  */
  char * start_arg;	/* Used with various twisting options.  */
  char * start_orig;	/* Used with various twisting options original value given at command line.  */
  char * finish_arg;	/* Used with various twisting options. Default has finish=start.  */
  char * finish_orig;	/* Used with various twisting options. Default has finish=start original value given at command line.  */
  int twist_quadratic_even_flag;	/* twist by fundamental quadratic characters, even functional eqn, start <= discriminant <= finish (default=off).  */
  int twist_primitive_flag;	/* twist by all primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate characters are considered equaivalent (default=off).  */
  int twist_all_flag;	/* twist by all Dirichlet characters with start <= conductor <= finish. (default=off).  */
  int twist_all_no_conj_pairs_flag;	/* twist by all Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent (default=off).  */
  int twist_complex_no_conj_pairs_flag;	/* twist by all complex primitive Dirichlet characters with start <= conductor <= finish. For L-functions with complex Dirichlet coefficients, conjugate pairs of characters are considered equivalent (default=off).  */
  int twist_generic_flag;	/* twist by a generic complex Dirichlet characters with start <= conductor <= finish. (default=off).  */
  int degree_arg;	/* can only be used in conjuction with twist-primitive (?). Select characters of specified degree. Not yet implemented.  */
  char * degree_orig;	/* can only be used in conjuction with twist-primitive (?). Select characters of specified degree. Not yet implemented original value given at command line.  */
  
  int help_given ;	/* Whether help was given.  */
  int version_given ;	/* Whether version was given.  */
  int value_given ;	/* Whether value was given.  */
  int x_given ;	/* Whether x was given.  */
  int y_given ;	/* Whether y was given.  */
  int value_file_given ;	/* Whether value-file was given.  */
  int value_line_segment_given ;	/* Whether value-line-segment was given.  */
  int X_given ;	/* Whether X was given.  */
  int Y_given ;	/* Whether Y was given.  */
  int number_samples_given ;	/* Whether number-samples was given.  */
  int zeros_given ;	/* Whether zeros was given.  */
  int zeros_interval_given ;	/* Whether zeros-interval was given.  */
  int stepsize_given ;	/* Whether stepsize was given.  */
  int derivative_given ;	/* Whether derivative was given.  */
  int elliptic_curve_given ;	/* Whether elliptic-curve was given.  */
  int a1_given ;	/* Whether a1 was given.  */
  int a2_given ;	/* Whether a2 was given.  */
  int a3_given ;	/* Whether a3 was given.  */
  int a4_given ;	/* Whether a4 was given.  */
  int a6_given ;	/* Whether a6 was given.  */
  int file_input_given ;	/* Whether file-input was given.  */
  int url_given ;	/* Whether url was given.  */
  int interpolate_given ;	/* Whether interpolate was given.  */
  int output_character_given ;	/* Whether output-character was given.  */
  int output_data_given ;	/* Whether output-data was given.  */
  int verbose_given ;	/* Whether verbose was given.  */
  int precision_given ;	/* Whether precision was given.  */
  int sacrifice_given ;	/* Whether sacrifice was given.  */
  int rank_compute_given ;	/* Whether rank-compute was given.  */
  int rank_verify_given ;	/* Whether rank-verify was given.  */
  int rank_limit_given ;	/* Whether rank-limit was given.  */
  int tau_given ;	/* Whether tau was given.  */
  int twist_quadratic_given ;	/* Whether twist-quadratic was given.  */
  int start_given ;	/* Whether start was given.  */
  int finish_given ;	/* Whether finish was given.  */
  int twist_quadratic_even_given ;	/* Whether twist-quadratic-even was given.  */
  int twist_primitive_given ;	/* Whether twist-primitive was given.  */
  int twist_all_given ;	/* Whether twist-all was given.  */
  int twist_all_no_conj_pairs_given ;	/* Whether twist-all-no-conj-pairs was given.  */
  int twist_complex_no_conj_pairs_given ;	/* Whether twist-complex-no-conj-pairs was given.  */
  int twist_generic_given ;	/* Whether twist-generic was given.  */
  int degree_given ;	/* Whether degree was given.  */

} ;

int cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info);
int cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required);
int cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info);

void cmdline_parser_print_help(void);
void cmdline_parser_print_version(void);

void cmdline_parser_init (struct gengetopt_args_info *args_info);
void cmdline_parser_free (struct gengetopt_args_info *args_info);

int cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name);

extern char *cmdline_parser_output_character_values[] ;	/* Possible values for output-character.  */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
