'use strict'

const path    = require('path')
const resolve = require('rollup-plugin-node-resolve')
const common  = require('rollup-plugin-commonjs')
const babel   = require('rollup-plugin-babel')

const BUNDLE  = process.env.BUNDLE === 'true'

let fileDest  = 'less.js'
const plugins = [
  resolve({
    customResolveOptions: {
      moduleDirectory: ['/usr/share/nodejs']
    }
  }),
  common(),
  babel(),
]
module.exports = {
  input: 'lib/less-browser/bootstrap.js',
  output: {
    file: path.resolve(__dirname, `../dist/${fileDest}`),
    format: 'umd',
    name: 'less'
  },
  plugins
}
