#!/bin/sh

#
# Line6 Linux USB driver - 0.6
#
# Copyright (C) 2005, 2006 Markus Grabner (grabner@icg.tugraz.at)
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License as
#	published by the Free Software Foundation, version 2.
#

# transfer data for all channels, effects, and amp setups from the PODxt Pro

SYSDIR=`line6_find_device.pl sysdir POD`
mkdir -p data

function retrieve_data
{
    for i in `seq -f "%03g" 0 $2`; do
	echo $i > $SYSDIR/retrieve_$1
	name=`cat $SYSDIR/name_buf | tr " /" "__"`
	echo "retrieving $1 #$i: $name"
	cp $SYSDIR/dump_buf data/${1}_${i}_${name}.pod
    done
}

retrieve_data channel 127
retrieve_data effects_setup 63
retrieve_data amp_setup 63
