#!/bin/sh

echo "#ifndef DRIVER_REVISION" > revision_new.h

if test -d .svn; then
    echo "/* current subversion revision */" >> revision_new.h
    echo "#define DRIVER_REVISION \" (revision $(svnversion))\"" >> revision_new.h
else
    echo "/* current subversion revision not available */" >> revision_new.h
    echo "#define DRIVER_REVISION \"\"" >> revision_new.h
fi

echo "#endif" >> revision_new.h

if diff --brief revision.h revision_new.h > /dev/null 2>&1; then
    rm -f revision_new.h
else
    mv revision_new.h revision.h
fi
