package tests::ReportTableInfoTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::Config::Index;
use Lire::Report::TableInfo;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'table_info'} = new Lire::Report::TableInfo();
    $self->{'_old_reg'} = \%Lire::Config::Index::REGISTRY;
    %Lire::Config::Index::REGISTRY = ();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    *Lire::Config::Index::REGISTRY = $self->{'_old_reg'};

    return;
}

sub test_set_variables_indices {
    my $self = $_[0];

    $self->{'table_info'}->set_variables_indices();
    $self->assert( Lire::Config::Index->has_index( 'variables' ) ? 1 : 0,
                   'variables' );
    $self->assert_str_equals( $self->{'table_info'},
                              Lire::Config::Index->get_index( 'variables' )->table_info() );
    $self->assert_str_equals( 'both',
                              Lire::Config::Index->get_index( 'variables' )->type() );

    $self->assert( Lire::Config::Index->has_index( 'categorical_variables' ) ? 1 : 0,
                   'categorical_variables' );
    $self->assert_str_equals( $self->{'table_info'},
                              Lire::Config::Index->get_index( 'categorical_variables' )->table_info() );
    $self->assert_str_equals( 'categorical',
                              Lire::Config::Index->get_index( 'categorical_variables' )->type() );

    $self->assert( Lire::Config::Index->has_index( 'variables' ) ? 1 : 0,
                   'variables' );
    $self->assert_str_equals( $self->{'table_info'},
                              Lire::Config::Index->get_index( 'numerical_variables' )->table_info() );
    $self->assert_str_equals( 'numerical',
                              Lire::Config::Index->get_index( 'numerical_variables' )->type() );

    $self->{'table_info'}->reset_variables_indices();
    $self->assert( !Lire::Config::Index->has_index( 'variables' ) ? 1 : 0,
                   'variables' );
    $self->assert( !Lire::Config::Index->has_index( 'categorical_variables' ) ? 1 : 0,
                   'categorical_variables' );
    $self->assert( !Lire::Config::Index->has_index( 'numerical_variables' ) ? 1 : 0,
                   'numerical_variables' );

}

sub test_header_rows {
    my $self = $_[0];

    my $table_info = new Lire::Report::TableInfo();
    my $name1 = $table_info->create_column_info( 'name1', 'categorical',
                                                 'string' );
    my $group1 = $table_info->create_group_info( 'group1' );
    my $name2 =  $group1->create_column_info( 'name2', 'categorical',
                                              'string' );
    my $group2 = $group1->create_group_info( 'group2' );
    my $name3 =  $group2->create_column_info( 'name3', 'categorical',
                                              'string' );
    my $value1 = $group2->create_column_info( 'value1', 'numerical', 'int' );
    my $group3 = $table_info->create_group_info( 'group3' );
    my $name4 = $group3->create_column_info( 'name4', 'categorical',
                                             'string' );
    my $value2 = $group3->create_column_info( 'value2', 'numerical', 'int' );

    $table_info->compute_group_layout();
    $self->assert_deep_equals( [ [ $name1, undef, undef,$value1,undef,$value2],
                                 [ undef, $name2, undef, undef, $name4, undef],
                                 [ undef, undef,  $name3, undef, undef, undef] ],
                               $table_info->header_rows() );
}

1;
