// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "ConfigUI.h"
//Copyright (c) 2002-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later

void ConfigUI::cb_configwindow_i(Fl_Double_Window* o, void*) {
  writebankcfg();
o->hide();
}
void ConfigUI::cb_configwindow(Fl_Double_Window* o, void* v) {
  ((ConfigUI*)(o->user_data()))->cb_configwindow_i(o,v);
}

void ConfigUI::cb__i(Fl_Choice* o, void*) {
  if ((int)o->value()==0) samplerateinput->activate();
       else samplerateinput->deactivate();

int samplerates[8]={44100,16000,22050,32000,44100,48000,88200,96000};
config.cfg.SampleRate=samplerates[(int)o->value()];

setsamplerateinput();
}
void ConfigUI::cb_(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

Fl_Menu_Item ConfigUI::menu_[] = {
 {"Custom", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"16000Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"22050Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"32000Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"44100Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"48000Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"88200Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"96000Hz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void ConfigUI::cb_samplerateinput_i(Fl_Input* o, void*) {
  char *tmp;
config.cfg.SampleRate=strtoul(o->value(),&tmp,10);
}
void ConfigUI::cb_samplerateinput(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_samplerateinput_i(o,v);
}

void ConfigUI::cb_Buffer_i(Fl_Input* o, void*) {
  char *tmp;
config.cfg.SoundBufferSize=strtoul(o->value(),&tmp,10);
}
void ConfigUI::cb_Buffer(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Buffer_i(o,v);
}

void ConfigUI::cb_Swap_i(Fl_Light_Button* o, void*) {
  config.cfg.SwapStereo=(int) o->value();
}
void ConfigUI::cb_Swap(Fl_Light_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Swap_i(o,v);
}

void ConfigUI::cb_OscilSize_i(Fl_Choice* o, void*) {
  config.cfg.OscilSize=128<<o->value();
}
void ConfigUI::cb_OscilSize(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_OscilSize_i(o,v);
}

Fl_Menu_Item ConfigUI::menu_OscilSize[] = {
 {"128", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"256", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"512", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"1024", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"2048", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"4096", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"8192", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"16384", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void ConfigUI::cb_Dump_i(Fl_File_Input* o, void*) {
  snprintf(config.cfg.DumpFile,config.maxstringsize,"%s",o->value());
}
void ConfigUI::cb_Dump(Fl_File_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Dump_i(o,v);
}

void ConfigUI::cb_Dump1_i(Fl_Check_Button* o, void*) {
  config.cfg.DumpNotesToFile=(int) o->value();
dump.startnow();//this has effect only if this option was disabled;
}
void ConfigUI::cb_Dump1(Fl_Check_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Dump1_i(o,v);
}

void ConfigUI::cb_Append_i(Fl_Check_Button* o, void*) {
  config.cfg.DumpAppend=(int) o->value();
}
void ConfigUI::cb_Append(Fl_Check_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Append_i(o,v);
}

void ConfigUI::cb_OSS_i(Fl_File_Input* o, void*) {
  snprintf(config.cfg.LinuxOSSSeqInDev,config.maxstringsize,"%s",o->value());
}
void ConfigUI::cb_OSS(Fl_File_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_OSS_i(o,v);
}

void ConfigUI::cb_OSS1_i(Fl_File_Input* o, void*) {
  snprintf(config.cfg.LinuxOSSWaveOutDev,config.maxstringsize,"%s",o->value());
}
void ConfigUI::cb_OSS1(Fl_File_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_OSS1_i(o,v);
}

void ConfigUI::cb_Midi_i(Fl_Counter* o, void*) {
  config.cfg.WindowsMidiInId=(int) o->value();
midiinputnamebox->label(config.winmididevices[config.cfg.WindowsMidiInId].name);
}
void ConfigUI::cb_Midi(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Midi_i(o,v);
}

void ConfigUI::cb_XML_i(Fl_Counter* o, void*) {
  config.cfg.GzipCompression=(int) o->value();
}
void ConfigUI::cb_XML(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_XML_i(o,v);
}

void ConfigUI::cb_PADsynth_i(Fl_Choice* o, void*) {
  config.cfg.Interpolation=(int) o->value();
}
void ConfigUI::cb_PADsynth(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_PADsynth_i(o,v);
}

Fl_Menu_Item ConfigUI::menu_PADsynth[] = {
 {"Linear(fast)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Cubic(slow)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void ConfigUI::cb_Virtual_i(Fl_Choice* o, void*) {
  config.cfg.VirKeybLayout=(int) o->value();;
}
void ConfigUI::cb_Virtual(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Virtual_i(o,v);
}

Fl_Menu_Item ConfigUI::menu_Virtual[] = {
 {" ", 0,  0, 0, 1, FL_NORMAL_LABEL, 1, 11, 0},
 {"QWERTY", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Dvorak", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"QWERTZ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"AZERTY", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void ConfigUI::cb_rootsbrowse_i(Fl_Browser* o, void*) {
  activatebutton_rootdir(o->value()!=0);
}
void ConfigUI::cb_rootsbrowse(Fl_Browser* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_rootsbrowse_i(o,v);
}

void ConfigUI::cb_Add_i(Fl_Button*, void*) {
  const char *dirname;
dirname=fl_dir_chooser("Add a root directory for banks:",NULL,0);
if (dirname==NULL) return;

rootsbrowse->add(dirname);
}
void ConfigUI::cb_Add(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Add_i(o,v);
}

void ConfigUI::cb_removerootdirbutton_i(Fl_Button*, void*) {
  if (rootsbrowse->value()!=0) {
   rootsbrowse->remove(rootsbrowse->value());
};
activatebutton_rootdir(false);
}
void ConfigUI::cb_removerootdirbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_removerootdirbutton_i(o,v);
}

void ConfigUI::cb_makedefaultrootdirbutton_i(Fl_Button*, void*) {
  int n=rootsbrowse->value();

if (n!=0) {
   rootsbrowse->move(1,n);
   rootsbrowse->value(1);
   rootsbrowse->redraw();
};
activatebutton_rootdir(true);
}
void ConfigUI::cb_makedefaultrootdirbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_makedefaultrootdirbutton_i(o,v);
}

void ConfigUI::cb_presetbrowse_i(Fl_Browser* o, void*) {
  activatebutton_presetdir(o->value()!=0);
}
void ConfigUI::cb_presetbrowse(Fl_Browser* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_presetbrowse_i(o,v);
}

void ConfigUI::cb_Add1_i(Fl_Button*, void*) {
  const char *dirname;
dirname=fl_dir_chooser("Add a preset directory :",NULL,0);
if (dirname==NULL) return;

presetbrowse->add(dirname);
}
void ConfigUI::cb_Add1(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Add1_i(o,v);
}

void ConfigUI::cb_removepresetbutton_i(Fl_Button*, void*) {
  if (presetbrowse->value()!=0) {
   presetbrowse->remove(presetbrowse->value());
};
activatebutton_presetdir(false);
}
void ConfigUI::cb_removepresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_removepresetbutton_i(o,v);
}

void ConfigUI::cb_makedefaultpresetbutton_i(Fl_Button*, void*) {
  int n=presetbrowse->value();

if (n!=0) {
   presetbrowse->move(1,n);
   presetbrowse->value(1);
   presetbrowse->redraw();
};
activatebutton_presetdir(true);
}
void ConfigUI::cb_makedefaultpresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_makedefaultpresetbutton_i(o,v);
}

void ConfigUI::cb_Close_i(Fl_Button*, void*) {
  configwindow->hide();
writebankcfg();
writepresetcfg();
}
void ConfigUI::cb_Close(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

Fl_Double_Window* ConfigUI::make_window() {
  { configwindow = new Fl_Double_Window(510, 340, "ZynAddSubFX Settings");
    configwindow->callback((Fl_Callback*)cb_configwindow, (void*)(this));
    { Fl_Tabs* o = new Fl_Tabs(5, 5, 500, 305);
      { Fl_Group* o = new Fl_Group(5, 25, 500, 285, "Main settings");
        { Fl_Group* o = new Fl_Group(15, 45, 165, 30, "Sample Rate");
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Choice* o = new Fl_Choice(20, 50, 85, 20);
            o->down_box(FL_BORDER_BOX);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_);
            o->menu(menu_);
            o->value(getsamplerateorder());
          } // Fl_Choice* o
          { Fl_Input* o = samplerateinput = new Fl_Input(115, 50, 60, 20);
            samplerateinput->type(2);
            samplerateinput->textfont(1);
            samplerateinput->callback((Fl_Callback*)cb_samplerateinput);
            setsamplerateinput();
            if (getsamplerateorder()!=0) o->deactivate();
          } // Fl_Input* samplerateinput
          o->end();
        } // Fl_Group* o
        { Fl_Input* o = new Fl_Input(190, 45, 60, 20, "Buffer Size");
          o->tooltip("Internal Sound Buffer Size (samples)");
          o->type(2);
          o->labelsize(11);
          o->textfont(1);
          o->callback((Fl_Callback*)cb_Buffer);
          o->align(Fl_Align(129));
          char *tmpbuf=new char[100];o->cut(0,o->maximum_size());
          snprintf(tmpbuf,100,"%d",config.cfg.SoundBufferSize);o->insert(tmpbuf);
          delete []tmpbuf;
        } // Fl_Input* o
        { Fl_Light_Button* o = new Fl_Light_Button(20, 80, 85, 20, "Swap Stereo ");
          o->box(FL_THIN_UP_BOX);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Swap);
          o->value(config.cfg.SwapStereo);
        } // Fl_Light_Button* o
        { Fl_Choice* o = new Fl_Choice(175, 80, 75, 20, "OscilSize");
          o->tooltip("ADSynth Oscillator Size (samples)");
          o->down_box(FL_BORDER_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_OscilSize);
          o->menu(menu_OscilSize);
          o->value( (int) (log(config.cfg.OscilSize/128.0-1.0)/log(2)) +1);
        } // Fl_Choice* o
        { Fl_Box* o = new Fl_Box(15, 275, 235, 30, "Most settings has effect only after ZynAddSubFX is restarted.");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(10, 255, 240, 20, "Read the Readme.txt for other settings");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* o
        { Fl_Group* o = new Fl_Group(15, 125, 230, 85);
          o->box(FL_ENGRAVED_BOX);
          { Fl_File_Input* o = new Fl_File_Input(20, 170, 220, 35, "Dump File");
            o->callback((Fl_Callback*)cb_Dump);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->insert(config.cfg.DumpFile);
          } // Fl_File_Input* o
          { Fl_Check_Button* o = new Fl_Check_Button(20, 130, 100, 20, "Dump notes");
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Dump1);
            o->value(config.cfg.DumpNotesToFile);
          } // Fl_Check_Button* o
          { Fl_Check_Button* o = new Fl_Check_Button(160, 130, 80, 20, "Append");
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Append);
            o->value(config.cfg.DumpAppend);
          } // Fl_Check_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(255, 45, 245, 260);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Box* o = new Fl_Box(260, 50, 235, 45, "Note: Not all the following settings are used (this depends on the operating \
system, etc..)");
            o->labelfont(1);
            o->labelsize(11);
            o->align(Fl_Align(FL_ALIGN_WRAP));
          } // Fl_Box* o
          { Fl_Group* o = new Fl_Group(260, 110, 235, 115, "Linux");
            o->box(FL_ENGRAVED_BOX);
            o->labelfont(1);
            o->labelsize(13);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            { Fl_File_Input* o = new Fl_File_Input(265, 180, 225, 35, "OSS Sequencer Device (/dev/...)");
              o->callback((Fl_Callback*)cb_OSS);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->insert(config.cfg.LinuxOSSSeqInDev);
            } // Fl_File_Input* o
            { Fl_File_Input* o = new Fl_File_Input(265, 130, 225, 35, "OSS Wave Out Device (/dev/...)");
              o->callback((Fl_Callback*)cb_OSS1);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->insert(config.cfg.LinuxOSSWaveOutDev);
            } // Fl_File_Input* o
            o->end();
          } // Fl_Group* o
          { Fl_Group* o = new Fl_Group(260, 250, 235, 50, "Windows");
            o->box(FL_ENGRAVED_BOX);
            o->labelfont(1);
            o->labelsize(13);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            { Fl_Counter* o = new Fl_Counter(270, 270, 65, 20, "Midi In Dev");
              o->type(1);
              o->labelsize(11);
              o->minimum(0);
              o->maximum(100);
              o->step(1);
              o->callback((Fl_Callback*)cb_Midi);
              o->align(Fl_Align(FL_ALIGN_TOP));
              o->maximum(config.winmidimax-1);
              o->value(config.cfg.WindowsMidiInId);
            } // Fl_Counter* o
            { Fl_Box* o = midiinputnamebox = new Fl_Box(340, 260, 150, 35, "Midi input device name");
              midiinputnamebox->labelfont(1);
              midiinputnamebox->labelsize(11);
              midiinputnamebox->align(Fl_Align(196|FL_ALIGN_INSIDE));
              o->label(config.winmididevices[config.cfg.WindowsMidiInId].name);
            } // Fl_Box* midiinputnamebox
            o->end();
          } // Fl_Group* o
          o->end();
        } // Fl_Group* o
        { Fl_Counter* o = new Fl_Counter(20, 215, 65, 15, "XML compression level");
          o->tooltip("gzip compression level (0 - uncompressed)");
          o->type(1);
          o->labelsize(11);
          o->minimum(0);
          o->maximum(9);
          o->step(1);
          o->callback((Fl_Callback*)cb_XML);
          o->align(Fl_Align(FL_ALIGN_RIGHT));
          o->value(config.cfg.GzipCompression);
        } // Fl_Counter* o
        { Fl_Choice* o = new Fl_Choice(175, 105, 75, 15, "PADsynth Interpolation");
          o->down_box(FL_BORDER_BOX);
          o->labelsize(10);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_PADsynth);
          o->menu(menu_PADsynth);
          o->value(config.cfg.Interpolation);
        } // Fl_Choice* o
        { Fl_Choice* o = new Fl_Choice(155, 235, 85, 20, "Virtual Keyboard Layout");
          o->down_box(FL_BORDER_BOX);
          o->labelsize(12);
          o->textfont(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Virtual);
          o->menu(menu_Virtual);
          o->value(config.cfg.VirKeybLayout);
        } // Fl_Choice* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(5, 25, 500, 285, "Bank root dirs");
        o->hide();
        { rootsbrowse = new Fl_Browser(15, 35, 485, 220);
          rootsbrowse->type(2);
          rootsbrowse->callback((Fl_Callback*)cb_rootsbrowse);
        } // Fl_Browser* rootsbrowse
        { Fl_Button* o = new Fl_Button(15, 265, 80, 35, "Add root directory...");
          o->box(FL_THIN_UP_BOX);
          o->callback((Fl_Callback*)cb_Add);
          o->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Button* o
        { Fl_Button* o = removerootdirbutton = new Fl_Button(105, 265, 80, 35, "Remove root dir...");
          removerootdirbutton->box(FL_THIN_UP_BOX);
          removerootdirbutton->callback((Fl_Callback*)cb_removerootdirbutton);
          removerootdirbutton->align(Fl_Align(FL_ALIGN_WRAP));
          o->deactivate();
        } // Fl_Button* removerootdirbutton
        { Fl_Button* o = makedefaultrootdirbutton = new Fl_Button(190, 265, 80, 35, "Make default");
          makedefaultrootdirbutton->box(FL_THIN_UP_BOX);
          makedefaultrootdirbutton->callback((Fl_Callback*)cb_makedefaultrootdirbutton);
          makedefaultrootdirbutton->align(Fl_Align(FL_ALIGN_WRAP));
          o->deactivate();
        } // Fl_Button* makedefaultrootdirbutton
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(5, 25, 500, 285, "Presets dirs");
        o->hide();
        { presetbrowse = new Fl_Browser(15, 35, 485, 220);
          presetbrowse->type(2);
          presetbrowse->callback((Fl_Callback*)cb_presetbrowse);
        } // Fl_Browser* presetbrowse
        { Fl_Button* o = new Fl_Button(15, 265, 80, 35, "Add preset directory...");
          o->box(FL_THIN_UP_BOX);
          o->callback((Fl_Callback*)cb_Add1);
          o->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Button* o
        { Fl_Button* o = removepresetbutton = new Fl_Button(105, 265, 80, 35, "Remove preset dir...");
          removepresetbutton->box(FL_THIN_UP_BOX);
          removepresetbutton->callback((Fl_Callback*)cb_removepresetbutton);
          removepresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
          o->deactivate();
        } // Fl_Button* removepresetbutton
        { Fl_Button* o = makedefaultpresetbutton = new Fl_Button(190, 265, 80, 35, "Make default");
          makedefaultpresetbutton->box(FL_THIN_UP_BOX);
          makedefaultpresetbutton->callback((Fl_Callback*)cb_makedefaultpresetbutton);
          makedefaultpresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
          o->deactivate();
        } // Fl_Button* makedefaultpresetbutton
        o->end();
      } // Fl_Group* o
      o->end();
    } // Fl_Tabs* o
    { Fl_Button* o = new Fl_Button(200, 315, 105, 20, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    configwindow->end();
  } // Fl_Double_Window* configwindow
  return configwindow;
}

ConfigUI::ConfigUI() {
  make_window();
readbankcfg();
readpresetcfg();
}

void ConfigUI::activatebutton_rootdir(bool active) {
  if (active) {
	removerootdirbutton->activate();
	makedefaultrootdirbutton->activate();
}else{
	removerootdirbutton->deactivate();
	makedefaultrootdirbutton->deactivate();
};
}

void ConfigUI::activatebutton_presetdir(bool active) {
  if (active) {
	removepresetbutton->activate();
	makedefaultpresetbutton->activate();
}else{
	removepresetbutton->deactivate();
	makedefaultpresetbutton->deactivate();
};
}

void ConfigUI::readbankcfg() {
  rootsbrowse->clear();

for (int i=0;i<MAX_BANK_ROOT_DIRS;i++){
  if (config.cfg.bankRootDirList[i]!=NULL) rootsbrowse->add(config.cfg.bankRootDirList[i]);
};
}

void ConfigUI::writebankcfg() {
  config.clearbankrootdirlist();

for (int n=0;n<rootsbrowse->size();n++){ 
     config.cfg.bankRootDirList[n]=new char [MAX_STRING_SIZE];
     strncpy(config.cfg.bankRootDirList[n],rootsbrowse->text(n+1),MAX_STRING_SIZE);
};
}

void ConfigUI::readpresetcfg() {
  presetbrowse->clear();

for (int i=0;i<MAX_BANK_ROOT_DIRS;i++){
  if (config.cfg.presetsDirList[i]!=NULL) presetbrowse->add(config.cfg.presetsDirList[i]);
};
}

void ConfigUI::writepresetcfg() {
  config.clearpresetsdirlist();

for (int n=0;n<presetbrowse->size();n++){ 
     config.cfg.presetsDirList[n]=new char [MAX_STRING_SIZE];
     strncpy(config.cfg.presetsDirList[n],presetbrowse->text(n+1),MAX_STRING_SIZE);
};
}

int ConfigUI::getsamplerateorder() {
  int smpr=config.cfg.SampleRate;
int order=0;
switch(smpr){
   case 16000:order=1;break;
   case 22050:order=2;break;
   case 32000:order=3;break;
   case 44100:order=4;break;
   case 48000:order=5;break;
   case 88200:order=6;break;
   case 96000:order=7;break;
   default:order=0;break;
};
return(order);
}

void ConfigUI::setsamplerateinput() {
  char *tmpbuf=new char[100];
samplerateinput->cut(0,samplerateinput->maximum_size());
snprintf(tmpbuf,100,"%d",config.cfg.SampleRate);
samplerateinput->insert(tmpbuf);
delete []tmpbuf;
}

void ConfigUI::show() {
  configwindow->show();
}
