------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2008                            --
--                                 AdaCore                                  --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

--  ~ MAIN [XMLADA]

with Ada.Calendar;
with Ada.Exceptions;
with Ada.Text_IO;

with R_Hello_Timeout_Demo.Client;
with R_Hello_Timeout_Demo.Server;

procedure Test_SOAP_Timeout is

   use Ada;
   use Ada.Exceptions;

   procedure Start_Time;
   --  Record starting time

   procedure Stop_Time;
   --  Record ending time

   procedure Check_Duration (D : in Duration; Message : in String);
   --  Check that duration is about D seconds

   Start, Stop : Calendar.Time;

   --------------------
   -- Check_Duration --
   --------------------

   procedure Check_Duration (D : in Duration; Message : in String) is
      use type Calendar.Time;
      Elaps : constant Duration := Stop - Start - D;
   begin
      if abs (Elaps) < 0.2 then
         Text_IO.Put_Line ("OK:" & Message);
      else
         Text_IO.Put_Line ("NOK:" & Message & ", " & Duration'Image (Elaps));
      end if;
   end Check_Duration;

   ----------------
   -- Start_Time --
   ----------------

   procedure Start_Time is
   begin
      Start := Calendar.Clock;
   end Start_Time;

   ---------------
   -- Stop_Time --
   ---------------

   procedure Stop_Time is
   begin
      Stop := Calendar.Clock;
   end Stop_Time;

begin
   Start_Time;
   declare
      R : constant String := R_Hello_Timeout_Demo.Client.sayHello
        ("pascal",
         Endpoint => "http://www.google.com:9856",
         Timeouts => (4.0, 2.0, 1.0));
   begin
      Text_IO.Put_Line ("Result: '" & R & ''');
   end;
exception
   when E : others =>
      Stop_Time;
      Check_Duration (4.0, "SOAP");
      Text_IO.Put_Line ("Exception: " & Exception_Name (E));
      Text_IO.Put_Line ("Exception: " & Exception_Message (E));
end Test_SOAP_Timeout;
