// -*- C++ -*-
#include <ept/config.h>
#include <ept/core/desktop.h>
#include <ept/core/list.h>
#include <ept/test.h>

using namespace ept::core;

struct TestDesktop {
    desktop::Source desk;
    ept::Token t;

    TestDesktop() : desk( TEST_ENV_DIR "desktop" ) {}

    template< desktop::PropertyId P, typename L >
    void checkIteration2( int c, const char **check, L l ) {
        int i = 0;
        while ( !l.empty() ) {
            assert_eq( l.head().template get< P >(), check[ i ] );
            l = l.tail();
            ++ i;
        }
        assert_eq( i, c );
    }

    template< desktop::PropertyId P, typename L >
    void checkIteration( int c, const char **check, L l ) {
        checkIteration2< P >( c, check, list::sort( l ) );
    }

    Test iteration() {
        const char *check[] = { "X-Server", "XQF", "foo", "Kdict" };
        checkIteration< desktop::Name >(
            4, check, desk.list< desktop::Name >() );
    }

    Test groupProperty() {
        const char *check[] = {
            "{ KDE, Qt, X-KDE-information }",
            "{ Application, Game, X-SuSE-Core-Game }",
            "{ KDE, Qt, Utility }",
            "{ KDE, Qt, Utility }" };
        checkIteration< desktop::Group >(
            4, check, desk.list< desktop::Name >() );
    }

    Test groups() {
        const char *check[] = { "foo", "Kdict" };
        checkIteration< desktop::Name >(
            2, check, desk.group( "{ KDE, Qt, Utility }" ) );
    }

    Test groupList() {
        std::string check[] = { 
            "{ Application, Game, X-SuSE-Core-Game }",
            "{ KDE, Qt, Utility }",
            "{ KDE, Qt, X-KDE-information }",
        };

        assert_list_eq( desk.groupList(), check );
    }

    Test emptyGroupList() {
        desktop::InternalList l;
        assert( l.empty() );
    }
};
