#ifndef _IEC61883_CIP_PRIVATE_H
#define _IEC61883_CIP_PRIVATE_H

#include <libraw1394/raw1394.h>
#include <endian.h>

#define IEC61883_FMT_DV 0x00
#define IEC61883_FMT_AMDTP 0x10
#define IEC61883_FMT_MPEG2 0x20

#define CIP_TRANSFER_DELAY 9000

#if __BYTE_ORDER == __BIG_ENDIAN

struct iec61883_packet {
	/* First quadlet */
	unsigned int dbs      : 8;
	unsigned int eoh0     : 2;
	unsigned int sid      : 6;

	unsigned int dbc      : 8;
	unsigned int fn       : 2;
	unsigned int qpc      : 3;
	unsigned int sph      : 1;
	unsigned int reserved : 2;

	/* Second quadlet */
	unsigned int fdf      : 8;
	unsigned int eoh1     : 2;
	unsigned int fmt      : 6;

	unsigned int syt      : 16;

	unsigned char data[0];
};

#elif __BYTE_ORDER == __LITTLE_ENDIAN

struct iec61883_packet {
	/* First quadlet */
	unsigned int sid      : 6;
	unsigned int eoh0     : 2;
	unsigned int dbs      : 8;

	unsigned int reserved : 2;
	unsigned int sph      : 1;
	unsigned int qpc      : 3;
	unsigned int fn       : 2;
	unsigned int dbc      : 8;

	/* Second quadlet */
	unsigned int fmt      : 6;
	unsigned int eoh1     : 2;
	unsigned int fdf      : 8;

	unsigned int syt      : 16;

	unsigned char data[0];
};

#else

#error Unknown bitfield type

#endif

/*
 * The TAG value is present in the isochronous header (first quadlet). It
 * provides a high level label for the format of data carried by the
 * isochronous packet.
 */

#define IEC61883_TAG_WITHOUT_CIP 0 /* CIP header NOT included */
#define IEC61883_TAG_WITH_CIP    1 /* CIP header included. */
#define IEC61883_TAG_RESERVED1   2 /* Reserved */
#define IEC61883_TAG_RESERVED2   3 /* Reserved */

#define IEC61883_FDF_NODATA   0xFF
		
/* AM824 format definitions. */
#define IEC61883_FDF_AM824 0x00
#define IEC61883_FDF_AM824_CONTROLLED 0x04
#define IEC61883_FDF_SFC_MASK 0x03

#define IEC61883_AM824_LABEL              0x40
#define IEC61883_AM824_LABEL_RAW_24BITS   0x40
#define IEC61883_AM824_LABEL_RAW_20BITS   0x41
#define IEC61883_AM824_LABEL_RAW_16BITS   0x42
#define IEC61883_AM824_LABEL_RAW_RESERVED 0x43

#define IEC61883_AM824_VBL_24BITS   0x0
#define IEC61883_AM824_VBL_20BITS   0x1
#define IEC61883_AM824_VBL_16BITS   0x2
#define IEC61883_AM824_VBL_RESERVED 0x3

/* IEC-60958 format definitions. */
#define IEC60958_LABEL   0x0
#define IEC60958_PAC_B   0x3 /* Preamble Code 'B': Start of channel 1, at
			      * the start of a data block. */
#define IEC60958_PAC_RSV 0x2 /* Preamble Code 'RESERVED' */
#define IEC60958_PAC_M   0x1 /* Preamble Code 'M': Start of channel 1 that
			      *	is not at the start of a data block. */
#define IEC60958_PAC_W   0x0 /* Preamble Code 'W': start of channel 2. */
#define IEC60958_DATA_VALID   0 /* When cleared means data is valid. */
#define IEC60958_DATA_INVALID 1 /* When set means data is not suitable for an ADC. */

struct iec61883_fraction {
	int integer;
	int numerator;
	int denominator;
};

struct iec61883_cip {
	struct iec61883_fraction cycle_offset;
	struct iec61883_fraction ticks_per_syt_offset;
	struct iec61883_fraction ready_samples;
	struct iec61883_fraction samples_per_cycle;
	int dbc, dbs;
	int cycle_count;
	int cycle_count2;
	int mode;
	int syt_interval;
	int dimension;
	int rate;
	int fdf;
	int format;
};

void
iec61883_cip_init(struct iec61883_cip *cip, int format, int fdf,
		int rate, int dbs, int syt_interval);
void 
iec61883_cip_set_transmission_mode(struct iec61883_cip *ptz, int mode);

int 
iec61883_cip_get_max_packet_size(struct iec61883_cip *ptz);

int
iec61883_cip_fill_header(raw1394handle_t handle, struct iec61883_cip *cip,
		struct iec61883_packet *packet);


#endif
