/* hsuart.c generated by valac 0.14.2, the Vala compiler
 * generated from hsuart.vala, do not modify */

/*
 * Copyright (C) 2010 Simon Busch <morphis@gravedo.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <hsuart.h>
#include <sys/ioctl.h>


#define FSO_FRAMEWORK_TYPE_TRANSPORT (fso_framework_transport_get_type ())
#define FSO_FRAMEWORK_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransport))
#define FSO_FRAMEWORK_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))
#define FSO_FRAMEWORK_IS_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_IS_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))

typedef struct _FsoFrameworkTransport FsoFrameworkTransport;
typedef struct _FsoFrameworkTransportClass FsoFrameworkTransportClass;
typedef struct _FsoFrameworkTransportPrivate FsoFrameworkTransportPrivate;

#define FSO_FRAMEWORK_TYPE_BASE_TRANSPORT (fso_framework_base_transport_get_type ())
#define FSO_FRAMEWORK_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransport))
#define FSO_FRAMEWORK_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))

typedef struct _FsoFrameworkBaseTransport FsoFrameworkBaseTransport;
typedef struct _FsoFrameworkBaseTransportClass FsoFrameworkBaseTransportClass;
typedef struct _FsoFrameworkBaseTransportPrivate FsoFrameworkBaseTransportPrivate;

#define FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT (fso_framework_hsuart_transport_get_type ())
#define FSO_FRAMEWORK_HSUART_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT, FsoFrameworkHsuartTransport))
#define FSO_FRAMEWORK_HSUART_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT, FsoFrameworkHsuartTransportClass))
#define FSO_FRAMEWORK_IS_HSUART_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT))
#define FSO_FRAMEWORK_IS_HSUART_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT))
#define FSO_FRAMEWORK_HSUART_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT, FsoFrameworkHsuartTransportClass))

typedef struct _FsoFrameworkHsuartTransport FsoFrameworkHsuartTransport;
typedef struct _FsoFrameworkHsuartTransportClass FsoFrameworkHsuartTransportClass;
typedef struct _FsoFrameworkHsuartTransportPrivate FsoFrameworkHsuartTransportPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef void (*FsoFrameworkTransportFunc) (FsoFrameworkTransport* transport, void* user_data);
struct _FsoFrameworkTransport {
	GObject parent_instance;
	FsoFrameworkTransportPrivate * priv;
	FsoFrameworkLogger* logger;
};

struct _FsoFrameworkTransportClass {
	GObjectClass parent_class;
	gboolean (*isOpen) (FsoFrameworkTransport* self);
	void (*openAsync) (FsoFrameworkTransport* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*openAsync_finish) (FsoFrameworkTransport* self, GAsyncResult* _res_);
	gboolean (*open) (FsoFrameworkTransport* self);
	void (*close) (FsoFrameworkTransport* self);
	gchar* (*getName) (FsoFrameworkTransport* self);
	void (*setDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
	void (*getDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify);
	void (*setPriorities) (FsoFrameworkTransport* self, gint rp, gint wp);
	void (*setBuffered) (FsoFrameworkTransport* self, gboolean on);
	gint (*writeAndRead) (FsoFrameworkTransport* self, void* wdata, gint wlength, void* rdata, gint rlength, gint maxWait);
	gint (*read) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*write) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*freeze) (FsoFrameworkTransport* self);
	void (*thaw) (FsoFrameworkTransport* self);
	void (*drain) (FsoFrameworkTransport* self);
	void (*flush) (FsoFrameworkTransport* self);
	gboolean (*suspend) (FsoFrameworkTransport* self);
	void (*resume) (FsoFrameworkTransport* self);
};

struct _FsoFrameworkBaseTransport {
	FsoFrameworkTransport parent_instance;
	FsoFrameworkBaseTransportPrivate * priv;
	gchar* name;
	guint speed;
	gboolean raw;
	gboolean hard;
	gint fd;
	FsoFrameworkTransportFunc hupfunc;
	gpointer hupfunc_target;
	GDestroyNotify hupfunc_target_destroy_notify;
	FsoFrameworkTransportFunc readfunc;
	gpointer readfunc_target;
	GDestroyNotify readfunc_target_destroy_notify;
	GByteArray* buffer;
};

struct _FsoFrameworkBaseTransportClass {
	FsoFrameworkTransportClass parent_class;
	gssize (*_real_write) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
	void (*configure) (FsoFrameworkBaseTransport* self);
	gchar* (*repr) (FsoFrameworkBaseTransport* self);
	gssize (*_real_read) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
};

struct _FsoFrameworkHsuartTransport {
	FsoFrameworkBaseTransport parent_instance;
	FsoFrameworkHsuartTransportPrivate * priv;
};

struct _FsoFrameworkHsuartTransportClass {
	FsoFrameworkBaseTransportClass parent_class;
};


static gpointer fso_framework_hsuart_transport_parent_class = NULL;

GType fso_framework_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_base_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_hsuart_transport_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_HSUART_TRANSPORT_DUMMY_PROPERTY
};
FsoFrameworkHsuartTransport* fso_framework_hsuart_transport_new (const gchar* portname);
FsoFrameworkHsuartTransport* fso_framework_hsuart_transport_construct (GType object_type, const gchar* portname);
FsoFrameworkBaseTransport* fso_framework_base_transport_new (const gchar* name, guint speed, gboolean raw, gboolean hard);
FsoFrameworkBaseTransport* fso_framework_base_transport_construct (GType object_type, const gchar* name, guint speed, gboolean raw, gboolean hard);
static gboolean fso_framework_hsuart_transport_real_open (FsoFrameworkTransport* base);
void fso_framework_base_transport_configure (FsoFrameworkBaseTransport* self);
gboolean fso_framework_transport_open (FsoFrameworkTransport* self);
static gchar* fso_framework_hsuart_transport_real_repr (FsoFrameworkBaseTransport* base);
static void fso_framework_hsuart_transport_real_configure (FsoFrameworkBaseTransport* base);
static gboolean fso_framework_hsuart_transport_real_suspend (FsoFrameworkTransport* base);
static void fso_framework_hsuart_transport_real_resume (FsoFrameworkTransport* base);


FsoFrameworkHsuartTransport* fso_framework_hsuart_transport_construct (GType object_type, const gchar* portname) {
	FsoFrameworkHsuartTransport * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (portname != NULL, NULL);
	_tmp0_ = portname;
	self = (FsoFrameworkHsuartTransport*) fso_framework_base_transport_construct (object_type, _tmp0_, (guint) 0, TRUE, TRUE);
	return self;
}


FsoFrameworkHsuartTransport* fso_framework_hsuart_transport_new (const gchar* portname) {
	return fso_framework_hsuart_transport_construct (FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT, portname);
}


static gboolean fso_framework_hsuart_transport_real_open (FsoFrameworkTransport* base) {
	FsoFrameworkHsuartTransport * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gboolean _tmp9_ = FALSE;
	self = (FsoFrameworkHsuartTransport*) base;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->name;
	_tmp1_ = open (_tmp0_, O_RDWR | O_NOCTTY, (mode_t) 0);
	((FsoFrameworkBaseTransport*) self)->fd = _tmp1_;
	_tmp2_ = ((FsoFrameworkBaseTransport*) self)->fd;
	if (_tmp2_ == (-1)) {
		FsoFrameworkLogger* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp3_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp4_ = ((FsoFrameworkBaseTransport*) self)->name;
		_tmp5_ = errno;
		_tmp6_ = strerror (_tmp5_);
		_tmp7_ = g_strdup_printf ("could not open %s: %s", _tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		fso_framework_logger_warning (_tmp3_, _tmp8_);
		_g_free0 (_tmp8_);
		result = FALSE;
		return result;
	}
	fso_framework_base_transport_configure ((FsoFrameworkBaseTransport*) self);
	_tmp9_ = FSO_FRAMEWORK_TRANSPORT_CLASS (fso_framework_hsuart_transport_parent_class)->open ((FsoFrameworkTransport*) FSO_FRAMEWORK_BASE_TRANSPORT (self));
	result = _tmp9_;
	return result;
}


static gchar* fso_framework_hsuart_transport_real_repr (FsoFrameworkBaseTransport* base) {
	FsoFrameworkHsuartTransport * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	guint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	self = (FsoFrameworkHsuartTransport*) base;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->name;
	_tmp1_ = ((FsoFrameworkBaseTransport*) self)->speed;
	_tmp2_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp3_ = g_strdup_printf ("<Hsuart %s@%u (fd %d)>", _tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * Configure the high speed to be ready for sending and receiving bytes.
     **/
static void fso_framework_hsuart_transport_real_configure (FsoFrameworkBaseTransport* base) {
	FsoFrameworkHsuartTransport * self;
	int flush;
	gint _tmp0_;
	struct hsuart_mode mode = {0};
	gint _tmp1_;
	struct hsuart_mode _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	struct hsuart_mode _tmp6_;
	gint _tmp7_;
	self = (FsoFrameworkHsuartTransport*) base;
	flush = ((HSUART_RX_QUEUE | HSUART_TX_QUEUE) | HSUART_RX_FIFO) | HSUART_TX_FIFO;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->fd;
	ioctl (_tmp0_, (gint) HSUART_IOCTL_FLUSH, flush);
	memset (&mode, 0, sizeof (struct hsuart_mode));
	_tmp1_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp2_ = mode;
	ioctl (_tmp1_, (gint) HSUART_IOCTL_GET_UARTMODE, &_tmp2_);
	mode.speed = (gint) HSUART_SPEED_115K;
	_tmp3_ = mode.flags;
	mode.flags = _tmp3_ | HSUART_MODE_PARITY_NONE;
	_tmp4_ = mode.flags;
	mode.flags = _tmp4_ | HSUART_MODE_FLOW_CTRL_HW;
	_tmp5_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp6_ = mode;
	ioctl (_tmp5_, (gint) HSUART_IOCTL_SET_UARTMODE, &_tmp6_);
	_tmp7_ = ((FsoFrameworkBaseTransport*) self)->fd;
	ioctl (_tmp7_, (gint) HSUART_IOCTL_RX_FLOW, HSUART_RX_FLOW_ON);
}


/**
     * This will suspend the transport. After it is suspend we can't send any more bytes
     * to the remote side.
     **/
static gboolean fso_framework_hsuart_transport_real_suspend (FsoFrameworkTransport* base) {
	FsoFrameworkHsuartTransport * self;
	gboolean result = FALSE;
	gint rc;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	FsoFrameworkLogger* _tmp20_;
	self = (FsoFrameworkHsuartTransport*) base;
	rc = 0;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp1_ = ioctl (_tmp0_, (gint) HSUART_IOCTL_RX_FLOW, HSUART_RX_FLOW_OFF);
	rc = _tmp1_;
	_tmp2_ = rc;
	if (_tmp2_ < 0) {
		FsoFrameworkLogger* _tmp3_;
		_tmp3_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp3_, "Could not deactivate flow control for the transport!");
		result = FALSE;
		return result;
	}
	_tmp4_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp5_ = ioctl (_tmp4_, (gint) HSUART_IOCTL_RX_BYTES, 0);
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ > 0) {
		FsoFrameworkLogger* _tmp7_;
		_tmp7_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp7_, "Could not suspend the transport as we have bytes left to send.");
		result = FALSE;
		return result;
	}
	_tmp8_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp9_ = ioctl (_tmp8_, (gint) HSUART_IOCTL_TX_DRAIN, 2000);
	rc = _tmp9_;
	_tmp10_ = rc;
	if (_tmp10_ < 0) {
		FsoFrameworkLogger* _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
		FsoFrameworkLogger* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp11_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp11_, "Could not drain the last bytes from hsuart buffer!");
		_tmp12_ = ((FsoFrameworkBaseTransport*) self)->fd;
		_tmp13_ = ioctl (_tmp12_, (gint) HSUART_IOCTL_TX_DRAIN, 0);
		rc = _tmp13_;
		_tmp14_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp15_ = rc;
		_tmp16_ = g_strdup_printf ("%i", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("Status of tx is ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		fso_framework_logger_error (_tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		result = FALSE;
		return result;
	}
	_tmp20_ = ((FsoFrameworkTransport*) self)->logger;
	fso_framework_logger_debug (_tmp20_, "Successfully suspended the transport!");
	result = TRUE;
	return result;
}


/**
     * Resume the transport so we can send and receive our bytes again.
     **/
static void fso_framework_hsuart_transport_real_resume (FsoFrameworkTransport* base) {
	FsoFrameworkHsuartTransport * self;
	gint rc;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	FsoFrameworkLogger* _tmp4_;
	self = (FsoFrameworkHsuartTransport*) base;
	rc = 0;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->fd;
	_tmp1_ = ioctl (_tmp0_, (gint) HSUART_IOCTL_RX_FLOW, HSUART_RX_FLOW_ON);
	rc = _tmp1_;
	_tmp2_ = rc;
	if (_tmp2_ < 0) {
		FsoFrameworkLogger* _tmp3_;
		_tmp3_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp3_, "Could not enable rx flow control!");
		return;
	}
	_tmp4_ = ((FsoFrameworkTransport*) self)->logger;
	fso_framework_logger_debug (_tmp4_, "Successfully enabled rx flow control!");
}


static void fso_framework_hsuart_transport_class_init (FsoFrameworkHsuartTransportClass * klass) {
	fso_framework_hsuart_transport_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->open = fso_framework_hsuart_transport_real_open;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->repr = fso_framework_hsuart_transport_real_repr;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->configure = fso_framework_hsuart_transport_real_configure;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->suspend = fso_framework_hsuart_transport_real_suspend;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->resume = fso_framework_hsuart_transport_real_resume;
}


static void fso_framework_hsuart_transport_instance_init (FsoFrameworkHsuartTransport * self) {
}


GType fso_framework_hsuart_transport_get_type (void) {
	static volatile gsize fso_framework_hsuart_transport_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_hsuart_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkHsuartTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_hsuart_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkHsuartTransport), 0, (GInstanceInitFunc) fso_framework_hsuart_transport_instance_init, NULL };
		GType fso_framework_hsuart_transport_type_id;
		fso_framework_hsuart_transport_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, "FsoFrameworkHsuartTransport", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_hsuart_transport_type_id__volatile, fso_framework_hsuart_transport_type_id);
	}
	return fso_framework_hsuart_transport_type_id__volatile;
}



