/**
 * @file internal.c Internal functions
 * 
 * $Id: internal.c,v 1.1 2001/07/06 00:53:48 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgnurdf/internal.h>
#include <parser.h>

static int gnurdf_initialized = 0;

#ifdef HAVE_ATEXIT
# define EXIT_FUNC(proc) void (proc)(void)
#elif HAVE_ON_EXIT
# define EXIT_FUNC(proc) void (proc)(int i, void *v)
#else
# define EXIT_FUNC(proc) void (proc)(void)
#endif

EXIT_FUNC(rdfUninitializeParser)
{
	if (gnurdf_initialized)
	{
		xmlCleanupParser();
		gnurdf_initialized = 0;
	}
}

void
rdfInitializeParser(void)
{
	if (gnurdf_initialized == 0)
	{
#ifdef LIBXML_TEST_VERSION
		LIBXML_TEST_VERSION;
#endif

#ifdef HAVE_ATEXIT
		atexit(rdfUninitializeParser);
#else
# ifdef HAVE_ON_EXIT
		on_exit(__uninitialize, NULL);
# endif /* HAVE_ON_EXIT */
#endif /* HAVE_ATEXIT */

		gnurdf_initialized = 1;
	}
}

