// piecePairRawEval.t.cc
#include "osl/eval/ppair/piecePairRawEval.h"
#include "osl/state/historyState.h"
#include "../consistencyTest.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;

class PiecePairRawEvalTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PiecePairRawEvalTest);
  CPPUNIT_TEST(testLoad);
  // testEval 以降は testLoad の後にテストすること
  CPPUNIT_TEST(testConsistentUpdate);
  CPPUNIT_TEST(testConsistentExpect);
  CPPUNIT_TEST(testEval);
  CPPUNIT_TEST_SUITE_END();
public:
  void testLoad();
  void testEval();
  void testConsistentUpdate();
  void testConsistentExpect();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PiecePairRawEvalTest);

using namespace osl;
using namespace osl::eval;
using namespace osl::eval::ppair;
extern bool isShortTest;

void PiecePairRawEvalTest::testLoad()
{
  CPPUNIT_ASSERT(PiecePairRawEval::setUp());
}

void PiecePairRawEvalTest::testEval()
{
  HistoryState state;
  const int start_value = PiecePairRawEval(state).value();
  int value1, value12, value2;
  const Move m1 = Move(Position(7,7),Position(7,6),PAWN,PTYPE_EMPTY,false,BLACK);
  {
    DoUndoMoveLock lock1(state, m1);
    CPPUNIT_ASSERT(state.isConsistent());

    value1 = PiecePairRawEval(state).value();
    const Move m12 = Move(Position(3,3),Position(3,4),PAWN,PTYPE_EMPTY,false,WHITE);
    {
      DoUndoMoveLock lock12(state, m12);
      CPPUNIT_ASSERT(state.isConsistent());
      value12 = PiecePairRawEval(state).value();
      if (! isShortTest)
	std::cerr << "76FU34FU " << start_value 
		  << " ==> " << value1 
		  << " ==> " << value12 
		  << "\n";
    } //   state.undoMove(m12);
    CPPUNIT_ASSERT(state.isConsistent());
  } // state.undoMove(m1);
  CPPUNIT_ASSERT(state.isConsistent());

  const Move m2 = Move(Position(2,7),Position(2,6),PAWN,PTYPE_EMPTY,false,BLACK);
  {
    DoUndoMoveLock lock2(state, m2);
    CPPUNIT_ASSERT(state.isConsistent());
    value2 = PiecePairRawEval(state).value();
    if (! isShortTest)
      std::cerr << "26FU " << start_value << " ==> " << value2 << "\n";
  } //  state.undoMove(m2);
  CPPUNIT_ASSERT(state.isConsistent());

  const Move m3 = Move(Position(8,7),Position(8,6),PAWN,PTYPE_EMPTY,false,BLACK);
  {
    DoUndoMoveLock lock2(state, m3);
    CPPUNIT_ASSERT(state.isConsistent());
    const int value3 = PiecePairRawEval(state).value();
    if (! isShortTest)
      std::cerr << "86FU " << start_value << " ==> " << value3 << "\n";

    CPPUNIT_ASSERT(start_value < value1);
    CPPUNIT_ASSERT(value1 > value12);
    CPPUNIT_ASSERT(start_value <= value2);
    CPPUNIT_ASSERT(value3 < value1);
    CPPUNIT_ASSERT(value3 < value2);
  }
#if 0
  NumEffectState state=CsaString(
    "P1+NY+TO *  *  *  * -OU-KE-KY\n"
    "P2 *  *  *  *  * -GI-KI *  *\n"
    "P3 * +RY *  * +UM * -KI-FU-FU\n"
    "P4 *  * +FU-FU *  *  *  *  *\n"
    "P5 *  * -KE * +FU *  * +FU *\n"
    "P6-KE *  * +FU+GI-FU *  * +FU\n"
    "P7 *  * -UM *  *  *  *  *  *\n"
    "P8 *  *  *  *  *  *  *  *  * \n"
    "P9 * +OU * -GI *  *  *  * -NG\n"
    "P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
    "P-00KI00KY00FU00FU\n"
    "P-00AL\n"
    "+\n").getInitialState();
  PiecePairEval eval(state);
  std::cerr << "value is " << eval.value() << "\n";

  state=CsaString(
    "P1-KY-KE-GI-KI *  * -HI-KE-KY\n"
    "P2 * -HI *  * -KA-OU *  *  * \n"
    "P3-FU * -FU-FU-FU * -GI-FU-FU\n"
    "P4 *  *  *  *  * -FU *  *  * \n"
    "P5 * -FU * +KA *  *  *  *  * \n"
    "P6 *  * +FU *  *  * +FU * +FU\n"
    "P7+FU+FU * +FU+FU+FU+KE *  * \n"
    "P8 * +GI+KI *  *  * +GI *  * \n"
    "P9+KY+KE *  * +OU+KI *  * +KY\n"
    "P+00FU\n"
    "P+00FU\n"
    "P+00KI\n"
    "+\n").getInitialState();
  PiecePairEval eval2(state);
  std::cerr << "value is " << eval2.value() << "\n";
#endif
}

void PiecePairRawEvalTest::testConsistentUpdate()
{
  consistencyTestUpdate<PiecePairRawEval>();
}

void PiecePairRawEvalTest::testConsistentExpect()
{
  consistencyTestExpect<PiecePairRawEval>();
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
