/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import java.util.ArrayList;
import javax.swing.Action;

/** This class describes a logical group of Dockables.
 *<p>
 * When a dockable is associated to a DockGroup (via its DockKey) drag and drop operations 
 * are limited to dockables of the same group (or new location) or compatible group (a group with 
 * a common ancestor see {@link #isCompatibleGroup(DockGroup)} ). 
 *<p>
 * It becomes easy to develop, for example, and MDI program : all documents are given the same
 * DockGroup, and other dockable are given another group so they don't mess with each other.
 *<p>
 * The DockGroups can be nested to allow some mixing (for example, an editor application can consist of 
 * 4 groups : "Formaters" and "Files" the parent of "TextFiles" and "HTMLfile". In that case, 
 * Textfiles and Htmlfiles can be part of tha same tabbed container whereas Formaters are kept outside.
 *
 *
 * @see DockKey#setDockGroup(DockGroup)
 * @author Lilian Chamontin, VLSolutions
 * @since 2.0
 */
public class DockGroup {
  
  /** The optional parent of this group */
  private DockGroup parent;
  
  /** internal name for comparisons */
  private String name;
  
    
  /** Constructs a new dockgroup with a given name.
   *<p> Note that names must be unique (this feature is not controlled by the framework)
   * through all DockGroups. 
   */
  public DockGroup(String name) {
    this.name = name;
  }

  /** Constructs a new dockgroup with a given name and a parent group.
   *<p> Note that names must be unique (this feature is not controlled by the framework)
   * through all DockGroups. 
   */
  public DockGroup(String name, DockGroup parent) {
    this.name = name;
    this.parent = parent;
  }
  
  /** returns the parent of this group (may be null) */
  public DockGroup getParent(){
    return parent;
  }
  
  /** Updates the parent of this group */
  public void setParent(DockGroup parent){
    this.parent = parent;
  }
  
  /** returns the name of this group (which is used as an internal key) */
  public String getName(){
    return name;
  }
  
  /** overriden for storage/comparisons with the "name" property */
  public boolean equals(Object o){
    return o != null && o instanceof DockGroup && ((DockGroup)o).name.equals(name);
  }
  
  /** overriden for storage/comparisons with the "name" property */
  public int hashCode(){
    return name.hashCode();
  }

  /** returns true if this group is the ancestor of group g.
   * To be an ancestor, this group must be either equel to g, or to one of g's parents chain.
   */
  public boolean isAncestorOf(DockGroup g){
    if (this.equals(g)){
      return true;
    } else {
      DockGroup parent = g.parent;
      while (parent != null){
        if (this.equals(parent)){
          return true;
        } else {
          parent = parent.parent;
        }
      }
    }
    return false;
  }
  
  /** returns true is this group is compatible with the given parameter.
   *<p> 
   * two groups are compatible if they share the same ancestor or if one is the 
   * ancestor of the other. 
   * <p>
   * When compatibility  is found, dockables of those groups can be docked in 
   * the same tab container.
   */
  public boolean isCompatibleGroup(DockGroup g){
    if (g == null) return false;
    if (this.equals(g)){
      return true;
    } else if (this.isAncestorOf(g)) {
      return true;
    } else if (g.isAncestorOf(this)){
      return true;
    } else if (parent != null){
      return parent.isCompatibleGroup(g.parent);
    } else {
      return false;
    }
  }
  
  /** convenience method to check compatibility between groups */
  public static boolean areGroupsCompatible(DockGroup g1, DockGroup g2){
    if (g1 == null){
      return g2 == null;
    } else if (g2 == null){
      return g1 == null;
    } else {
      return g1.isCompatibleGroup(g2);
    }
  }
  
  
}
