#!/usr/bin/perl

### libwhisker make file to build library from development subpackages

eval "use Config;";
if(!$@){ $HAVE_CONFIG=1; }
eval "use Cwd;";
if(!$@){ $HAVE_CWD=1; }

$|++;

$VERSION	=	'1.7';
$LIB		=	'LW.pm';
$COMPONENTS	= 	'libs';
$PRELIB		=	'prelib.wpl';
$GLOBALS	=	'globals.wpl';

#### end config ######################################################

%build=();
$CWD='';

if($ARGV[0] eq ''){
	print <<EOT
libwhisker build options:
- Makefile.pl lib	# make libwhisker

- Makefile.pl nopod	# strip pod out of libwhisker (and build it if 
			# it's not already built)

- Makefile.pl clean	# clean up the build tree

- Makefile.pl selfload	# add SelfLoader code to libwhisker (potentially
			# making it load faster in your programs

- Makefile.pl install	# install libwhisker into your local perl site 
			# module directory

- Makefile.pl uninstall	# remove libwhisker from the perl module directory

- Makefile.pl support	# check to see what supporting modules are 
			# available (i.e. installed on this machine)

- Makefile.pl diag	# print out diagnostic info for submitting with
			# bug report

- Makefile.pl liblite	# make libwhisker-lite (only HTTP functions)

EOT
;
exit;}

$HAVE_SOCKET=1;
eval "use Socket";
if($@){
$HAVE_SOCKET=0;
print STDOUT <<EOT
!! Warning !! 
   Your perl version doesn't have Socket (e.g. network) support;
   while you can still use libwhisker on this machine, all the network 
   functionality (which is the core purpose of libwhisker) will not be 
   available.  Of course, this doesn't apply if you're building
   libwhisker for use on another machine (which *does* have Socket 
   support).

EOT
;}

while($COMM = shift @ARGV){

$NOPOD=$INSTALL=0; $BUILDEXIT=1;


sub verify {
        my $temp=-1;
        my $name=shift;
        eval { $temp=sprintf("%lu",&$name) };
        $temp="\t$temp" if(length($name)<7);
        print "$name:\t$temp\n";
}

if($COMM eq 'diag'){
	use Socket;
	use POSIX;
	@what=qw(
        	INADDR_ANY INADDR_BROADCAST INADDR_LOOPBACK INADDR_NONE
        	AF_INET PF_INET MSG_OOB
        	SOCK_DGRAM SOCK_RAW SOCK_SEQPACKET SOCK_STREAM
        	SOL_SOCKET SOMAXCONN F_GETFL F_SETFL O_NONBLOCK
        	EINPROGRESS EWOULDBLOCK
        	SO_BROADCAST SO_KEEPALIVE SO_LINGER SO_OOBINLINE
        	SO_RCVBUF SO_RCVLOWAT SO_RCVTIMEO SO_REUSEADDR SO_SNDBUF
	        SO_SNDLOWAT SO_SNDTIMEO SO_TYPE SO_USELOOPBACK
	);
	map { verify($_) } @what;
	print "\nPerl: $^O\n";
	print "Perl version: $]\n";
	print "Uname processor: ",`uname -m`;
	print "Uname kernel: ",`uname -r`;
	$ARGV[0] = 'support';
}


if($COMM eq 'support'){
	print "Perl $] on '$^O'\n";
	print "Achitecture: '$Config{archname}'\n" if($HAVE_CONFIG);
	print "\n";

	my @libs=qw(Socket LW LW:bin Net::SSLeay Net::SSL Fcntl Errno);
	foreach $lib (@libs){
		print $lib, ' ->', ' 'x(20-length($lib));
		eval "use $lib";
		if(!$@){
			print "yes (version ";
			print eval '$'.$lib.'::VERSION', ")\n";
		} else {
			print "no\n";
		}
	}
	print "\n";
	next;
}


if($COMM eq 'clean'){
	unlink $LIB;
	print "Clean.\n";
	next;
}

if($COMM eq 'uninstall'){
	die("Can not uninstall without Config.pm") if(!$HAVE_CONFIG);
	$CWD=&cwd if($HAVE_CWD);
	my $where=$Config{'installsitelib'};
	chdir($where);
	if(-e $LIB){
		unlink $LIB;
		print STDOUT "libwhisker uninstalled.\n";
	} else {
		print STDOUT "libwhisker not installed.\n";
	}
	exit if(!$HAVE_CWD);
	chdir($CWD);
	next;
}

if($COMM eq 'nopod'){
	$NOPOD=1;
	if(!(-e $LIB)){
		$ARGV[0]='lib';
		$BUILDEXIT=0; }
}

if($COMM eq 'install'){
	$INSTALL=1;
	if(!(-e $LIB)){
		$ARGV[0]='lib'; 
		$BUILDEXIT=0; }
}

if($COMM eq 'liblite'){
	$CWD=&cwd if($HAVE_CWD);
	open(OUT,">$LIB");
	print OUT "# libwhisker v$VERSION-lite\n";
	chdir($COMPONENTS);
	open(IN,"<$PRELIB") || puke($PRELIB);
	while(<IN>){ print OUT; } close(IN);
	print OUT "\$LW::VERSION=\"$VERSION-lite\";\n";
	open(IN,"<$GLOBALS") || puke($GLOBALS);
	while(<IN>){ print OUT; } close(IN);
	open(IN,'<http.pl');
	while(<IN>){
		print OUT if(!m/^#GPL/);
	} close(IN);
	print OUT "1;\n";
	print STDOUT "libwhisker-lite built.\n";
	close(OUT);
	exit if(!$HAVE_CWD);
	chdir($CWD);
	next;
}

if($COMM eq 'lib' || $COMM eq 'selfload'){
	$CWD=&cwd if($HAVE_CWD);
	open(OUT,">$LIB");
	print OUT "# libwhisker v$VERSION\n";
	opendir(DIR,$COMPONENTS);
	chdir($COMPONENTS);
	open(IN,"<$PRELIB") || puke($PRELIB);
	while(<IN>){ print OUT; } close(IN);
	print OUT "\$LW::VERSION=\"$VERSION\";\n";
	if($COMM eq 'selfload'){
		print OUT "use SelfLoader;\n";}
	open(IN,"<$GLOBALS") || puke($GLOBALS);
	while(<IN>){ print OUT; } close(IN);
	if($COMM eq 'selfload'){
		print OUT "1;\n__DATA__\n";}
	&readlibs;	
	print OUT "1;\n";
	print STDOUT "libwhisker built.\n";
	close(OUT);
	closedir(DIR);
	exit if(!$HAVE_CWD);
	chdir($CWD);
	next if $BUILDEXIT;
}

if($NOPOD){
	open(OUT,">$LIB.nopod");
	open(IN,"<$LIB");
	&strip_pod;
	close(OUT); close(IN);
	unlink $LIB;
	rename "$LIB.nopod",$LIB;
	print STDOUT "POD removed.\n";
	next;
}

if($INSTALL){
	die("Can not install without Config.pm") if(!$HAVE_CONFIG);
	$CWD=&cwd if($HAVE_CWD);
	my $where=$Config{'installsitelib'};
	open(IN,"<$LIB");
	chdir($where);
	open(OUT,">$LIB");
	while(<IN>){ print OUT; }
	close(IN); close(OUT);
	if(-s "$LIB"){
		 print STDOUT "libwhisker installed to $where\n";
	} else { print STDOUT "Error installing libwhisker\n"; }
	exit if(!$HAVE_CWD);
	chdir($CWD);
}


} # while($COMM)


sub puke {
	my $file = shift;
	print STDOUT "Build error: missing $file\n";
	eval "close(OUT)";
	exit;
}

sub readlibs {
	my $file;
	my @FF=();
	while($file=readdir(DIR)){
		push(@FF,$file);
	}
	my @FE = sort @FF;
	foreach $file (@FE){
		next if(defined $build{$file});
		if($file=~/(.+)\.dpl$/){
			if(!-e "$1.pl"){
				$build{$file}++;
				open(IN,"<$file");
				while(<IN>){ 
					print OUT if(!m/^#GPL/); 
				} close(IN);
			} else {
				$file = $1.pl; }
		}

		if($file=~/(.+)\.pl$/){
			$build{$file}++;
			open(IN,"<$file");
			while(<IN>){ 
				print OUT if(!m/^#GPL/); 
			} close(IN);
			if(-e "$1.dpl"){
				$build{"$1.dpl"}++;
				open(IN,"<$1.dpl");
				while(<IN>){ 
					print OUT if(!m/^#GPL/); 
				} close(IN);
			}
		}
	}
}

	
sub strip_pod {
	$inpod=0;
	$last='';

	while(<IN>){
		$line=$_;
		next if($line=~/^##############################/);
		$inpod=1 if($line=~/^=pod/);
		if(!$inpod){
			print OUT $line if(!($line eq "\n" && $last eq "\n"));
		}
		$inpod=0 if($line=~/^=cut/);
		$last = $line;
	}
}
