# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1Volume(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'host_path': 'V1HostPathVolumeSource',
            'empty_dir': 'V1EmptyDirVolumeSource',
            'gce_persistent_disk': 'V1GCEPersistentDiskVolumeSource',
            'aws_elastic_block_store': 'V1AWSElasticBlockStoreVolumeSource',
            'git_repo': 'V1GitRepoVolumeSource',
            'secret': 'V1SecretVolumeSource',
            'nfs': 'V1NFSVolumeSource',
            'iscsi': 'V1ISCSIVolumeSource',
            'glusterfs': 'V1GlusterfsVolumeSource',
            'persistent_volume_claim': 'V1PersistentVolumeClaimVolumeSource',
            'rbd': 'V1RBDVolumeSource'
        }

        self.attribute_map = {
            'name': 'name',
            'host_path': 'hostPath',
            'empty_dir': 'emptyDir',
            'gce_persistent_disk': 'gcePersistentDisk',
            'aws_elastic_block_store': 'awsElasticBlockStore',
            'git_repo': 'gitRepo',
            'secret': 'secret',
            'nfs': 'nfs',
            'iscsi': 'iscsi',
            'glusterfs': 'glusterfs',
            'persistent_volume_claim': 'persistentVolumeClaim',
            'rbd': 'rbd'
        }

        self._name = None
        self._host_path = None
        self._empty_dir = None
        self._gce_persistent_disk = None
        self._aws_elastic_block_store = None
        self._git_repo = None
        self._secret = None
        self._nfs = None
        self._iscsi = None
        self._glusterfs = None
        self._persistent_volume_claim = None
        self._rbd = None

    @property
    def name(self):
        """
        Gets the name of this V1Volume.
        volume name; must be a DNS_LABEL and unique within the pod; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :return: The name of this V1Volume.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1Volume.
        volume name; must be a DNS_LABEL and unique within the pod; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :param name: The name of this V1Volume.
        :type: str
        """
        self._name = name

    @property
    def host_path(self):
        """
        Gets the host_path of this V1Volume.
        pre-existing host file or directory; generally for privileged system daemons or other agents tied to the host; see http://releases.k8s.io/v1.0.4/docs/volumes.md#hostpath

        :return: The host_path of this V1Volume.
        :rtype: V1HostPathVolumeSource
        """
        return self._host_path

    @host_path.setter
    def host_path(self, host_path):
        """
        Sets the host_path of this V1Volume.
        pre-existing host file or directory; generally for privileged system daemons or other agents tied to the host; see http://releases.k8s.io/v1.0.4/docs/volumes.md#hostpath

        :param host_path: The host_path of this V1Volume.
        :type: V1HostPathVolumeSource
        """
        self._host_path = host_path

    @property
    def empty_dir(self):
        """
        Gets the empty_dir of this V1Volume.
        temporary directory that shares a pod's lifetime; see http://releases.k8s.io/v1.0.4/docs/volumes.md#emptydir

        :return: The empty_dir of this V1Volume.
        :rtype: V1EmptyDirVolumeSource
        """
        return self._empty_dir

    @empty_dir.setter
    def empty_dir(self, empty_dir):
        """
        Sets the empty_dir of this V1Volume.
        temporary directory that shares a pod's lifetime; see http://releases.k8s.io/v1.0.4/docs/volumes.md#emptydir

        :param empty_dir: The empty_dir of this V1Volume.
        :type: V1EmptyDirVolumeSource
        """
        self._empty_dir = empty_dir

    @property
    def gce_persistent_disk(self):
        """
        Gets the gce_persistent_disk of this V1Volume.
        GCE disk resource attached to the host machine on demand; see http://releases.k8s.io/v1.0.4/docs/volumes.md#gcepersistentdisk

        :return: The gce_persistent_disk of this V1Volume.
        :rtype: V1GCEPersistentDiskVolumeSource
        """
        return self._gce_persistent_disk

    @gce_persistent_disk.setter
    def gce_persistent_disk(self, gce_persistent_disk):
        """
        Sets the gce_persistent_disk of this V1Volume.
        GCE disk resource attached to the host machine on demand; see http://releases.k8s.io/v1.0.4/docs/volumes.md#gcepersistentdisk

        :param gce_persistent_disk: The gce_persistent_disk of this V1Volume.
        :type: V1GCEPersistentDiskVolumeSource
        """
        self._gce_persistent_disk = gce_persistent_disk

    @property
    def aws_elastic_block_store(self):
        """
        Gets the aws_elastic_block_store of this V1Volume.
        AWS disk resource attached to the host machine on demand; see http://releases.k8s.io/v1.0.4/docs/volumes.md#awselasticblockstore

        :return: The aws_elastic_block_store of this V1Volume.
        :rtype: V1AWSElasticBlockStoreVolumeSource
        """
        return self._aws_elastic_block_store

    @aws_elastic_block_store.setter
    def aws_elastic_block_store(self, aws_elastic_block_store):
        """
        Sets the aws_elastic_block_store of this V1Volume.
        AWS disk resource attached to the host machine on demand; see http://releases.k8s.io/v1.0.4/docs/volumes.md#awselasticblockstore

        :param aws_elastic_block_store: The aws_elastic_block_store of this V1Volume.
        :type: V1AWSElasticBlockStoreVolumeSource
        """
        self._aws_elastic_block_store = aws_elastic_block_store

    @property
    def git_repo(self):
        """
        Gets the git_repo of this V1Volume.
        git repository at a particular revision

        :return: The git_repo of this V1Volume.
        :rtype: V1GitRepoVolumeSource
        """
        return self._git_repo

    @git_repo.setter
    def git_repo(self, git_repo):
        """
        Sets the git_repo of this V1Volume.
        git repository at a particular revision

        :param git_repo: The git_repo of this V1Volume.
        :type: V1GitRepoVolumeSource
        """
        self._git_repo = git_repo

    @property
    def secret(self):
        """
        Gets the secret of this V1Volume.
        secret to populate volume; see http://releases.k8s.io/v1.0.4/docs/volumes.md#secrets

        :return: The secret of this V1Volume.
        :rtype: V1SecretVolumeSource
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """
        Sets the secret of this V1Volume.
        secret to populate volume; see http://releases.k8s.io/v1.0.4/docs/volumes.md#secrets

        :param secret: The secret of this V1Volume.
        :type: V1SecretVolumeSource
        """
        self._secret = secret

    @property
    def nfs(self):
        """
        Gets the nfs of this V1Volume.
        NFS volume that will be mounted in the host machine; see http://releases.k8s.io/v1.0.4/docs/volumes.md#nfs

        :return: The nfs of this V1Volume.
        :rtype: V1NFSVolumeSource
        """
        return self._nfs

    @nfs.setter
    def nfs(self, nfs):
        """
        Sets the nfs of this V1Volume.
        NFS volume that will be mounted in the host machine; see http://releases.k8s.io/v1.0.4/docs/volumes.md#nfs

        :param nfs: The nfs of this V1Volume.
        :type: V1NFSVolumeSource
        """
        self._nfs = nfs

    @property
    def iscsi(self):
        """
        Gets the iscsi of this V1Volume.
        iSCSI disk attached to host machine on demand; see http://releases.k8s.io/v1.0.4/examples/iscsi/README.md

        :return: The iscsi of this V1Volume.
        :rtype: V1ISCSIVolumeSource
        """
        return self._iscsi

    @iscsi.setter
    def iscsi(self, iscsi):
        """
        Sets the iscsi of this V1Volume.
        iSCSI disk attached to host machine on demand; see http://releases.k8s.io/v1.0.4/examples/iscsi/README.md

        :param iscsi: The iscsi of this V1Volume.
        :type: V1ISCSIVolumeSource
        """
        self._iscsi = iscsi

    @property
    def glusterfs(self):
        """
        Gets the glusterfs of this V1Volume.
        Glusterfs volume that will be mounted on the host machine; see http://releases.k8s.io/v1.0.4/examples/glusterfs/README.md

        :return: The glusterfs of this V1Volume.
        :rtype: V1GlusterfsVolumeSource
        """
        return self._glusterfs

    @glusterfs.setter
    def glusterfs(self, glusterfs):
        """
        Sets the glusterfs of this V1Volume.
        Glusterfs volume that will be mounted on the host machine; see http://releases.k8s.io/v1.0.4/examples/glusterfs/README.md

        :param glusterfs: The glusterfs of this V1Volume.
        :type: V1GlusterfsVolumeSource
        """
        self._glusterfs = glusterfs

    @property
    def persistent_volume_claim(self):
        """
        Gets the persistent_volume_claim of this V1Volume.
        a reference to a PersistentVolumeClaim in the same namespace; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#persistentvolumeclaims

        :return: The persistent_volume_claim of this V1Volume.
        :rtype: V1PersistentVolumeClaimVolumeSource
        """
        return self._persistent_volume_claim

    @persistent_volume_claim.setter
    def persistent_volume_claim(self, persistent_volume_claim):
        """
        Sets the persistent_volume_claim of this V1Volume.
        a reference to a PersistentVolumeClaim in the same namespace; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#persistentvolumeclaims

        :param persistent_volume_claim: The persistent_volume_claim of this V1Volume.
        :type: V1PersistentVolumeClaimVolumeSource
        """
        self._persistent_volume_claim = persistent_volume_claim

    @property
    def rbd(self):
        """
        Gets the rbd of this V1Volume.
        rados block volume that will be mounted on the host machine; see http://releases.k8s.io/v1.0.4/examples/rbd/README.md

        :return: The rbd of this V1Volume.
        :rtype: V1RBDVolumeSource
        """
        return self._rbd

    @rbd.setter
    def rbd(self, rbd):
        """
        Sets the rbd of this V1Volume.
        rados block volume that will be mounted on the host machine; see http://releases.k8s.io/v1.0.4/examples/rbd/README.md

        :param rbd: The rbd of this V1Volume.
        :type: V1RBDVolumeSource
        """
        self._rbd = rbd

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
