/*
 *   $Id: Rewrites.C,v 1.7 2001/11/28 18:50:32 alex Exp $
 */

// Copyright (C) 2000 The New York Group Theory Cooperative
// See magnus/doc/COPYRIGHT for the full notice.

// Contents: Declaration of the RewritesARCe, CommutatorRewriteProblem, 
//           SquareRewriteProblem classes.
//
// Principal Authors: Denis Serbin
//
// Status: In progress
//
// Revision History:
//
// Special Notes:
//
//

#include "Rewrites.h"
#include "SMWord.h"
#include "SMFPGroup.h"
#include "OutMessages.h"


// ------------------------ RewritesARCer ------------------------- //


void RewritesARCer::setArguments( const FPGroup& gr,const Word& w, int ord )
{
  G = gr;
  theWord = w.freelyReduce();
  order = ord;
}

void RewritesARCer::runComputation( ) 
{
  if( order == 1 )
    retValue = G.productOfCommutators(theWord,file);
  
  if( order == 2 )
    retValue = G.productOfSquares(theWord,file);
}

void RewritesARCer::writeResults( ostream& out )
{
  out < retValue;
}


void RewritesARCer::readResults( istream& in )
{
  in > retValue;
}

// ------------------------ CommutatorRewriteProblem ----------------------- //


CommutatorRewriteProblem::CommutatorRewriteProblem( SMWord& word )
  : theWord( word ),
    ComputationManager( true),
    arcer( *this )
{
  if( !theWord.getWord().freelyReduce().length() || 
      theWord.getWord().allExponentSumsZero() )
    resultIsFast();
  else
    arcer.setArguments(theWord.getParent().getFPGroup(),theWord.getWord(),1);
}

void CommutatorRewriteProblem::takeControl( )
{
  if( !theWord.getWord().freelyReduce().length() )
    {
      LogMessage msg2( *this,theWord );
      msg2 << Name( theWord ) << " is trivial.";
      msg2.send();
      adminTerminate();
      return;
    }
  
  if( theWord.getWord().allExponentSumsZero() )
    {
      LogMessage msg1( *this,theWord );
      VectorOf<Chars> v = theWord.getParent().getFPGroup().namesOfGenerators();
      FreeGroup F(v);
      File f;
      
      msg1 << Name( theWord ) << " can be rewritten as: " << F.productOfCommutators(theWord.getWord(),f);
      msg1.send();
      
      LogMessage msg4( *this,theWord );
      msg4 << Link("Click here to see the steps of the rewriting process" , "Commutators" , f.getFileName() );
      msg4.send();      
      
      f << end;

      adminTerminate();
      return;
    }
  
  if ( freeARCs() > 0 ) 
    if( arcer.takeControl() ) 
      {
	Chars result = arcer.getRetValue();
	LogMessage msg( *this,theWord );
	
	if ( result == Chars("not in derived") )
	  msg << Name( theWord )  << " isn't in derived subgroup.";
	else
	  if ( result == Chars("trivial") )
	    msg << Name( theWord ) << " is trivial.";
	  else
	    {
	      msg << Name( theWord ) << " can be rewritten as:  " << result << " . ";
	      LogMessage msg3( *this,theWord );
	      msg3 << Link("Click here to see the steps of the rewriting process" , "Commutators" , arcer.getFileName() );
	      msg3.send();
	    }
	
	msg.send();
	
	adminTerminate();
	return;
      }
    else
      usedOneARC();
}

void CommutatorRewriteProblem::viewStructure(ostream& ostr) const
{
  ProblemView pv( ostr, oid(), Text("Rewriting of a word as a product of commutators"),
		  Text("Rewrite")+Name(theWord)+Text(" as a product of commutators"),
		  helpID("CommutatorRewriteProblem",theWord.getParent()),
		  Text("rewrite") + Name(theWord)
		  );
  pv.startItemGroup();
  
  pv.add(Text("Rewrite ")+Name( theWord )+Text(" as a product of commutators"),
  	 ThisARCSlotID(),
  	 50);
  
  pv.done();
}


// ------------------------ SquareRewriteProblem ----------------------- //


SquareRewriteProblem::SquareRewriteProblem( SMWord& word )
  : theWord( word ),
    ComputationManager( true),
    arcer( *this )
{
  if( !theWord.getWord().freelyReduce().length() )
    resultIsFast();
  else
    arcer.setArguments(theWord.getParent().getFPGroup(),theWord.getWord(),2);
}

void SquareRewriteProblem::takeControl( )
{
  if( !theWord.getWord().freelyReduce().length() )
    {
      LogMessage msg2( *this,theWord );
      msg2 << Name( theWord ) << " is trivial.";
      msg2.send();
      adminTerminate();
      return;
    }
  
  if( freeARCs() > 0 ) 
    if( arcer.takeControl() ) 
      {
	Chars result = arcer.getRetValue();
	LogMessage msg( *this,theWord );
	
	if ( result == Chars("not in square") )
	  msg << Name( theWord )  << " isn't in subgroup generated by squares.";
	else
	  if ( result == Chars("trivial") )
	    msg << Name( theWord ) << " is trivial.";
	  else
	   { 
	     msg << Name( theWord ) << " can be rewritten as:  " << result << " . ";
	     LogMessage msg3( *this,theWord );
	     msg3 << Link("Click here to see the steps of the rewriting process" , "Squares" , arcer.getFileName() );
	     msg3.send();
	   }
	
	msg.send();
	
	adminTerminate();
	return;
      }
    else
      usedOneARC();
}

void SquareRewriteProblem::viewStructure(ostream& ostr) const
{
  ProblemView pv( ostr, oid(), Text("Rewriting of a word as a product of squares"),
		  Text("Rewrite")+Name(theWord)+Text(" as a product of squares"),
		  helpID("SquareRewriteProblem",theWord.getParent()),
		  Text("rewrite") + Name(theWord)
		  );
  pv.startItemGroup();
  
  pv.add(Text("Rewrite ")+Name( theWord )+Text(" as a product of squares"),
  	 ThisARCSlotID(),
  	 50);
  
  pv.done();
}
