dnl  This file is part of MED.
dnl
dnl  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
dnl  MED is free software: you can redistribute it and/or modify
dnl  it under the terms of the GNU Lesser General Public License as published by
dnl  the Free Software Foundation, either version 3 of the License, or
dnl  (at your option) any later version.
dnl
dnl  MED is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl  GNU Lesser General Public License for more details.
dnl
dnl  You should have received a copy of the GNU Lesser General Public License
dnl  along with MED.  If not, see <http://www.gnu.org/licenses/>.
dnl

AC_DEFUN([MED_CHECK_F90],dnl
[
AC_REQUIRE([AC_PROG_FC])

## Guess where as f90prog is defined by the F90 environement varaible
## or by the --with-f90 option

AC_ARG_WITH([f90],
            AC_HELP_STRING([--with-f90=<compiler>],
	                   [Use <compiler> for F90 compiler]),
	    [],
	    [withval=no])

if test ! "x$withval" = "xno"
then
 
    test "x$withval" = "xyes" && f90prog=${F90} || f90prog=$withval

    ## Looking for "$f90prog" presence 
    AC_PROG_FC([$f90prog],[Fortran 90])
    AC_FC_LIBRARY_LDFLAGS
    ##AC_FC_WRAPPERS Inutile car pas d'interface spcifique f90 

    if test -z "$FC" ; then
	AC_MSG_ERROR([Can't find $f90prog command, please verify your env. var. PATH])
    fi 

   BUILD_F90TESTS_CONDITIONAL_TRUE=
   BUILD_F90TESTS_CONDITIONAL_FALSE='#'
else
   FC="" 
   BUILD_F90TESTS_CONDITIONAL_TRUE='#'
   BUILD_F90TESTS_CONDITIONAL_FALSE=
fi

AC_SUBST([BUILD_F90TESTS_CONDITIONAL_TRUE])
AC_SUBST([BUILD_F90TESTS_CONDITIONAL_FALSE])

])

