/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQRequestPanelHelp_H
#define MvQRequestPanelHelp_H

#include "RequestPanelItem.h"

#include <QIcon>
#include <QObject>

class  QWidget;

class  Parameter;
class  RequestPanel;

class MvQRequestPanelHelp : public QObject
{  
Q_OBJECT

public:
	MvQRequestPanelHelp(RequestPanel&,const Parameter&);
	virtual ~MvQRequestPanelHelp() {}; 
	
	virtual void start() = 0;
	virtual bool dialog() = 0;
	virtual QIcon dialogIcon() {return QIcon();}
	virtual bool useLargeDialogIcon() {return false;}
	virtual QWidget* widget() = 0;	
	virtual void refresh(const vector<string>&)=0;
	
	static MvQRequestPanelHelp* build(RequestPanel&,const Parameter&);
	
signals:
        void edited(const vector<string>&);
	void edited(const vector<string>&,const vector<string>&);

protected:
    	RequestPanel& owner_;
	const Parameter& param_;
	QWidget *parentWidget_;	
};

#endif
