/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQWmsClientEditor_H
#define MvQWmsClientEditor_H

#include <QGridLayout>
#include <QLineEdit>
#include <QComboBox>
#include <QMainWindow>
#include <QStringList>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"
#include "MvQWmsClient.h"

class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QListWidgetItem;
class QListWidget;
class QProgressBar;
class QPushButton;
class QScrollArea;
class QSplitter;
class QTabWidget;
class QTextBrowser;
class QTextEdit;
class QToolButton;
class QTreeView;
class QVBoxLayout;

class MvQHighlighter;
class MvQLogPanel;
class MvQOgcTreeModel;
class MvQTextEditSearchLine;
class MvQWmsUiClient;
class MvQWmsGetCapHighlighter;
class PlainTextWidget;

class MvQWmsDimensionGuiItem : public QObject
{
    Q_OBJECT
public:
    MvQWmsDimensionGuiItem(MvQOgcDimension*, QString, QGridLayout*, int);
    ~MvQWmsDimensionGuiItem();
    QString currentValue();
    void addValue(QString);

public slots:
    void slotClearText(bool);
    void slotSetVisibleList(bool);
    void slotListItemChanged(QListWidgetItem*);
    void slotLineEditChanged(QString);
    void slotAddItem(QListWidgetItem*);

signals:
    void textChanged(MvQOgcDimension*, QString);

private:
    MvQOgcDimension* dim_;
    QLabel* label_;
    QLineEdit* lineEdit_;
    QStringList values_;
    QToolButton* expandTb_;
    QToolButton* clearTb_;
    //QString default_;
    QListWidget* list_;
    int row_;
};


class MvQWmsClientEditor : public MvQMainWindow
{
    Q_OBJECT

public:
    MvQWmsClientEditor(MvQWmsUiClient*, QWidget* w = 0);
    ~MvQWmsClientEditor();

public slots:
    void slotClientModeChanged(QString);
    void slotSaveInfo();
    void slotSelectUrl(const QString&);
    void slotSelectVersion(const QString&);
    void slotRunGetCapabilities();
    void slotGetCapabilityLoaded();
    void slotSelectLayer(const QModelIndex&);
    void slotSelectStyle(int);
    void slotSelectCrs(QString);
    void slotDimensionChanged(MvQOgcDimension*, QString);
    void slotExtraGetCapChanged(QString);
    void slotExtraGetMapChanged(QString);
    void slotUpdateLayerInfo();
    void slotPreview();
    void slotPreviewLoaded(QString);
    void slotLegendLoaded(QString);
    void slotLogoLoaded(QString);
    void slotSetGetMapInfo(QString, QStringList);
    void slotReqEdited(const QString&);
    void slotImportRequest();
    void slotClientReset();
    void slotUpdateServiceInfo();

signals:
    void clientModeChanged();
    void clientModeIsAboutToChange();

protected:
    void setupFileActions();
    void setupSettingsActions();
    void setupViewActions();
    void setupLayerPanel(QVBoxLayout*);
    void setupLayerInfoTab();
    void setupLayerCombo();
    void setupLayerList();
    void setupDimension();
    void setupReqEditPanel();

    void initClientMode();
    void initVersionCombo();
    void initExtraParEdit();
    void initFormatCombo();
    void initStyleCombo();
    void initCrsCombo();

    void clearServerDependentData();
    void clearLayerDependentData();
    void clearDimension();

    void checkUrlComboItems();

    void loadStarted();
    void loadFinished();
    void writeSettings();
    void readSettings();

    MvQWmsUiClient* client_;

    QVBoxLayout* mainLayout_;
    QSplitter* mainSplitter_;
    QSplitter* requestSplitter_;

    QCheckBox* openCb_;

    QLabel* loadLabel_;
    QLabel* statusMessageLabel_;
    QList<QWidget*> advancedModeOnlyWidgets_;

    MvQMainWindow::MenuItemMap menuItems_;
    QAction* actionCapability_;
    QAction* actionStopLoad_;
    QAction* actionLog_;
    QComboBox* urlCombo_;
    QComboBox* versionCombo_;
    QComboBox* clientModeCombo_;
    QMap<QString, MvQWmsUiClient::ClientMode> clientModeMap_;

    QComboBox* formatCombo_;
    QLineEdit* extraGetCapEdit_;
    QLineEdit* extraGetMapEdit_;

    QTabWidget* layerTab_;
    QWidget* layerPanel_;
    QGridLayout* layerGrid_;
    QHBoxLayout* layerLayout_;
    QTreeView* layerTree_;
    MvQOgcTreeModel* layerModel_;
    QComboBox* crsCombo_;
    QComboBox* styleCombo_;
    QPushButton* previewPb_;
    int dimensionNum_;
    int layerParamRowNum_;
    QMap<QString, MvQWmsDimensionGuiItem*> dim_;
    QLabel* crsLabel_;

    QTabWidget* layerInfoTab_;
    PlainTextWidget* getCapInfo_;
    QTextBrowser* serviceInfo_;
    QTextBrowser* layerPreview_;
    QTextBrowser* getMapInfoSplit_;
    MvQHighlighter* highlighterSplit_;
    QPushButton* plainPreviewPb_;
    QLabel* plainPreviewLabel_;
    QWidget* plainPreviewPanel_;

    MvQLogPanel* logPanel_;

#ifdef UI_TODO
    MvQTextEditSearchLine* getCapSearch_;
#endif

    MvQWmsGetCapHighlighter* highlighterGetCap_;

    QProgressBar* loadProgress_;

    QMap<QString, QLineEdit*> reqLe_;
    QMap<QString, QTextEdit*> reqTe_;
    QSplitter* reqSplitter_;
    QWidget* reqEditPanel_;
    QScrollArea* reqEditSa_;
};


#endif
