/* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of mlminidom, the Ocaml binding for minidom.
 * 
 * mlminidom is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * mlminidom is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mlminidom; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 */

#ifndef ml_minidom_h
#define ml_minidom_h

#define Val_ptr(p)        ((value) (p))
#ifndef Val_option
#define Val_option(p,f)   ((p != NULL) ? ml_some(f(p)) : Val_unit)
#endif /* Val_option */
#define mDOMString_val(v) ((mDOMStringRef) String_val(v))
#define mDOMNode_val(v) ((mDOMNodeRef) v)

#define mDOMNode_option_mDOMNodeRef(p) (((p) != NULL) ? ml_some((value) (p)) : Val_unit)
#define mDOMNodeRef_mDOMNode_option(v) ((v == Val_unit) ? NULL : (mDOMNodeRef)Field((v),0))
#define Val_mDOMNodeRef(p)             (mDOMNode_option_mDOMNodeRef(p))
#define mDOMNodeRef_val(v)             (mDOMNodeRef_mDOMNode_option(v))
#define mDOMDocRef_val(r)              (*((mDOMDocRef *)Data_custom_val(r)))

#endif /* ml_minidom_h */
