/* mondo-tarme                     Hugo Rabson                       03/03/2002


03/03
- modified 'Sliced bigfile #n' log entry to say '..#(n+1)'

02/20
- added lots of cdstream-related code

02/10
- changed "please insert blank CD-R" msg to suit anal CD-RW users

02/02
- finer-grained progress-reporting when backing up big files

01/31
- record+restore biggiefiles' chmod+chown settings
- removed MINDI_HOME: it is unnecessary

01/29
- many subroutines have been moved to the new 'mondo-archive.c'
- handles files >2GB in size

01/26
- added M-NDO_HOME and MINDI_HOME #define's to my-stuff.h

01/25
- removed '-c 1024' from tar_this_set()'s call to afio
- implemented --skip-floppies

01/23
- if the user specifies boot loader or device, record those settings
- cosmetic clean-ups
- fixed bug in /tmp/changed.files-generator

01/19
- changed g_tape_position to g_tape_posK (and its value is /1024 of old)
- used 'buffer' (external proggy) to speed up tape access
- files <32MB aren't chopped
- chdir("/") before verifying CD image
- cleaned up CD verification

01/16
- sleep()-related fix to eval_call()
- changed 'tarball' labels to 'fileset'
- improved the disk-formatting and -writing GUI

01/13
- moved misc functions from mondo-archive into here
- beautified the call to mindi

01/08
- chdir("/") before verifying tape archives

01/06/2002
- still implementing improved tape support

12/01 - 12/31 (2001)
- making Mondo's usage of tapes more 'CD-like'; when writing archives to tape,
  split archives into N sets, etc.
- changed CURR_ISO_NO to g_current_media_number
- used to refer to /usr/share/mondo/something; now refers to /usr/local/-ondo/
- if fail to add a file to scratchdir/CD then abort (don't just warn)
- if Mondo says so, then TEXT MODE (no ncurses or newt)
- when backing up to tape, afios skip the first 32MB - a section which
  probably contains an extended 'data disk' (tarball for Mindi)
- when verifing tape, skip first 32MB first
- if the call to afio to verify a tape causes an error then return that error
- fixed bugs in actually_verify_tape_archives()
- improved afio's tape verification code
- allow biggiefiles to be lzop'd instead of bzip2'd if user uses --use-lzo
- don't take checksum of /dev/ * if image/bigfile
- combined slice_up_file and send_slices_to_cd into slice_up_file_etc()
- slice up biggiefiles one slice at a time before trying to archive them;
  don't try to slice entire file & then try to archive it to N CD's :)
  ...cos, as Jewel would say, it is "wasteful & useless in times like these"
- implemented verify_tape_archives()
- removed all '/ /' comments
- enlarged afio's "-M" parameter from 12M to 16M
- disabled some excessively verbose logging (<this> is OK, <that> is OK, ...)
- used '-Wall' compiler switch to find a bunch of chaff, e.g. unused vars;
  removed said chaff
- fixing some tape-related sillies that were introduced when I rearranged
  the source files in late November
- added do-not-compress-these file, so that MP3's etc. are not compressed

11/01 - 11/30
- before archiving biggiefiles, make_slices_and_images() verifies that there
  are in fact biggiefiles to be archived; if there are not, it doesn't try
- put procedures in alphabetical order
- if differences found during verification of CD then don't say the CD is bad;
  just say, differences were found :-)
- res+=retval; should have been retval+=res (Tony Kim)

10/01 - 10/31
- moved call to verify_cd_image() to the line after make_iso_fs; if verify
  fails, Mondo will prompt user to retry (burning the CD)
- disabled the 'burning first/last/whatever CD' comment; now it's just, plain
  'burnin CD #n'; much easier to code & less potential for confusion
- if user uses --write-tapes and --verify 1|2|3 then tell user Mondo doesn't
  yet know how to verify tape backups
- replace USE_BZIP2 with USE_LZO boolean; bzip2 is default; LZO is faster
  option (NB: _option_) activated by '--use-lzo' command-line parameter
- replaced '.bz2' with bkpinfo->zip_suffix
- replaced bzip2 with bkpinfo->zip_exe
- slices are always bzip2'd; never lzo'd
- if fails but user doesn't abort then _continue_; don't loop around & around
- if backup (CD #n) fails, offer to retry; then, offer to abort; if user
  chooses not to retry but not to abort either then continue

09/01 - 09/30
- writing make_tape_archives(), to backup stuff to tape
- measure progress by the filelist# we're on, rather than the number of
  files that we have archived so far
- working on CD-verifying routines
- if verify is enabled then CD will not be ejected after being burnt
- added a call to verify the CD images after creating them
- ported mondo-tarme to C; this C source was created on 09/03/2001


-----------------------------------------------------------------------------
*/


#include "my-stuff.h"



extern long g_noof_sets;

extern long g_start_time, g_minimum_progress, g_maximum_progress,
  g_current_progress, g_currentY;     /* declared in mondo-tools.c */
extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];

extern bool g_debugging, g_running_live, g_text_mode,
  g_cd_recovery, g_skip_floppies;
extern char *g_kernel_path;

extern FILE *g_tape_stream;
extern long long g_tape_posK;
extern int g_current_media_number;
extern newtComponent g_progressForm;



extern int ask_me_yes_or_no(char*);
extern char *calc_checksum_of_file(char*filename);
extern void center_string(char*, int);
extern void close_evalcall_form(void);
extern void close_progress_form(void);
extern long count_lines_in_file(char*);
extern bool does_file_exist(char*);
extern int eval_call(struct s_bkpinfo*, char*,char*,int,char*,char*);
extern void fatal_error(char*);
extern int get_last_filelist_number(struct s_bkpinfo*);
extern char *last_line_of_file(char*);
extern long long length_of_file(char*);
extern void log_file_end_to_screen(char*,char*);
extern void log_it(char*);
extern void log_tape_pos(void);
extern void log_to_screen(char*);
extern void mvaddstr_and_log_it(int, int, char *);
extern void open_evalcall_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern int openin_tape(struct s_bkpinfo*);
extern int openout_cdstream(char*,int);
extern int openout_tape(char*);
extern void pause_and_ask_for_cdr(int);
extern void popup_and_OK(char*);
extern bool popup_and_get_string(char*,char*,char*);
extern int run_program_and_log_output(char*);
extern int run_program_and_log_to_screen(char*, char*);
extern long size_of_all_biggiefiles_K(struct s_bkpinfo*);
extern char *slice_fname(long,long,char*,char*);
extern long long space_occupied_by_cd(char *);
extern void update_evalcall_form(int);
extern void update_progress_form(char*);
extern int verify_cd_image(struct s_bkpinfo *);
extern int write_data_disks_to_tape(char*);
extern int write_file_to_tape_from_file(struct s_bkpinfo*, char*);
extern int write_header_block_to_tape(long long, char*, int);


int add_files_to_cd(struct s_bkpinfo*, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN],int);
int add_files_to_media(struct s_bkpinfo*, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN],int);
int add_file_to_tape(struct s_bkpinfo*, char*);
int chop_filelist(char*, char*, long);
int do_that_initial_stuff_dude(struct s_bkpinfo*);
int make_iso_fs(struct s_bkpinfo*, char*);
int make_slices_and_images(struct s_bkpinfo*, char*);
int make_tape_archives(char *);
int make_afioballs_and_images(struct s_bkpinfo*);
void pause_and_ask_for_cdr(int);
int prepare_filelist(struct s_bkpinfo*);
int slice_up_file_etc(struct s_bkpinfo*, char*, long, long);
int tar_this_set(struct s_bkpinfo*, char*, char*, int);
int write_final_iso_if_necessary(struct s_bkpinfo*);
int write_iso_and_go_on(struct s_bkpinfo*,bool);
void wipe_archives(char*);



/*---------------------------------------------------------------------*/



int add_files_to_cd(struct s_bkpinfo *bkpinfo, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN],int noof_files)
{
  int retval=0,res=0,i;
  char tmp[MAX_STR_LEN];
  long would_occupy;

  would_occupy=space_occupied_by_cd(bkpinfo->scratchdir);
  for(i=0; i<noof_files; i++)
    {
      if (!does_file_exist(list_of_files[i]))
	{
	  sprintf(tmp,"Warning - you're trying to add a non-existent file - '%s' to the CD",list_of_files[i]);
	  log_it(tmp);
	}
      would_occupy+=length_of_file(list_of_files[i])/1024;
    }
  if (would_occupy/1024 > bkpinfo->media_size)
    {
      res=write_iso_and_go_on(bkpinfo,FALSE);  /* FALSE because this is not the last CD we'll write */
      retval+=res;
      if (res) { log_it("WARNING - write_iso_and_go_on returned an error"); }
    }
  for(i=0;i<noof_files;i++)
    {
      sprintf(tmp,"cp -f %s %s/archives/",list_of_files[i],bkpinfo->scratchdir);
      res=run_program_and_log_output(tmp);
      retval+=res;
      if (res) { strcat(tmp," ...failed"); log_to_screen(tmp); }
      unlink(list_of_files[i]);
    }
  if (retval)
    { log_it("Warning - errors occurred while I was adding files to CD dir"); }
  return(retval);
}




int add_files_to_media(struct s_bkpinfo *bkpinfo, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN], int noof_files)
{
  int res,i;
  char tmp[MAX_STR_LEN], *p;
  if (bkpinfo->using_tape || bkpinfo->using_cdstream)
    /* tape users */
    {
      for(i=0; i<noof_files; i++)
        {
	  if (strstr(list_of_files[i],".afio") || strstr(list_of_files[i],"slice-"))
	    {
	      res=add_file_to_tape(bkpinfo,list_of_files[i]);
	    }
	  else
	    {
	      p=strchr(list_of_files[i],'/');
	      if (!p) {p=list_of_files[i];} else {p++;}
	      sprintf(tmp,"Not copying %s to tape (it's not an archive)",p);
	      if (!strstr(p,"filelist.")) { log_it(tmp); }
	    }
        }
    }
  else
    /* CD users */
    {
      res=add_files_to_cd(bkpinfo,list_of_files,noof_files);
    }
  return(res);
}



int add_file_to_tape(struct s_bkpinfo *bkpinfo, char*file_to_add)
{
  int retval=0,res=0;
  char tmp[MAX_STR_LEN], start_chr, stop_chr;
  long long length_of_incoming_file;

/* skip file if it doesn't exist */
  if (!does_file_exist(file_to_add))
    {
      sprintf(tmp,"Warning - you're trying to add a non-existent file - '%s' to the tape",file_to_add);
      log_it(tmp);
    }
/* create header chars */
  start_chr = BLK_START_AN_AFIO_OR_SLICE;
  stop_chr  = BLK_STOP_AN_AFIO_OR_SLICE;
/* ask for new tape if necessary */
  length_of_incoming_file = length_of_file(file_to_add);
  write_header_block_to_tape(length_of_incoming_file,file_to_add,start_chr);
  res=write_file_to_tape_from_file(bkpinfo,file_to_add);
  retval+=res;
  unlink(file_to_add);
/* write closing header */
  write_header_block_to_tape(0,"finished-writing-file",stop_chr);
  if (retval)
    { log_it("Warning - errors occurred while I was adding file to tape"); }
  return(retval);
}








void call_filelist_chopper(struct s_bkpinfo *bkpinfo)
{
  char dev[MAX_STR_LEN],
    tmp[MAX_STR_LEN], filelist[MAX_STR_LEN],
    tempfile[MAX_STR_LEN],
    cksumlist[MAX_STR_LEN], *ptr;
  int res=0,i;
  FILE*fout;

  mvaddstr_and_log_it(g_currentY,0,"Dividing filelist into sets");
  log_to_screen("Dividing filelist into sets. Please wait.");
  sprintf(filelist,"%s/archives/filelist.full",bkpinfo->scratchdir);
  sprintf(cksumlist,"%s/cklist.full",bkpinfo->tmpdir);
  res=chop_filelist(filelist, bkpinfo->tmpdir, bkpinfo->optimal_set_size);
  sprintf(tempfile,"%s/biggielist.txt",bkpinfo->tmpdir);
  if (!(fout=fopen(tempfile,"a"))) { fatal_error("Cannot append to biggielist.txt"); }
  log_it(bkpinfo->image_devs);
  ptr = bkpinfo->image_devs;
  while (ptr && *ptr)
    {
      strcpy(dev,ptr);
      sprintf(tmp,"Examining imagedev %s", dev);
      log_it(tmp);
      for(i=0;i<strlen(dev) && dev[i]!=' ';i++);
      tmp[i]='\0';
      if (!strlen(dev)) {continue;}
      fprintf(fout,"%s\n",dev);
      sprintf(tmp,"Adding '%s' to biggielist",dev);
      log_it(tmp);
      if ((ptr=strchr(ptr,' '))) { ptr++; }
    }
  fclose(fout);
  mvaddstr_and_log_it(g_currentY++,74,"Done.");
}




int chop_filelist(char *filelist, char*outdir, long maxsetsizeK)
{
  long
    lino=0,
    max_sane_size_for_a_file=SLICE_SIZE*2,
    curr_set_size,
    noof_lines,
    siz;
  int i,curr_set_no;
  char
    outfname[1000],
    biggie_fname[1000],
    incoming[1000],
    tmp[1000];
  FILE*fin,
    *fout,
    *fbig;
  struct stat buf;

  open_evalcall_form("Dividing filelist into sets");
  noof_lines=count_lines_in_file(filelist);
  fin=fopen(filelist,"r");
  curr_set_no=0;
  curr_set_size=0;
  sprintf(outfname,"%s/filelist.%d",outdir,curr_set_no);
  sprintf(biggie_fname,"%s/biggielist.txt",outdir);
  if (!(fbig=fopen(biggie_fname,"w")))
    {
      sprintf(tmp,"unable to open %s\n",biggie_fname);
      fatal_error(tmp);
    }
  if (!(fout=fopen(outfname,"w")))
    {
      sprintf(tmp,"unable to open %s\n",outfname);
      fatal_error(tmp);
    }
    
  fgets(incoming,999,fin);
  while (!feof(fin))
    {
      lino++;
      i=strlen(incoming)-1;
      if (i<0) {i=0;}
      if (incoming[i]<32) {incoming[i]='\0';}
      if (!strncmp(incoming,"/dev/",5)) {siz=1;}
      else if (lstat(incoming,&buf)!=0) {siz=0;}
      else {siz=buf.st_size>>10;}
      if (siz > max_sane_size_for_a_file /*maxsetsizeK*/)
	{
	  fprintf(fbig,"%s\n",incoming);
	}
      else
	{
	  curr_set_size+=siz;
	  fprintf(fout,"%s\n",incoming);
	  if (curr_set_size > maxsetsizeK)
	    {
	      fclose(fout);
	      curr_set_no++;
	      curr_set_size=0;
	      sprintf(outfname,"%s/filelist.%d",outdir,curr_set_no);
	      fout=fopen(outfname,"w");
	      sprintf(tmp,"Fileset #%d chopped ",curr_set_no-1);
              update_evalcall_form((int)(lino*100/noof_lines));
	      /*	      if (!g_text_mode) {newtDrawRootText(0,22,tmp);newtRefresh();} else {log_it(tmp);} */
	    }
	}
      fgets(incoming,999,fin);
    }
  fclose(fin);
  fclose(fout);
  fclose(fbig);
  g_noof_sets = curr_set_no;
  sprintf(tmp,"echo %d > %s/LAST-FILELIST-NUMBER",curr_set_no,outdir);
  system(tmp);
  if (curr_set_no==0)
    { sprintf(tmp,"Only one fileset. Fine."); }
  else
    { sprintf(tmp,"Filelist divided into %d sets",curr_set_no+1); }
  log_to_screen(tmp);
  close_evalcall_form();
  /* This is to work around an obscure bug in Newt; open a form, close it,
     carry on... I don't know why it works but it works. If you don't do this
     then update_progress_form() won't show the "time taken / time remaining"
     line. The bug only crops up AFTER the call to chop_filelist(). Weird. */
  if (!g_text_mode)
    {
      open_progress_form("","","","",100);
      newtPopHelpLine(); newtFormDestroy(g_progressForm); newtPopWindow();
    }
  return(0);
}



int do_that_initial_stuff_dude(struct s_bkpinfo *bkpinfo)
{
  int retval=0;
  char command[MAX_STR_LEN], tmpfile[MAX_STR_LEN];

  mvaddstr_and_log_it(g_currentY,0,"Preparing to archive your data");
  if (bkpinfo->using_tape)
    {
/*      g_tape_stream = fopen(bkpinfo->media_device,"w"); */
      openout_tape(bkpinfo->media_device); /* sets g_tape_stream */
      if (!g_tape_stream) {fatal_error("Cannot open tape device");}
      log_it("tape drive stream opened OK");
      sprintf(tmpfile,"%s/all.tar.gz",bkpinfo->tmpdir);
      write_data_disks_to_tape(tmpfile);
    }
  else if (bkpinfo->using_cdstream)
    {
      openout_cdstream(bkpinfo->media_device, bkpinfo->cdrw_speed);
      if (!g_tape_stream) {fatal_error("Cannot open cdstream device");}
      log_it("cdstream opened OK");
      sprintf(tmpfile,"%s/all.tar.gz",bkpinfo->tmpdir);
      write_data_disks_to_tape(tmpfile);
    }
  else
    {
      log_it("Backing up to CD's");
    }

  sprintf(command,"rm -f %s/*.iso",bkpinfo->isodir);
  system(command);
  wipe_archives(bkpinfo->scratchdir);
  mvaddstr_and_log_it(g_currentY++,74,"Done.");
  if (bkpinfo->using_tape || bkpinfo->using_cdstream)
    {
      write_header_block_to_tape(0,"start-of-tape",BLK_START_OF_TAPE);
      write_header_block_to_tape(0,"start-of-backup",BLK_START_OF_BACKUP);
    }
  return(retval);
}






int make_iso_fs(struct s_bkpinfo *bkpinfo, char*destfile)
{
  int retval=0,res;
  char old_pwd[MAX_STR_LEN], tmp[MAX_STR_LEN], message_to_screen[MAX_STR_LEN];
  sprintf(tmp,"make_iso_fs --- scratchdir=%s --- destfile=%s",bkpinfo->scratchdir,destfile);
  log_it(tmp);

  getcwd(old_pwd,MAX_STR_LEN-1);
  chdir(bkpinfo->scratchdir);

  if (bkpinfo->call_before_iso[0]!='\0')
    {
      sprintf(message_to_screen,"Running pre-ISO call for CD#%d",g_current_media_number);
      res=eval_call(bkpinfo,bkpinfo->call_before_iso,destfile,g_current_media_number,MONDO_LOGFILE,message_to_screen);
      if (res) { strcat(message_to_screen,"...failed"); }
      else { strcat(message_to_screen,"...OK"); }
      log_to_screen(message_to_screen);
      retval+=res;
    }

  if (bkpinfo->call_make_iso[0]!='\0')
    {
      sprintf(tmp,"%s/archives/NOT-THE-LAST",bkpinfo->scratchdir);
      sprintf(message_to_screen,"Making an ISO (CD #%d)",g_current_media_number);
      pause_and_ask_for_cdr(2); /* if g_current_media_number >= 2 then pause & ask */
      res=eval_call(bkpinfo,bkpinfo->call_make_iso,bkpinfo->scratchdir,g_current_media_number,MONDO_LOGFILE,message_to_screen);
      if (res) { strcat(message_to_screen,"...failed"); }
      else { strcat(message_to_screen,"...OK"); }
      log_to_screen(message_to_screen);
      retval+=res;
    }
  else
    {
      sprintf(message_to_screen,"Running mkisofs to make CD #%d",g_current_media_number);
      log_it(message_to_screen);
      sprintf(tmp,"Call to mkisofs to make ISO (CD #%d) ",g_current_media_number);
      res=eval_call(bkpinfo,"mkisofs -b images/mindi-boot.2880.img -c boot.cat -o _ISO_ -J -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL -V _CD#_ .",destfile,g_current_media_number,MONDO_LOGFILE,message_to_screen);
      if (res) { strcat(tmp,"...failed"); } else { strcat(tmp,"...OK");}
      log_to_screen(tmp);
      retval+=res;
    }

  if (bkpinfo->call_burn_iso[0]!='\0')
    {
      sprintf(message_to_screen,"Burning ISO (CD #%d)",g_current_media_number);
      pause_and_ask_for_cdr(2);
      res=eval_call(bkpinfo,bkpinfo->call_burn_iso,destfile,g_current_media_number,MONDO_LOGFILE,message_to_screen);
      if (res) { strcat(message_to_screen,"...failed"); }
      else { strcat(message_to_screen,"...OK"); }
      log_to_screen(message_to_screen);
      retval+=res;
    }

  if (bkpinfo->call_after_iso[0]!='\0')
    {
      sprintf(message_to_screen,"Running post-ISO call (CD #%d)",g_current_media_number);
      res=eval_call(bkpinfo,bkpinfo->call_after_iso,destfile,g_current_media_number,MONDO_LOGFILE,message_to_screen);
      if (res) { strcat(message_to_screen,"...failed"); }
      else { strcat(message_to_screen,"...OK"); }
      log_to_screen(message_to_screen);
      retval+=res;
    }

  chdir(old_pwd);
  if (retval) { log_it("WARNING - make_iso_fs returned an error"); }
  return(retval);
}





int make_slices_and_images(struct s_bkpinfo*bkpinfo, char*biggielist_fname)
{
  FILE*fin;
  char tmp[MAX_STR_LEN], bigfile_fname[MAX_STR_LEN], *p;
  long biggie_file_number=0, noof_biggie_files, estimated_total_noof_slices=0;
  int retval=0,res=0;
  long long biggie_fsize;

  sprintf(tmp, "size of all biggiefiles = %ld", size_of_all_biggiefiles_K(bkpinfo));
  log_it(tmp);
  estimated_total_noof_slices = size_of_all_biggiefiles_K(bkpinfo) / bkpinfo->optimal_set_size + 1;
  sprintf(tmp, "estimated_total_noof_slices = %ld KB / %ld KB = %ld", size_of_all_biggiefiles_K(bkpinfo), bkpinfo->optimal_set_size, estimated_total_noof_slices);
  log_it(tmp);
  if (length_of_file(biggielist_fname)<6)
    {
      log_it("No biggiefiles; fair enough...");
      return(0);
    }
  sprintf(tmp,"I am now backing up all large files.");
  log_to_screen(tmp);
  noof_biggie_files=count_lines_in_file(biggielist_fname);
  open_progress_form("Backing up big files", tmp, "Please wait. This may take some time.", "", estimated_total_noof_slices);
  fin=fopen(biggielist_fname,"r");
  for(fgets(bigfile_fname,MAX_STR_LEN,fin); !feof(fin); fgets(bigfile_fname,MAX_STR_LEN,fin),biggie_file_number++)
    {
      if (bigfile_fname[strlen(bigfile_fname)-1]<32) {bigfile_fname[strlen(bigfile_fname)-1]='\0';}
      biggie_fsize = length_of_file(bigfile_fname);
      if (!does_file_exist(bigfile_fname))
        {
	  sprintf(tmp,"Skipping bigfile %s (nonexistent)",bigfile_fname);
        }
      else
        {
          sprintf(tmp,"Bigfile #%ld is '%s' (%ld KB)",biggie_file_number,bigfile_fname,(long) biggie_fsize>>10);
	  /*log_it(tmp);*/
          if (bkpinfo->using_tape || bkpinfo->using_cdstream) {write_header_block_to_tape(biggie_fsize,bigfile_fname,BLK_START_A_BIGGIE);}
          res=slice_up_file_etc(bkpinfo,bigfile_fname,biggie_file_number,noof_biggie_files);
          if (bkpinfo->using_tape || bkpinfo->using_cdstream) {write_header_block_to_tape(0,calc_checksum_of_file(bigfile_fname),BLK_STOP_A_BIGGIE);}
          retval+=res;
	  p = strrchr(bigfile_fname,'/');
	  if (p) {p++;} else {p=bigfile_fname;}
          sprintf(tmp,"Archiving bigfile %s ... ",p);
          if (res) { strcat(tmp,"Failed!"); } else { strcat(tmp,"OK"); }
        }
      log_to_screen(tmp);
    }
  log_it("Finished backing up bigfiles");
  sprintf(tmp,"estimated slices = %ld; actual slices = %ld", estimated_total_noof_slices, g_current_progress);
  log_it(tmp);
  close_progress_form();
  return(retval);
}




char *percent_media_full_comment(struct s_bkpinfo *bkpinfo)
{
  int percentage,j;
  static char outstr[MAX_STR_LEN];

/* update screen */
 if (bkpinfo->using_tape)
    {
      percentage=(int)(g_tape_posK/10/bkpinfo->media_size);
      if (percentage>100) {percentage=100;}
      sprintf(outstr, "Tape #%d: [",g_current_media_number);
    }
  else if (bkpinfo->using_cdstream)
    {
      percentage=(int)(g_tape_posK/10/bkpinfo->media_size);
      if (percentage>100) {percentage=100;}
      sprintf(outstr, "CD #%d: [",g_current_media_number);
    }
  else
    {
      percentage=(int)(space_occupied_by_cd(bkpinfo->scratchdir)*100/1024/bkpinfo->media_size);
      sprintf(outstr,"CD #%d: [",g_current_media_number);
    }
  for(j=0;j<percentage;j+=5) { strcat(outstr,"*"); }
  for(;j<100;j+=5) { strcat(outstr,"."); }
  j=strlen(outstr);
  sprintf(outstr+j,"] %d%% used",percentage);
  return(outstr);
}


int make_afioballs_and_images(struct s_bkpinfo *bkpinfo)
{
  int retval=0, curr_set_no=0,noof_files,res=0;
  char curr_filelist_fname[MAX_STR_LEN],
    curr_afioball_fname[MAX_STR_LEN], tmp[MAX_STR_LEN],
    files_to_send[ARBITRARY_MAXIMUM][MAX_STR_LEN],
    media_usage_comment[MAX_STR_LEN];

  sprintf(tmp,"%s/archives/filelist.full",bkpinfo->scratchdir);
  log_to_screen("Archiving regular files");
  open_progress_form("Backing up filesystem","I am backing up your live filesystem now.","Please wait. This may take a couple of hours.","Working...",get_last_filelist_number(bkpinfo)+1);
  sprintf(curr_filelist_fname,"%s/filelist.%d",bkpinfo->tmpdir,0);
  for(curr_set_no=0; does_file_exist(curr_filelist_fname); sprintf(curr_filelist_fname,"%s/filelist.%d",bkpinfo->tmpdir,++curr_set_no))
    {
      /* backup this set of files */
      sprintf(curr_filelist_fname,"%s/filelist.%d",bkpinfo->tmpdir,curr_set_no);
      sprintf(curr_afioball_fname,"%s/tmpfs/%d.afio.%s",bkpinfo->tmpdir,curr_set_no,bkpinfo->zip_suffix);
      sprintf(tmp,"\nArchiving set %d",curr_set_no);
      log_it(tmp);
      res=tar_this_set(bkpinfo, curr_filelist_fname, curr_afioball_fname, curr_set_no);
      retval+=res;
      if (res)
	{
	  sprintf(tmp,"Errors occurred while archiving set %d. Perhaps your live filesystem changed?",curr_set_no);
	  log_to_screen(tmp);
	}

      strcpy(media_usage_comment, percent_media_full_comment(bkpinfo));

      /* copy to CD (scratchdir) ... and an actual CD-R if necessary */
      noof_files=0; /* incremented by the next two lines */
      strcpy(files_to_send[noof_files++],curr_filelist_fname);
      strcpy(files_to_send[noof_files++],curr_afioball_fname);
      res=add_files_to_media(bkpinfo,files_to_send,noof_files);
      retval+=res;

      g_current_progress++;
      update_progress_form(media_usage_comment);

      if (res)
	{
	  sprintf(tmp,"Failed to add archive %d's files to CD dir\n",curr_set_no);
	  log_to_screen(tmp);
	  fatal_error("Is your hard disk is full? If not, please send the author the logfile.");
	}
    }
  close_progress_form();
  sprintf(tmp,"Your regular files have been archived ");
  if (retval) { strcat(tmp,"(with errors)."); }
  else { strcat(tmp,"successfully."); }
  log_to_screen(tmp);
  return(retval);
}







int make_those_afios_dude(struct s_bkpinfo *bkpinfo)
{
  int res=0,retval=0;

  mvaddstr_and_log_it(g_currentY,0,"Archiving regular files to media");
  if (bkpinfo->using_tape || bkpinfo->using_cdstream) { write_header_block_to_tape(0,"start-of-afioballs",BLK_START_AFIOBALLS); }
  res=make_afioballs_and_images(bkpinfo);
  if (bkpinfo->using_tape || bkpinfo->using_cdstream) { write_header_block_to_tape(0,"stop-afioballs",BLK_STOP_AFIOBALLS); }
  retval+=res;
  if (res) { mvaddstr_and_log_it(g_currentY++,74,"Errors."); log_it("make_afioballs_and_images returned an error"); }
  else { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}



int make_those_slices_dude(struct s_bkpinfo *bkpinfo)
{
  int res=0,retval=0;
  char biggielist[MAX_STR_LEN], command[MAX_STR_LEN], blah[MAX_STR_LEN];

  /* slice big files */
  mvaddstr_and_log_it(g_currentY,0,"Archiving large files to media");
  sprintf(biggielist,"%s/archives/biggielist.txt",bkpinfo->scratchdir);
  sprintf(command,"cp %s/biggielist.txt %s",bkpinfo->tmpdir,biggielist);
  log_it(command);
  if (system(command)) { log_it("...failed"); }
  sprintf(blah,"biggielist = %s",biggielist);
  log_it(blah);
  if (!does_file_exist(biggielist)) { log_it("BTW, the biggielist does not exist"); }
  if (bkpinfo->using_tape || bkpinfo->using_cdstream)
    {
      sprintf(blah,"%ld",count_lines_in_file(biggielist));
      write_header_block_to_tape(0,blah,BLK_START_BIGGIEFILES);
    }
  res=make_slices_and_images(bkpinfo,biggielist);
  if (bkpinfo->using_tape || bkpinfo->using_cdstream)
    {
      write_header_block_to_tape(0,"end-of-biggiefiles",BLK_STOP_BIGGIEFILES);
    }
  retval+=res;
  if (res) { log_it("make_slices_and_images returned an error"); mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}




int do_that_final_stuff_dude(struct s_bkpinfo *bkpinfo)
{
  int res=0,retval=0,i;
  char blk[1024];
//  pid_t pid;

  mvaddstr_and_log_it(g_currentY,0,"Writing any remaining data to media");
/*
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error");
      case 0: 
*/

        log_it("Fork is closing tape/CD ... ");
        if (bkpinfo->using_tape || bkpinfo->using_cdstream)
        /* write tape/cdstream */
          {
            write_header_block_to_tape(0,"end-of-backup",BLK_END_OF_BACKUP);
            write_header_block_to_tape(0,"end-of-tape",BLK_END_OF_TAPE); /* just in case */
            for(i=0;i<1024;i++) { blk[i]='\0'; }
            for(i=0;i<1024;i++)
              {
                fwrite(blk, 1, 1024, g_tape_stream);
              }
            pclose(g_tape_stream);
          }
        else
        /* write final ISO */
          {
            res=write_final_iso_if_necessary(bkpinfo);
            retval+=res;
            if (res) { log_it("write_final_iso_if_necessary returned an error"); }
          }
        log_it("Fork is exiting ... ");

/*
        exit(0);
      default:
        open_evalcall_form("Writing any remaining data to media");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
            sleep(1);
            update_evalcall_form(0);
          }
        close_evalcall_form();
*/

        mvaddstr_and_log_it(g_currentY++,74,"Done.");
      /* final stuff */
        if (retval)
          { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
         else
          { mvaddstr_and_log_it(g_currentY++,74,"Done."); }

/*
    }
*/


  return(retval);
}






void pause_and_ask_for_cdr(int ask_for_one_if_more_than_this)
{
  char tmp[MAX_STR_LEN];
  sprintf(tmp,"I am about to burn CD #%d",g_current_media_number);
  log_it(tmp);
  if (g_current_media_number >= ask_for_one_if_more_than_this)
    {
      sprintf(tmp,"I am about to burn CD #%d of the backup set. Please insert a CD-R(W) and press Enter.",g_current_media_number);
      popup_and_OK(tmp);
    }
  log_it("OK, I assume I have a blank CD in the drive...");
}




int slice_up_file_etc(struct s_bkpinfo*bkpinfo, char*filename, long biggie_file_number, long noof_biggie_files)
{
  char tmp[MAX_STR_LEN], checksum_line[MAX_STR_LEN], command[MAX_STR_LEN], *pB, tempblock[256*1024], curr_slice_fname_uncompressed[MAX_STR_LEN],
     curr_slice_fname_compressed[MAX_STR_LEN], list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN];
  FILE*fin,*fout;
  bool finished=FALSE;
  long blksize=0, slice_num=0, i, optimal_set_size;
  int retval=0,res=0;
  long long length;
  struct stat buf;

  optimal_set_size=bkpinfo->optimal_set_size;
  if (optimal_set_size<999){fatal_error("bkpinfo->optimal_set_size is insanely small");}
  if (!strncmp(filename,"/dev/",5)) { strcpy(tmp,"IGNORE"); }
  else
    {
      sprintf(command,"md5sum \"%s\"",filename);
      fin=popen(command,"r");
      fgets(tmp,MAX_STR_LEN,fin);
      pclose(fin);
      pB=strchr(tmp,' ');
      if (pB) { *pB='\0'; }
    }
  sprintf(checksum_line,"%s\t%s",tmp,filename);
  sprintf(tmp,"Bigfile #%ld's checksum = '%s'",biggie_file_number,checksum_line);
  /* log_it(tmp); */
  strcpy(tmp,slice_fname(biggie_file_number,0,bkpinfo->tmpdir,""));
  log_it(tmp);
  fout=fopen(tmp,"w");
  fprintf(fout,"%s\n",checksum_line);
  lstat(filename, &buf);
  fwrite((char*)(&buf),1,sizeof(struct stat),fin);
  fclose(fout);
  length=length_of_file(filename)/optimal_set_size/1024;
  fin=fopen(filename,"r");
  if (!fin)
    { sprintf(tmp,"Cannot archive bigfile '%s': not found",filename); log_to_screen(tmp); return(1); }
  strcpy(list_of_files[0],slice_fname(biggie_file_number,0,bkpinfo->tmpdir,""));
  retval+=add_files_to_media(bkpinfo, list_of_files, 1);
  for(slice_num=1; !finished; slice_num++)
    {
      strcpy(curr_slice_fname_uncompressed,slice_fname(biggie_file_number,slice_num,bkpinfo->tmpdir,""));
      strcpy(curr_slice_fname_compressed,slice_fname(biggie_file_number,slice_num,bkpinfo->tmpdir,bkpinfo->zip_suffix));
      /*      sprintf(tmp,"Current file: [",biggie_file_number); */

      strcpy(tmp, percent_media_full_comment(bkpinfo));
/*
      sprintf(tmp,"File #%ld of %ld: [",biggie_file_number+1,noof_biggie_files);
      if (slice_num==1) {percentage=0;}
      else {percentage=(int)((slice_num-1)*20/length);}
      for(j=0; j<20 && j<percentage; j++) { strcat(tmp,"*"); }
      for(; j<20; j++) { strcat(tmp,"."); }
      strcat(tmp,"]");
*/
      update_progress_form(tmp);
      fout=fopen(curr_slice_fname_uncompressed,"w");
      for(i=0; i<bkpinfo->optimal_set_size/256; i++)
	{
	  blksize=fread(tempblock,1,256*1024,fin);
	  if (blksize>0) { fwrite(tempblock,1,blksize,fout); }
	  else { break; }
	}
      fclose(fout);
      if(length_of_file(curr_slice_fname_uncompressed)>0)
	{
	  if (!does_file_exist(curr_slice_fname_uncompressed))
	    {
	      sprintf(tmp,"Warning - '%s' doesn't exist. How can I compress slice?",curr_slice_fname_uncompressed);
	      log_it(tmp);
	    }
	  sprintf(command,"%s -%d %s",bkpinfo->zip_exe,bkpinfo->compression_level,curr_slice_fname_uncompressed);
	  log_it(command);
	  /*res=run_program_and_log_output(command);*/
	  res=system(command);
	  retval+=res;
	  if (res) { log_it("Failed to compress the slice"); }
	  if (!res && !does_file_exist(curr_slice_fname_compressed)) { log_it("Compressed slice but I can't find it now!"); res++; }
	  if (bkpinfo->use_lzo) { unlink(curr_slice_fname_uncompressed); }
	  if (res) { sprintf(tmp,"Problem with slice # %ld",slice_num); }
	  else { sprintf(tmp,"Bigfile #%ld, slice #%ld compressed OK          ",biggie_file_number+1,slice_num); }
	  log_it(tmp);
	  if (!g_text_mode) {newtDrawRootText(0,22,tmp);newtRefresh();} else {log_it(tmp);}
	  strcpy(list_of_files[0],curr_slice_fname_compressed);
          g_current_progress++;
	}
      else
	{
	  finished=TRUE;
	  strcpy(list_of_files[0],curr_slice_fname_uncompressed);
	  if (bkpinfo->using_tape || bkpinfo->using_cdstream) {break;}
	}
      res=add_files_to_media(bkpinfo, list_of_files, 1);
      retval+=res;
      if (res)
	{
	  sprintf(tmp,"Failed to add slice %ld of bigfile %ld to scratchdir",slice_num,biggie_file_number);
	  log_to_screen(tmp);
	  fatal_error("Hard disk full. You should have bought a bigger one.");
	}
    }
  fclose(fin);
  sprintf(tmp,"Sliced bigfile #%ld",biggie_file_number+1);
  if (retval) { strcat(tmp,"...FAILED"); }
  else { strcat(tmp,"...OK!"); }
  log_it(tmp);
  return(retval);
}






int tar_this_set(struct s_bkpinfo*bkpinfo, char*filelist, char*fname, int setno)
  {
    int retval=0,res=0;
    char command[MAX_STR_LEN],zipparams[MAX_STR_LEN],tmp[MAX_STR_LEN];
    sprintf(zipparams,"-Z -b %d -P %s -M 8m -G %d -U -T 3k",TAPE_BLOCK_SIZE, bkpinfo->zip_exe,bkpinfo->compression_level);
    if (!does_file_exist(filelist))
      {
	sprintf(tmp,"filelist %s does not exist",filelist);
	log_to_screen(tmp);
	return(1);
      }
    sprintf(command,"rm -f %s %s.gz %s.%s",fname,fname,fname,bkpinfo->zip_suffix);
    system(command);
    sprintf(command,"cat %s | afio -o %s %s",filelist,zipparams,fname);
    res=run_program_and_log_output(command);
    retval+=res;
    if (res) {
      log_it(command);
      log_it("...Failed.");
    }
    return(retval);
}







int write_final_iso_if_necessary(struct s_bkpinfo *bkpinfo)
{
  int res;
  char tmp[MAX_STR_LEN];
  /* I should really check if there are any slices or tarballs to be copied to CD-R(W)'s; the odds are approx. 1 in a million that there are no files here, so I'll just go ahead & make one more CD anyway */

  strcpy(tmp,"Writing the final ISO");
  log_it(tmp);
  center_string(tmp,80);
  if (!g_text_mode) {newtPushHelpLine(tmp);}
  res=write_iso_and_go_on(bkpinfo,TRUE);
  if (!g_text_mode) {newtPopHelpLine();}
  sprintf(tmp,"Returning from writing final ISO (res=%d)",res);
  log_it(tmp);
  return(res);
}








int write_iso_and_go_on(struct s_bkpinfo*bkpinfo, bool last_cd)
{
  FILE*fout;
  char tmp[MAX_STR_LEN], cdno_fname[MAX_STR_LEN], lastcd_fname[MAX_STR_LEN], isofile[MAX_STR_LEN];
  bool that_one_was_ok, using_nfs;
  int res=0;

  if (strlen(bkpinfo->nfs_mount)>1) { using_nfs=TRUE; } else { using_nfs=FALSE; }
  sprintf(tmp,"OK, time to make CD #%d",g_current_media_number);
  log_it(tmp);

  /* label the ISO with its number */
  sprintf(cdno_fname,"%s/archives/THIS-CD-NUMBER",bkpinfo->scratchdir);
  fout=fopen(cdno_fname,"w");
  fprintf(fout,"%d",g_current_media_number);
  fclose(fout);

  /* last CD or not? Label accordingly */
  sprintf(lastcd_fname,"%s/archives/NOT-THE-LAST",bkpinfo->scratchdir);
  if (last_cd)
    {
      unlink(lastcd_fname);
      log_it("OK, you're telling me this is the last CD. Fair enough.");
    }
  else
    {
      fout=fopen(lastcd_fname,"w");
      fprintf(fout,"You're listening to 90.3 WPLN, Nashville Public Radio.\n");
      fclose(fout);
    }
  if (space_occupied_by_cd(bkpinfo->scratchdir)/1024 > bkpinfo->media_size)
    {
      sprintf(tmp,"Warning! CD is too big. It occupies %ld KB, which is more than the %ld KB allowed.",(long)space_occupied_by_cd(bkpinfo->scratchdir),(long)bkpinfo->media_size);
      log_to_screen(tmp);
    }
/*
  if (using_nfs)
    {
      sprintf(isofile,"%s/%d.iso",bkpinfo->tmpdir, g_current_media_number);
    }
  else
    {
      sprintf(isofile,"%s/%d.iso",bkpinfo->isodir, g_current_media_number);
    }
*/

  sprintf(isofile, "%s/%s/%d.iso", bkpinfo->isodir, bkpinfo->nfs_remote_dir, g_current_media_number);

  for(that_one_was_ok=FALSE ; !that_one_was_ok; )
    {
      res=make_iso_fs(bkpinfo,isofile);
      if (bkpinfo->verify_data)
        {
	  res=0;
	  log_to_screen("Please reboot from the 1st CD in Compare Mode, as a precaution.");
	  chdir("/");
	  res+=verify_cd_image(bkpinfo); 
        }
      if (!res)
	{
	  that_one_was_ok=TRUE;
	}
      else
	{
	  sprintf(tmp,"Failed to burn CD #%d. Retry?",g_current_media_number);
	  res=ask_me_yes_or_no(tmp);
	  if (!res)
	    {
	      if (ask_me_yes_or_no("Abort the backup?"))
		{ fatal_error("FAILED TO BACKUP"); }
	      else
		{ break; }
	    }
	  else
	    { log_it("Retrying, at user's request..."); res=0; }
	}
    }
/*
  if (using_nfs)
    {
      sprintf(tmp,"mv -f %s %s/%s/", isofile, bkpinfo->isodir, bkpinfo->nfs_remote_dir);
      if (run_program_and_log_output(tmp))
        { log_to_screen("Unable to move ISO to NFS dir"); }
    }
*/
  g_current_media_number++;
  wipe_archives(bkpinfo->scratchdir);
  sprintf(tmp,"rm -Rf %s/images/*gz %s/images/*data*img",bkpinfo->scratchdir,bkpinfo->scratchdir);
  if (system(tmp))
    { log_it("Error occurred when I tried to delete the redundant IMGs and GZs"); }

  if (last_cd)
    { log_it("This was your last CD."); }
  else
    { log_it("Continuing to backup your data..."); }

  return(0);
}






int prepare_filelist(struct s_bkpinfo *bkpinfo)
{
  int res=0;
  char command[MAX_STR_LEN];
  pid_t pid;

  if (system("which mondo-makefilelist > /dev/null 2> /dev/null"))
    { fatal_error("Cannot find mondo-makefilelist"); }
  mvaddstr_and_log_it(g_currentY,0,"Making catalog of files to be backed up");
  sprintf(command,"mondo-makefilelist \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"", \
    MONDO_LOGFILE, bkpinfo->tmpdir, bkpinfo->scratchdir, bkpinfo->include_paths, bkpinfo->exclude_paths);
  if (bkpinfo->differential) { strcat(command," yes"); } else { strcat(command," \"\""); }
  log_it(command);
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error");
      case 0: system(command); exit(0);
      default:
        open_evalcall_form("Making catalog of filesystem");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
            sleep(1);
            update_evalcall_form(0);
          }
        close_evalcall_form();
        mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}





void wipe_archives(char*d)
{
  char tmp[MAX_STR_LEN], dir[MAX_STR_LEN];
  sprintf(dir,"%s/archives",d);
  sprintf(tmp,"rm -f %s/*.afio*",dir);              system(tmp);
  sprintf(tmp,"rm -f %s/filelist.[0-9]*",dir);      system(tmp);
  sprintf(tmp,"rm -f %s/slice*",dir);               system(tmp);
  sprintf(tmp,"rm -f %s/cklist*",dir);              system(tmp);
  sprintf(tmp,"rm -f %s/zero",dir);                 system(tmp);
  sprintf(tmp,"Wiped %s's archives",dir);
  log_it(tmp);
  sprintf(tmp,"ls -l %s",dir);
  run_program_and_log_output(tmp);
}


















