/* mondo-verify                                                     02/09/2002


02/09
- fixed bug in verify_cd_image()'s CD-mounting code

02/04
- don't write to screen "old cksum.. curr cksum.."

02/02
- changed the gawks to awks for the benefit of Debian

01/28
- handles files >2GB in size

01/23
- fixed bug in /tmp/changed.files-generator

01/18
- re-enabled a lot of CD-verification code
- afioballs are saved in %s/tmpfs/ now (%s=tmpdir)

01/14
- changed some labels to make them more user-friendly

01/08
- don't chdir() anywhere before verifying stuff

01/06
- changed files are now detected by verify_tape_backup() and listed in
  /tmp/changed.files

01/05
- replaced &> with > .. 2>

01/03
- still implementing improved tape support

-----------------------------------------------------------------------------
*/



#include "my-stuff.h"

extern FILE *g_tape_stream;
extern long g_start_time, g_minimum_progress, g_maximum_progress,
  g_current_progress, g_currentY;
extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];
extern int g_current_media_number;

extern void mvaddstr_and_log_it(int, int, char *);

extern int ask_me_yes_or_no(char*);
extern char *calc_checksum_of_file(char*filename);
extern void center_string(char*,int);
extern void close_evalcall_form(void);
extern int closein_tape(struct s_bkpinfo*);
int close_tape(struct s_bkpinfo*);
extern void close_progress_form(void);
extern long count_lines_in_file(char*);
extern bool does_file_exist(char*);
extern void exclude_nonexistent_files(char*);
extern void fatal_error(char*);
extern int find_and_mount_actual_cd(struct s_bkpinfo*, char*);
extern int find_cdrom_device(char*);
extern void finish(int);
extern int get_last_filelist_number(struct s_bkpinfo*);
extern long get_time(void);
extern int grab_percentage_from_last_line_of_file(char*);
extern char *last_line_of_file(char*);
extern long long length_of_file(char*);
extern void log_file_end_to_screen(char*,char*);
extern void log_it(char*);
extern void log_tape_pos(void);
extern void log_to_screen(char*);
extern char *marker_to_string(int);
extern void open_evalcall_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern int openin_tape(struct s_bkpinfo *);
extern void popup_and_OK(char*);
extern bool popup_and_get_string(char*,char*,char*);
extern int read_file_from_tape_to_file(struct s_bkpinfo*, char*, long long);
extern int read_header_block_from_tape(long long *, char*, int *);
extern int run_program_and_log_output(char*);
extern void setup_newt_stuff(void);
extern char *slice_fname(long,long,char*,char*);
extern long long space_occupied_by_cd(char *);
extern int strcmp_inc_numbers(char*,char*);
extern char *strip_afio_output_line(char*);
extern char *trim_empty_quotes(char*);
extern void update_evalcall_form(int);
extern void update_progress_form(char*);
extern int write_data_disks_to_tape(char*);
extern int write_header_block_to_tape(long long, char*, int);
extern void wrong_marker(int,int);


int verify_cd_image(struct s_bkpinfo*);
int verify_an_afioball(struct s_bkpinfo*, char*);
int verify_an_afioball_from_CD(struct s_bkpinfo*, char*);
int verify_an_afioball_from_tape(struct s_bkpinfo*, char*, long long);
int verify_a_biggiefile_from_tape(struct s_bkpinfo*, char*, long long);
int verify_afioballs_from_CD(struct s_bkpinfo *);
int verify_afioballs_from_tape(struct s_bkpinfo *);
int verify_biggiefiles_from_tape(struct s_bkpinfo *);
int verify_tape_backups(struct s_bkpinfo *);
char *vfy_tball_fname(struct s_bkpinfo *, char*,int);




/*---------------------------------------------------------------------*/






long generate_list_of_changed_files(char*changedfiles_fname, char*ignorefiles_fname, char*stderr_fname)
{
  char command[MAX_STR_LEN], afio_found_changes[MAX_STR_LEN];
  int res;
  long afio_diffs;
  sprintf(afio_found_changes,"%s.afio",ignorefiles_fname);
  system("sync");
  sprintf(command,"cat %s | grep \"afio: \" | awk '{j=substr($0,8); i=index(j,\": \");printf \"/%%s\\n\",substr(j,1,i-2);}' | sort | uniq | grep -v \"incheckentry xwait\" | grep -vx \"/afio:.*\" > %s",stderr_fname,afio_found_changes);
  log_it(command);
  res=system(command);
  if (res) {log_it("Warning - failed to think");}
  exclude_nonexistent_files(afio_found_changes);
  afio_diffs = count_lines_in_file(afio_found_changes);
  sprintf(command,"cat %s %s %s | sort | uniq -c | awk '{ if ($1==\"2\") {print $2;};}' > %s",ignorefiles_fname, afio_found_changes, afio_found_changes, changedfiles_fname);
log_it(command);
  system(command);
  return(afio_diffs);
}









int g_last_afioball_number=-1;

int verify_afioballs_on_CD(struct s_bkpinfo *bkpinfo, char*mountpoint)
{
  char tmp[MAX_STR_LEN];
  int set_number, retval=0, total_sets, percentage;
  for(set_number=0; set_number < 9999 && !does_file_exist(vfy_tball_fname(bkpinfo,mountpoint,set_number)); set_number++);
  if (!does_file_exist(vfy_tball_fname(bkpinfo,mountpoint,set_number)))
    {
      return(0);
    }
  if (g_last_afioball_number!=set_number-1)
    {
      retval++;
      sprintf(tmp,"Warning - missing set(s) between %d and %d\n",g_last_afioball_number,set_number-1);
      log_to_screen(tmp);
    }
  sprintf(tmp,"Verifying ISO #%d's tarballs",g_current_media_number);
  open_evalcall_form(tmp);
  for(total_sets=set_number; does_file_exist(vfy_tball_fname(bkpinfo,mountpoint,total_sets)); total_sets++);
  for(; does_file_exist(vfy_tball_fname(bkpinfo,mountpoint,set_number));set_number++)
    {
      percentage = (set_number - g_last_afioball_number) * 100 / (total_sets - g_last_afioball_number);
      update_evalcall_form(percentage);
      retval+=verify_an_afioball_from_CD(bkpinfo,vfy_tball_fname(bkpinfo,mountpoint,set_number));
    }
  g_last_afioball_number=set_number-1;
  close_evalcall_form();
  return(retval);
}




long last_bigfile_num=-1, last_slice_num=-1;

int verify_all_slices_on_CD(struct s_bkpinfo *bkpinfo, char*mtpt)
{
  char tmp[MAX_STR_LEN], mountpoint[MAX_STR_LEN];
  long bigfile_num, slice_num=-1;
  sprintf(tmp,"Verifying ISO#%d's big files",g_current_media_number);
  open_evalcall_form(tmp);
  sprintf(mountpoint,"%s/archives",mtpt);
  if (last_bigfile_num==-1)
    {
      bigfile_num=0;
      slice_num=0;
    }
  else if (slice_num==0)
    {
      bigfile_num=last_bigfile_num+1;
      slice_num=0;
    }
  else
    {
      bigfile_num=last_bigfile_num;
      slice_num=last_slice_num+1;
    }
  while(does_file_exist(slice_fname(bigfile_num,slice_num,mountpoint,bkpinfo->zip_suffix)) ||
	does_file_exist(slice_fname(bigfile_num,slice_num,mountpoint,"")))
    {
      if (slice_num==0)
	{
	  sprintf(tmp,"ISO=%d  bigfile=%ld --START--",g_current_media_number,bigfile_num);
	  log_it(tmp);
	  slice_num++;
	}
      else if (does_file_exist(slice_fname(bigfile_num,slice_num,mountpoint,"")))
	{
	  sprintf(tmp,"ISO=%d  bigfile=%ld ---END---",g_current_media_number,bigfile_num);
	  log_it(tmp);
	  bigfile_num++;
	  slice_num=0;
	}
      else
	{
	  sprintf(tmp,"ISO=%d  bigfile=%ld  slice=%ld  \r",g_current_media_number,bigfile_num,slice_num);
	  log_it(tmp);
	  slice_num++;
	}
    }
  last_bigfile_num=bigfile_num;
  last_slice_num=slice_num-1;
  if (last_slice_num < 0) { last_bigfile_num--; }
  close_evalcall_form();
  return(0);
}







int verify_an_afioball(struct s_bkpinfo *bkpinfo, char*tarball_fname)
{
  char /*old_pwd[MAX_STR_LEN], */command[MAX_STR_LEN], outfile[MAX_STR_LEN], tmp[MAX_STR_LEN];
  FILE*pin;
  long diffs=0;
  /*  getcwd(old_pwd,MAX_STR_LEN-1); */
  sprintf(tmp,"Verifying fileset '%s'",tarball_fname);
  log_it(tmp);
  /*  chdir("/"); */
  sprintf(outfile,"%s/afio.log",bkpinfo->tmpdir);
/* if programmer forgot to say which compression thingy to use then find out */
  if (strstr(tarball_fname,".lzo") && strcmp(bkpinfo->zip_suffix,"lzo"))
    {
      log_it("OK, I'm going to start using lzop.");
      strcpy(bkpinfo->zip_exe,"lzop");
      strcpy(bkpinfo->zip_suffix,"lzo");
      bkpinfo->use_lzo=TRUE;
    }
  if (strstr(tarball_fname,".bz2") && strcmp(bkpinfo->zip_suffix,"bz2"))
    {
      log_it("OK, I'm going to start using bzip2.");
      strcpy(bkpinfo->zip_exe,"bzip2");
      strcpy(bkpinfo->zip_suffix,"bz2");
      bkpinfo->use_lzo=FALSE;
    }
  sprintf(command,"afio -r -P %s -Z %s > %s 2> /tmp/mondo-verify.err", bkpinfo->zip_exe, tarball_fname, outfile);
  /*  log_it(command); */
  system(command);
  sprintf(command,"cat %s | cut -d':' -f2 | sort | uniq",outfile);
  pin=popen(command,"r");
  if (pin)
    {
      for(fgets(tmp,MAX_STR_LEN,pin); !feof(pin); fgets(tmp,MAX_STR_LEN,pin))
	{
	  if (!diffs)
	    {
	      sprintf(tmp,"'%s' - differences found",tarball_fname);
	      log_it(tmp);
	    }
	  diffs++;
	  log_it(strip_afio_output_line(tmp));
	}
      pclose(pin);
    }
  /*  chdir(old_pwd); */
  sprintf(tmp,"cat %s >> %s","/tmp/mondo-verify.err",MONDO_LOGFILE);
  system(tmp);
  unlink("/tmp/mondo-verify.err");
  return(0);
}






int verify_an_afioball_from_CD(struct s_bkpinfo*bkpinfo, char*tarball_fname)
{
  char tmp[MAX_STR_LEN];
  int res;

  sprintf(tmp,"Verifying %s",tarball_fname);
  log_it(tmp);
  if (!does_file_exist(tarball_fname)) { fatal_error("Cannot verify nonexistent afioball"); }
  res=verify_an_afioball(bkpinfo,tarball_fname);
  return(res);
}



int verify_an_afioball_from_tape(struct s_bkpinfo*bkpinfo, char*orig_fname, long long size)
{
  int retval=0,res=0;
  char tmp[MAX_STR_LEN], *p, tarball_fname[MAX_STR_LEN];

  p=strrchr(orig_fname,'/');
  if (!p) {p=orig_fname;} else {p++;}
  sprintf(tmp,"mkdir -p %s/tmpfs",bkpinfo->tmpdir);
  system(tmp);
  sprintf(tarball_fname,"%s/tmpfs/temporary-%s",bkpinfo->tmpdir,p);
  sprintf(tmp,"Temporarily copying file from tape to '%s'",tarball_fname);
/*  log_it(tmp); */
  read_file_from_tape_to_file(bkpinfo,tarball_fname,size);
  res=verify_an_afioball(bkpinfo,tarball_fname);
  if (res)
    {
      sprintf(tmp,"Afioball '%s' no longer matches your live filesystem",p);
      log_it(tmp);
      retval++;
    }
  unlink(tarball_fname);
  return(retval);
}



int verify_a_biggiefile_from_tape(struct s_bkpinfo*bkpinfo, char*biggie_fname, long long size)
{
  int retval=0,res=0,current_slice_number=0, ctrl_chr='\0';
  char test_file[MAX_STR_LEN], biggie_cksum[MAX_STR_LEN],
     orig_cksum[MAX_STR_LEN],
     tmp[MAX_STR_LEN], slice_fnam[MAX_STR_LEN], *p;
  long long slice_siz;

  p=strrchr(biggie_fname,'/');
  if (!p) {p=biggie_fname;} else {p++;}
  sprintf(test_file,"%s/temporary-%s",bkpinfo->tmpdir,p);
  sprintf(tmp,"Temporarily copying biggiefile %s's slices from tape to '%s'",p,test_file);
/*  log_it(tmp); */
  for(res=read_header_block_from_tape(&slice_siz, slice_fnam, &ctrl_chr); ctrl_chr!=BLK_STOP_A_BIGGIE; res=read_header_block_from_tape(&slice_siz, slice_fnam, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      res=read_file_from_tape_to_file(bkpinfo,test_file,slice_siz);
      unlink(test_file);
      res=read_header_block_from_tape(&slice_siz, slice_fnam, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE)
        {
	  sprintf(tmp,"test_file = %s",test_file);
	  log_it(tmp);
	  wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr);
        }
      current_slice_number++;
      retval+=res;
    }
  strcpy(biggie_cksum, slice_fnam);
  if (biggie_cksum[0]!='\0')
    {
      strcpy(orig_cksum,calc_checksum_of_file(biggie_fname));
      if (strcmp(biggie_cksum,orig_cksum))
        {
          sprintf(tmp,"orig cksum=%s; curr cksum=%s",biggie_cksum,orig_cksum);
	  log_it(tmp);
	  sprintf(tmp,"%s has changed on live filesystem",biggie_fname);
	  log_to_screen(tmp);
	}
    }
  return(retval);
}




int verify_afioballs_from_tape(struct s_bkpinfo *bkpinfo)
{
  int retval=0,res=0,current_afioball_number=0, ctrl_chr, total_afioballs;
  char tmp[MAX_STR_LEN], fname[MAX_STR_LEN];
  long long size;

  log_to_screen("Verifying regular archives on tape");
  total_afioballs = get_last_filelist_number(bkpinfo)+1;
  open_progress_form("Verifying filesystem","I am verifying archives against your live filesystem now.","Please wait. This may take a couple of hours.","",total_afioballs);
  res=read_header_block_from_tape(&size,fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_AFIOBALLS) { wrong_marker(BLK_START_AFIOBALLS,ctrl_chr); }
  for(res=read_header_block_from_tape(&size, fname, &ctrl_chr); ctrl_chr!=BLK_STOP_AFIOBALLS; res=read_header_block_from_tape(&size, fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      sprintf(tmp,"Verifying fileset #%d", current_afioball_number);
      /*log_it(tmp);*/
      update_progress_form(tmp);
      res=verify_an_afioball_from_tape(bkpinfo,fname,size);
      if (res)
        {
	  sprintf(tmp,"Afioball %d differs from live filesystem",current_afioball_number);
	  log_to_screen(tmp);
	}
      retval+=res;
      current_afioball_number++;
      g_current_progress++;
      res=read_header_block_from_tape(&size, fname, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) { wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr); }
    }
  log_it("All done with afioballs");
  close_progress_form();
  return(retval);
}





int verify_biggiefiles_from_tape(struct s_bkpinfo *bkpinfo)
{
  int retval=0,res=0, ctrl_chr;
  long noof_biggiefiles, current_biggiefile_number=0;
  char tmp[MAX_STR_LEN], fname[MAX_STR_LEN], *p, comment[MAX_STR_LEN];
  long long size;

  sprintf(comment,"Verifying all bigfiles.");
  log_to_screen(comment);
  sprintf(tmp,"%s/biggielist.txt",bkpinfo->tmpdir);
  noof_biggiefiles=count_lines_in_file(tmp);
  open_progress_form("Verifying big files",comment,"Please wait. This may take some time.","",noof_biggiefiles);
  res=read_header_block_from_tape(&size, fname, &ctrl_chr);
  if (ctrl_chr != BLK_START_BIGGIEFILES) { wrong_marker(BLK_START_BIGGIEFILES,ctrl_chr); }
  for(res=read_header_block_from_tape(&size, fname, &ctrl_chr); ctrl_chr!=BLK_STOP_BIGGIEFILES; res=read_header_block_from_tape(&size, fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_A_BIGGIE) { wrong_marker(BLK_START_A_BIGGIE,ctrl_chr); }
      p=strrchr(fname,'/');
      if (!p) {p=fname;} else {p++;}
      sprintf(comment,"Verifying biggiefile #%ld (%ld K)", current_biggiefile_number, (long) size>>10);
      update_progress_form(comment);
      res=verify_a_biggiefile_from_tape(bkpinfo,fname,size);
      retval+=res;
      current_biggiefile_number++;
      g_current_progress++;
    }
  close_progress_form();
  return(retval);
}



int verify_cd_image(struct s_bkpinfo *bkpinfo)
{
  int retval=0;
  char mountpoint[MAX_STR_LEN], command[MAX_STR_LEN],
     tmp[MAX_STR_LEN], fname[MAX_STR_LEN];
  sprintf(mountpoint,"%s/cdrom",bkpinfo->tmpdir);
  sprintf(fname,"%s/%s/%d.iso",bkpinfo->isodir,bkpinfo->nfs_remote_dir,g_current_media_number);

  mkdir(mountpoint,1777);
  sync();
  if (!does_file_exist(fname))
    {
      sprintf(tmp,"%s not found; assuming you backed up to CD; verifying CD...", fname);
      log_it(tmp);
      if (find_and_mount_actual_cd(bkpinfo,mountpoint))
	{
	  log_to_screen("failed to mount actual CD");
	  return(1);
	}
    }
  else
    {
      sprintf(tmp,"%s found; verifying ISO...", fname);
      sprintf(command,"mount -o loop,ro -t iso9660 %s %s",fname,mountpoint);
      if (system(command))
	{
	  sprintf(tmp,"%s failed; unable to mount ISO image\n",command);
	  log_to_screen(tmp);
	  return(1);
	}
    }
  log_it("OK, I've mounted the ISO/CD\n");
  sprintf(tmp,"%s/archives/NOT-THE-LAST", mountpoint);
  if (!does_file_exist(tmp))
    {
      log_it("This is the last CD. I am therefore setting bkpinfo->verify_data to FALSE.");
      bkpinfo->verify_data = FALSE;
/*
   (a) It's an easy way to tell the calling subroutine that we've finished &
   there are no more CD's to be verified; (b) It stops the post-backup verifier
   from running after the per-CD verifier has run too.
*/
    }
  verify_afioballs_on_CD(bkpinfo,mountpoint);  
  verify_all_slices_on_CD(bkpinfo,mountpoint);
  sprintf(command,"umount %s",mountpoint);
  if (system(command))
    {
      sprintf(tmp,"%s failed; unable to unmount ISO image\n",command);
      log_to_screen(tmp);
      retval++;
    }
  else
    {
     log_it("OK, I've unmounted the ISO file\n");
    }
  if (!does_file_exist(fname))
    {
      sprintf(tmp,"eject %s",bkpinfo->media_device);
      if (system(tmp)) { log_it("Failed to eject CD-ROM drive"); }
    }
  return(retval);
}




int verify_tape_backups(struct s_bkpinfo *bkpinfo)
{
  int retval=0;
  char tmp[MAX_STR_LEN];
  long diffs;

  log_it("verify_tape_backups --- starting");
  log_to_screen("Verifying backups");
  openin_tape(bkpinfo);
/* verify archives themselves */
  retval+=verify_afioballs_from_tape(bkpinfo);
  retval+=verify_biggiefiles_from_tape(bkpinfo);
/* find the final blocks */
  closein_tape(bkpinfo);
/* close tape; exit */
  pclose(g_tape_stream);
  sprintf(tmp,"cat %s | grep \"afio: \" | cut -d'\"' -f2 | sort -u | awk '{print \"/\"$0;};' | tr -s '/' '/' | grep -vx \"/afio:.*\" > /tmp/changed.files", MONDO_LOGFILE);
  log_it("Running command to derive list of changed files");
  log_it(tmp);
  if (system(tmp)) { log_it("Warning - unable to check logfile to derive list of changed files"); }
  diffs=count_lines_in_file("/tmp/changed.files");
  if (diffs>0)
    {
      sprintf(tmp,"%ld files differed from live filesystem; type 'less /tmp/changed.files' to see",diffs);
      log_to_screen(tmp);
      retval++;
    }
  return(retval);
}





char *vfy_tball_fname(struct s_bkpinfo*bkpinfo, char*mountpoint,int setno)
{
  static char output[MAX_STR_LEN];
  sprintf(output,"%s/archives/%d.afio.%s",mountpoint,setno,bkpinfo->zip_suffix);
  return(output);
}











