//
//  testrenameseqscommand.cpp
//  Mothur
//
//  Created by Sarah Westcott on 9/29/15.
//  Copyright (c) 2015 Schloss Lab. All rights reserved.
//

#include "catch.hpp"
#include "testrenameseqscommand.h"

TEST_CASE("Testing Rename.seqs Command") {
    TestRenameSeqsCommand tRename;
    MothurOut* m = MothurOut::getInstance();
    
    //setup environment
    tRename.fastaFile = m->testDirectory + "final.fasta";
    tRename.nameFile = m->testDirectory + "final.names";
    tRename.groupfile = m->testDirectory + "final.groups";
    //tRename.countfile = m->testDirectory + "final.count_table";
    //tRename.qualfile = m->testDirectory + "final.qual";
    //tRename.contigsfile = m->testDirectory + "final.contigs";
    //tRename.fileFile = m->testDirectory + "final.file";
    //tRename.mapFile = m->testDirectory + "final.map";
    
    
    SECTION("Test execute") {
        INFO("Using fasta, name and group files") // Only appears on a FAIL
        tRename.fastaFile = m->testDirectory + "final.fasta";
        tRename.nameFile = m->testDirectory + "final.names";
        tRename.groupfile = m->testDirectory + "final.groups";
        CAPTURE(tRename.execute()); // Displays this variable on a FAIL
        
        CHECK(m->getNumErrors() == 0);
    }
    
    //add more tests...
    
}
