/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@GwtCompatible
public class MultimapPutIterableTester<K, V>
extends AbstractMultimapTester<K, V> {
    private static final Object[] EMPTY = new Object[0];

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyOnPresentKey() {
        this.multimap().putAll(this.sampleKeys().e0, new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.sampleValues().e3, MultimapPutIterableTester.this.sampleValues().e4}).iterator();
            }
        });
        this.assertGet(this.sampleKeys().e0, this.sampleValues().e0, this.sampleValues().e3, this.sampleValues().e4);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyOnAbsentKey() {
        this.multimap().putAll(this.sampleKeys().e3, new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.sampleValues().e3, MultimapPutIterableTester.this.sampleValues().e4}).iterator();
            }
        });
        this.assertGet(this.sampleKeys().e3, this.sampleValues().e3, this.sampleValues().e4);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnAbsentKey() {
        List iterable = Collections.emptyList();
        this.multimap().putAll(this.sampleKeys().e3, iterable);
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnPresentKey() {
        this.multimap().putAll(this.sampleKeys().e0, Collections.emptyList());
        this.expectUnchanged();
    }
}

