/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ToolBarStatus;

public class ActionZoomIn
implements ActionListener {
    private ToolBarStatus toolbar;
    private ModelTime model;
    private int zoomlevel;

    public ActionZoomIn(ToolBarStatus toolBarStatus, ModelTime modelTime) {
        this.toolbar = toolBarStatus;
        this.model = modelTime;
        this.zoomlevel = 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.zoomlevel = this.model.getZoomLevel();
        if (this.zoomlevel >= 30) {
            Window window = SwingUtilities.windowForComponent((JToolBar)((Object)this.toolbar));
            String string = "The Current ZoomLevel(" + this.zoomlevel + ") exceeds " + "the Maximum ZoomLevel(" + 30 + ")!";
            Dialogs.error(window, string);
        } else {
            this.model.zoomIn();
        }
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
        if (Debug.isActive()) {
            Debug.println("Action for Zoom In button. ZoomLevel = " + this.zoomlevel);
        }
    }
}

