// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS_ExclusionFilter_HeaderFile
#define _AIS_ExclusionFilter_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_AIS_ExclusionFilter.hxx>

#include <Standard_Boolean.hxx>
#include <TColStd_DataMapOfIntegerListOfInteger.hxx>
#include <SelectMgr_Filter.hxx>
#include <AIS_KindOfInteractive.hxx>
#include <Standard_Integer.hxx>
#include <Handle_SelectMgr_EntityOwner.hxx>
class SelectMgr_EntityOwner;
class TColStd_ListOfInteger;


//! A framework to reject or to accept only objects of
//! given types and/or signatures.
//! Objects are stored, and the stored objects - along
//! with the flag settings - are used to define the filter.
//! Objects to be filtered are compared with the stored
//! objects added to the filter, and are accepted or
//! rejected according to the exclusion flag setting.
//! -   Exclusion flag on
//! -   the function IsOk answers true for all objects,
//! except those of the types and signatures stored
//! in the filter framework
//! -   Exclusion flag off
//! -   the funciton IsOk answers true for all objects
//! which have the same type and signature as the stored ones.
class AIS_ExclusionFilter : public SelectMgr_Filter
{

public:

  
  //! Constructs an empty exclusion filter object defined by
  //! the flag setting ExclusionFlagOn.
  //! By default, the flag is set to true.
  Standard_EXPORT AIS_ExclusionFilter(const Standard_Boolean ExclusionFlagOn = Standard_True);
  
  //! All the AIS objects of <TypeToExclude>
  //! Will be rejected by the IsOk Method.
  Standard_EXPORT AIS_ExclusionFilter(const AIS_KindOfInteractive TypeToExclude, const Standard_Boolean ExclusionFlagOn = Standard_True);
  
  //! Constructs an exclusion filter object defined by the
  //! enumeration value TypeToExclude, the signature
  //! SignatureInType, and the flag setting ExclusionFlagOn.
  //! By default, the flag is set to true.
  Standard_EXPORT AIS_ExclusionFilter(const AIS_KindOfInteractive TypeToExclude, const Standard_Integer SignatureInType, const Standard_Boolean ExclusionFlagOn = Standard_True);
  
  Standard_EXPORT virtual   Standard_Boolean IsOk (const Handle(SelectMgr_EntityOwner)& anObj)  const;
  
  //! Adds the type TypeToExclude to the list of types.
  Standard_EXPORT   Standard_Boolean Add (const AIS_KindOfInteractive TypeToExclude) ;
  
  Standard_EXPORT   Standard_Boolean Add (const AIS_KindOfInteractive TypeToExclude, const Standard_Integer SignatureInType) ;
  
  Standard_EXPORT   Standard_Boolean Remove (const AIS_KindOfInteractive TypeToExclude) ;
  
  Standard_EXPORT   Standard_Boolean Remove (const AIS_KindOfInteractive TypeToExclude, const Standard_Integer SignatureInType) ;
  
  Standard_EXPORT   void Clear() ;
  
      Standard_Boolean IsExclusionFlagOn()  const;
  
      void SetExclusionFlag (const Standard_Boolean Status) ;
  
  Standard_EXPORT   Standard_Boolean IsStored (const AIS_KindOfInteractive aType)  const;
  
  Standard_EXPORT   void ListOfStoredTypes (TColStd_ListOfInteger& TheList)  const;
  
  Standard_EXPORT   void ListOfSignature (const AIS_KindOfInteractive aType, TColStd_ListOfInteger& TheStoredList)  const;




  DEFINE_STANDARD_RTTI(AIS_ExclusionFilter)

protected:




private: 

  
  Standard_EXPORT   Standard_Boolean IsSignatureIn (const AIS_KindOfInteractive aType, const Standard_Integer aSignature)  const;

  Standard_Boolean myIsExclusionFlagOn;
  TColStd_DataMapOfIntegerListOfInteger myStoredTypes;


};


#include <AIS_ExclusionFilter.lxx>





#endif // _AIS_ExclusionFilter_HeaderFile
