// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_ShapeTolerance_HeaderFile
#define _ShapeFix_ShapeTolerance_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopoDS_Shape;


//! Modifies tolerances of sub-shapes (vertices, edges, faces) <br>
class ShapeFix_ShapeTolerance  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   ShapeFix_ShapeTolerance();
  //! Limits tolerances in a shape as follows : <br>
//!          tmin = tmax -> as SetTolerance (forces) <br>
//!          tmin = 0   -> maximum tolerance will be <tmax> <br>
//!          tmax = 0 or not given (more generally, tmax < tmin) -> <br>
//!             <tmax> ignored, minimum will be <tmin> <br>
//!          else, maximum will be <max> and minimum will be <min> <br>
//!          styp = VERTEX : only vertices are set <br>
//!          styp = EDGE   : only edges are set <br>
//!          styp = FACE   : only faces are set <br>
//!          styp = WIRE   : to have edges and their vertices set <br>
//!          styp = other value : all (vertices,edges,faces) are set <br>
//!          Returns True if at least one tolerance of the sub-shape has <br>
//!          been modified <br>
  Standard_EXPORT     Standard_Boolean LimitTolerance(const TopoDS_Shape& shape,const Standard_Real tmin,const Standard_Real tmax = 0.0,const TopAbs_ShapeEnum styp = TopAbs_SHAPE) const;
  //! Sets (enforces) tolerances in a shape to the given value <br>
//!          styp = VERTEX : only vertices are set <br>
//!          styp = EDGE   : only edges are set <br>
//!          styp = FACE   : only faces are set <br>
//!          styp = WIRE   : to have edges and their vertices set <br>
//!          styp = other value : all (vertices,edges,faces) are set <br>
  Standard_EXPORT     void SetTolerance(const TopoDS_Shape& shape,const Standard_Real preci,const TopAbs_ShapeEnum styp = TopAbs_SHAPE) const;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
