// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDocStd_Document_HeaderFile
#define _TDocStd_Document_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_TDocStd_Document_HeaderFile
#include <Handle_TDocStd_Document.hxx>
#endif

#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _Handle_TDF_Data_HeaderFile
#include <Handle_TDF_Data.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TDF_Transaction_HeaderFile
#include <TDF_Transaction.hxx>
#endif
#ifndef _TDF_DeltaList_HeaderFile
#include <TDF_DeltaList.hxx>
#endif
#ifndef _Handle_TDF_Delta_HeaderFile
#include <Handle_TDF_Delta.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _CDM_Document_HeaderFile
#include <CDM_Document.hxx>
#endif
#ifndef _Handle_CDM_Document_HeaderFile
#include <Handle_CDM_Document.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Handle_TDocStd_CompoundDelta_HeaderFile
#include <Handle_TDocStd_CompoundDelta.hxx>
#endif
class TDF_Data;
class TDF_Delta;
class TDF_Label;
class TCollection_ExtendedString;
class TDF_LabelMap;
class TDF_DeltaList;
class TCollection_AsciiString;
class CDM_Document;
class TDocStd_CompoundDelta;


//! The contents of a TDocStd_Application, a <br>
//! document is a container for a data framework <br>
//! composed of labels and attributes. As such, <br>
//! TDocStd_Document is the entry point into the data framework. <br>
//! To gain access to the data, you create a document as follows: <br>
//! Handle(TDocStd_Document) MyDF = new TDocStd_Document <br>
//! The document also allows you to manage: <br>
//! -   modifications, providing Undo and Redo functions. <br>
//! -   command transactions. <br>
//!  Warning: The only data saved is the framework (TDF_Data) <br>
class TDocStd_Document : public CDM_Document {

public:

  //! Will Abort any execution, and commit the Undo transaction <br>//! returns the    document which contains <L>.  raises  an <br>
//!          exception if the document is not found. <br>
  Standard_EXPORT   static  Handle_TDocStd_Document Get(const TDF_Label& L) ;
  //! Constructs a document object defined by the <br>
//! string astorageformat. <br>
  Standard_EXPORT   TDocStd_Document(const TCollection_ExtendedString& astorageformat);
  //! the document is saved in a file. <br>
  Standard_EXPORT     Standard_Boolean IsSaved() const;
  //! returns True if document differs from the state of last saving. <br>
//!          this method have to be called only wroking in the transaction mode <br>
        Standard_Boolean IsChanged() const;
  //! This method have to be called to show document that it has been saved <br>
        void SetSaved() ;
  //! Say to document what it is not saved. <br>
//!          Use value, returned earlier by GetSavedTime(). <br>
        void SetSavedTime(const Standard_Integer theTime) ;
  //! Returns value of <mySavedTime> to be used later in SetSavedTime() <br>
        Standard_Integer GetSavedTime() const;
  //! raise if <me> is not saved. <br>
  Standard_EXPORT     TCollection_ExtendedString GetName() const;
  //! returns the OS  path of the  file, in wich one <me> is <br>
//!          saved. Raise an exception if <me> is not saved. <br>
  Standard_EXPORT     TCollection_ExtendedString GetPath() const;
  
  Standard_EXPORT     void SetData(const Handle(TDF_Data)& data) ;
  
  Standard_EXPORT     Handle_TDF_Data GetData() const;
  //! Returns the main label in this data framework. <br>
//! By definition, this is the label with the entry 0:1. <br>
  Standard_EXPORT     TDF_Label Main() const;
  //! Returns True if the main label has no attributes <br>
  Standard_EXPORT     Standard_Boolean IsEmpty() const;
  //!  Returns False if the  document has been modified <br>
//! but not recomputed. <br>
  Standard_EXPORT     Standard_Boolean IsValid() const;
  //! Notify the label as modified, the Document becomes UnValid. <br>//! returns True if <L> has been notified as modified. <br>
  Standard_EXPORT     void SetModified(const TDF_Label& L) ;
  //! Remove all modifications. After this call The document <br>
//!          becomesagain Valid. <br>
  Standard_EXPORT     void PurgeModified() ;
  //! Returns the labels which have been modified in <br>
//! this document. <br>
  Standard_EXPORT    const TDF_LabelMap& GetModified() const;
  //! Launches a new command. This command may be undone. <br>
  Standard_EXPORT     void NewCommand() ;
  //! returns True if a Command transaction is open in the curret . <br>
  Standard_EXPORT     Standard_Boolean HasOpenCommand() const;
  //! Opens a new command transaction in this document. <br>
//! You can use HasOpenCommand to see whether a command is already open. <br>
//! Exceptions <br>
//! Standard_DomainError if a command is already open in this document. <br>
  Standard_EXPORT     void OpenCommand() ;
  //! Commits documents transactions and fills the <br>
//! transaction manager with documents that have <br>
//! been changed during the transaction. <br>
//! If no command transaction is open, nothing is done. <br>
//! Returns True if a new delta has been added to myUndos. <br>
  Standard_EXPORT     Standard_Boolean CommitCommand() ;
  //! Abort the  Command  transaction. Does nothing If there is <br>
//!          no Command transaction open. <br>
  Standard_EXPORT     void AbortCommand() ;
  //! The current limit on the number of undos <br>
  Standard_EXPORT     Standard_Integer GetUndoLimit() const;
  //! Set the  limit on  the number of  Undo Delta  stored 0 <br>
//!          will disable  Undo  on the  document A negative  value <br>
//!          means no limit. Note that by default Undo is disabled. <br>
//!          Enabling  it will  take effect with  the next  call to <br>
//!          NewCommand. Of course this limit is the same for Redo <br>
  Standard_EXPORT     void SetUndoLimit(const Standard_Integer L) ;
  //! Remove all stored Undos and Redos <br>
  Standard_EXPORT     void ClearUndos() ;
  //! Remove all stored Redos <br>
  Standard_EXPORT     void ClearRedos() ;
  //! Returns the number of undos stored in this <br>
//! document. If this figure is greater than 0, the method Undo <br>
//! can be used. <br>
  Standard_EXPORT     Standard_Integer GetAvailableUndos() const;
  //! Will UNDO  one step, returns  False if no undo was <br>
//!          done (Undos == 0). <br>
//! Otherwise, true is returned and one step in the <br>
//! list of undoes is undone. <br>
  Standard_EXPORT     Standard_Boolean Undo() ;
  //! Returns the number of redos stored in this <br>
//! document. If this figure is greater than 0, the method Redo <br>
//!  can be used. <br>
  Standard_EXPORT     Standard_Integer GetAvailableRedos() const;
  //! Will REDO  one step, returns  False if no redo was <br>
//!          done (Redos == 0). <br>
//! Otherwise, true is returned, and one step in the list of redoes is done again. <br>
  Standard_EXPORT     Standard_Boolean Redo() ;
  
  Standard_EXPORT    const TDF_DeltaList& GetUndos() const;
  
  Standard_EXPORT    const TDF_DeltaList& GetRedos() const;
  //! Removes the first undo in the list of document undos. <br>
//!          It is used in the application when the undo limit is exceed. <br>
  Standard_EXPORT     void RemoveFirstUndo() ;
  //! Initializes the procedure of delta compaction <br>
//!          Returns false if there is no delta to compact <br>
//!          Marks the last delta as a "from" delta <br>
  Standard_EXPORT     Standard_Boolean InitDeltaCompaction() ;
  //! Performs the procedure of delta compaction <br>
//!          Makes all deltas starting from "from" delta <br>
//!          till the last one to be one delta. <br>
  Standard_EXPORT     Standard_Boolean PerformDeltaCompaction() ;
  //! Set   modifications on  labels  impacted  by  external <br>
//!          references to the entry.  The document becomes invalid <br>
//!          and must be recomputed. <br>
  Standard_EXPORT     void UpdateReferences(const TCollection_AsciiString& aDocEntry) ;
  //! Recompute if the document was  not valid and propagate <br>
//!          the reccorded modification. <br>
  Standard_EXPORT     void Recompute() ;
  //! This method Update   will be called <br>
//!          to signal the end   of the modified references list. <br>
//!          The    document     should    be  recomputed     and <br>
//!          UpdateFromDocuments  should be called.  Update should <br>
//!          returns True in case  of success, false otherwise.  In <br>
//!          case of Failure, additional information can be given in <br>
//!          ErrorString. <br>//! Update the document by propagation <br>
//!          ================================== <br>//!   Update   the    document    from   internal   stored <br>
//!            modifications.   If   you   want  to   undoing  this <br>
//!           operation, please call NewCommand before. <br>//! to change format (advanced programming) <br>
//!          ================ <br>
  Standard_EXPORT   virtual  void Update(const Handle(CDM_Document)& aToDocument,const Standard_Integer aReferenceIdentifier,const Standard_Address aModifContext) ;
  
  Standard_EXPORT   virtual  TCollection_ExtendedString StorageFormat() const;
  //! methods for the nested transaction mode <br>
  Standard_EXPORT   virtual  void ChangeStorageFormat(const TCollection_ExtendedString& newStorageFormat) ;
  //! Sets nested transaction mode if isAllowed == Standard_True <br>
  Standard_EXPORT     void SetNestedTransactionMode(const Standard_Boolean isAllowed = Standard_True) ;
  //! Returns Standard_True if mode is set <br>
        Standard_Boolean IsNestedTransactionMode() const;
  //! if theTransactionOnly is True changes is denied outside transactions <br>
        void SetModificationMode(const Standard_Boolean theTransactionOnly) ;
  //! returns True if changes allowed only inside transactions <br>
        Standard_Boolean ModificationMode() const;




  DEFINE_STANDARD_RTTI(TDocStd_Document)

protected:

  //! Returns Standard_True done <br>
  Standard_EXPORT   virtual  Standard_Boolean CommitTransaction() ;
  
  Standard_EXPORT   virtual  void AbortTransaction() ;
  //! methods for protection of changes outside transactions <br>
  Standard_EXPORT   virtual  void OpenTransaction() ;

TCollection_ExtendedString myStorageFormat;
TDF_DeltaList myUndos;
TDF_DeltaList myRedos;


private: 

  //! Appends delta to the first delta in the myUndoFILO <br>//! private methods <br>
//!          =============== <br>
  Standard_EXPORT   static  void AppendDeltaToTheFirst(const Handle(TDocStd_CompoundDelta)& theDelta1,const Handle(TDF_Delta)& theDelta2) ;

Handle_TDF_Data myData;
Standard_Integer myUndoLimit;
TDF_Transaction myUndoTransaction;
Handle_TDF_Delta myFromUndo;
Handle_TDF_Delta myFromRedo;
Standard_Integer mySaveTime;
Standard_Boolean myIsNestedTransactionMode;
TDF_DeltaList myUndoFILO;
Standard_Boolean myOnlyTransactionModification;


};


#include <TDocStd_Document.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
