## Copyright (C) 2012,2013 Philip Nienhuis <prnienhuis@users.sf.net>
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.

## __OXS_spsh_close__ - internal function: close a spreadsheet file using JXL

## Author: Philip Nienhuis <prnienhuis@users.sf.net>
## Created: 2012-10-12
## Updates:
## 2012-10-24 Style fixes
## 2013-01-20 Adapted to ML-compatible Java calls
## 2013-12-06 Updated copyright string
## 2013-12-28 Style fixes
##     ''     Moved wb close statement down to always unlock file
## 2014-05-11 Silence when saving new file

function [ xls ] = __OXS_spsh_close__ (xls)

    if (xls.changed > 0 && xls.changed < 3)
      if (isfield (xls, "nfilename"))
        fname = xls.nfilename;
      else
        fname = xls.filename;
      endif
      try
##      if (xls.changed == 2)
##        printf ("Saving file %s...\n", fname);
##      endif
        xlsout = javaObject ("java.io.FileOutputStream", fname);
        xls.workbook.write (xlsout);
        xlsout.close ();
        xls.changed = 0;
      catch
        warning ("__OXS_spsh_close__: error trying to close OXS file ptr");
      end_try_catch
    endif
    xls.workbook.close ();

endfunction
