/**********************************************************************
 *
 *    FILE:            Shader.cpp
 *
 *    DESCRIPTION:    Read/Write osg::Shader in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 20.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Shader.h"
#include "Object.h"

using namespace ive;

void Shader::write(DataOutputStream* out){
    // Write Shader's identification.
    out->writeInt(IVESHADER);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj)
    {
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("Shader::write(): Could not cast this osg::Shader to an osg::Object.");

     if ( out->getVersion() < VERSION_0012 )
     {
        out->writeString(getName());
     }
     out->writeInt(getType());
     out->writeString(getShaderSource());

}

void Shader::read(DataInputStream* in)
{
    // Read Shader's identification.
    int id = in->peekInt();
    if(id == IVESHADER)
    {
        // Read Shader's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj)
        {
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("Shader::read(): Could not cast this osg::Shader to an osg::Object.");

    }
    else
    {
        in_THROW_EXCEPTION("Shader::read(): Expected Shader identification.");
    }

    if ( in->getVersion() < VERSION_0012 )
    {
        setName(in->readString());
    }
    
    setType(static_cast<Type>(in->readInt()));
    setShaderSource(in->readString());

}
