//                                               -*- C++ -*-
/**
 *  @file  QuadraticTaylor.hxx
 *  @brief Second order polynomial response surface by Taylor expansion
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: QuadraticTaylor.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_QUADRATICTAYLOR_HXX
#define OPENTURNS_QUADRATICTAYLOR_HXX

#include "OTprivate.hxx"
#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"
#include "SymmetricTensor.hxx"
#include "NumericalMathFunction.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class QuadraticTaylor
 *
 * The class describes the concept of quadratic taylor response surface
 */
class QuadraticTaylor
  : public PersistentObject
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit QuadraticTaylor(const String & name = DefaultName);

  /** Constructor with parameters */
  explicit QuadraticTaylor(const NumericalPoint & center,
                           const NumericalMathFunction & inputFunction,
                           const String & name = DefaultName);


  /** Virtual constructor */
  virtual QuadraticTaylor * clone() const;

  /** String converter */
  String __repr__() const;

  /** Response surface computation */
  void run();

  /** Center accessor */
  NumericalPoint getCenter() const;

  /** Constant accessor */
  NumericalPoint getConstant() const;

  /** Linear accessor */
  Matrix getLinear() const;

  /** Quadratic accessor */
  SymmetricTensor getQuadratic() const;

  /** Input function accessor */
  NumericalMathFunction getInputFunction() const;

  /** Response surface accessor */
  NumericalMathFunction getResponseSurface() const;

protected:

private:

  NumericalPoint center_;
  NumericalMathFunction inputFunction_;
  NumericalMathFunction responseSurface_;
  NumericalPoint constant_;
  Matrix linear_;
  SymmetricTensor quadratic_;

}; /* class QuadraticTaylor */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_QUADRATICTAYLOR_HXX */
