//                                               -*- C++ -*-
/**
 *  @file  Hanning.hxx
 *  @brief This class is enables to build an exponential covariance
 *  model, a second order model's implementation
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-26 21:14:59 +0200 (Mon, 26 Mar 2012) $
 *  Id:      $Id: Hanning.hxx 2434 2012-03-26 19:14:59Z lebrun $
 */
#ifndef OPENTURNS_HANNINGFILTER_HXX
#define OPENTURNS_HANNINGFILTER_HXX

#include "PersistentObject.hxx"
#include "FilteringWindowsImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class Hanning
 */

class Hanning
  : public FilteringWindowsImplementation
{

  CLASSNAME;

public:


  /** Default constructor without parameters */
  Hanning(const String & name = DefaultName);

  /** Virtual copy constructor */
  Hanning * clone() const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

  /** Evaluation method  */
  NumericalScalar operator()(const NumericalScalar t) const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

} ; /* class Hanning */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_HANNINGFILTER_HXX */
