//                                               -*- C++ -*-
/**
 *  @file  UserDefinedFactory.hxx
 *  @brief Factory for UserDefined distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: UserDefinedFactory.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_USERDEFINEDFACTORY_HXX
#define OPENTURNS_USERDEFINEDFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "UserDefined.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class UserDefinedFactory
 */
class UserDefinedFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  UserDefinedFactory();

  /** Virtual constructor */
  virtual UserDefinedFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  virtual UserDefined * build(const NumericalSample & sample) const;
  virtual UserDefined * build() const;


}; /* class UserDefinedFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_USERDEFINEDFACTORY_HXX */
