//                                               -*- C++ -*-
/**
 *  @file  t_RegularGrid_std.cxx
 *  @brief The test file of class RegularGrid
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_RegularGrid_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "TimeSeries.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {


    /*Using deltaT constructor */
    NumericalScalar start(-2.0);
    NumericalScalar step(0.1);
    UnsignedLong n(10);
    RegularGrid regularGrid(start, step, n);
    fullprint << "regularGrid = " << regularGrid << std::endl;

    fullprint << "Start= " << regularGrid.getStart() << std::endl;
    fullprint << "End= " << regularGrid.getEnd() << std::endl;
    fullprint << "Step = " << regularGrid.getStep() << std::endl;
    fullprint << "N = " << regularGrid.getN() << std::endl;

    /* Test save / load */
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("regularGrid", regularGrid);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    RegularGrid newRegularGrid;
    myStudy2.fillObject("regularGrid", newRegularGrid);
    fullprint << "loaded RegularGrid =" << newRegularGrid << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
