///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/**
 * \file ScriptPlugin.h
 * \brief Contains the definition of the Scripting::ScriptPlugin class.
 */

#ifndef __OVITO_SCRIPT_PLUGIN_H
#define __OVITO_SCRIPT_PLUGIN_H

#include <scripting/Scripting.h>
#include <core/plugins/Plugin.h>
#include "ScriptPluginClassDescriptor.h"

namespace Scripting {

/**
 * \brief A plugin that is implemented as a Python script.
 *
 * \author Alexander Stukowski
 */
class SCRIPTING_DLLEXPORT ScriptPlugin : public Plugin
{
	Q_OBJECT

public:

protected:

	/// \brief Constructor that loads the given manifest file.
	/// \param manifestFile Full path to the plugin's manifest file.
	/// \throw Exception on parsing error.
	ScriptPlugin(const QString& manifestFile);

	/// \brief Parses a custom toplevel element from the manifest that is specific to the plugin type.
	/// \return \c true if the element was processed by the method; \c false if the element was not known
	///         to the implementation of the method.
	/// \throw Exception on error.
	virtual bool parseToplevelManifestElement(const QDomElement& element);

	/// \brief Loads the plugin into memory.
	/// \throw Exception on error.
	virtual void loadPluginImpl();

	/// \brief Allocates a new plugin type specific PluginClassDescriptor instance.
	/// \throw Exception on error.
	virtual PluginClassDescriptor* createClassDescriptor(const QString& name, PluginClassDescriptor* baseClass, Plugin* plugin, const QDomElement& classNode, bool isAbstract, bool serializable) {
		return new ScriptPluginClassDescriptor(name, baseClass, plugin, classNode, isAbstract, serializable);
	}
};

};	// End of namespace

#endif // __OVITO_SCRIPT_PLUGIN_H
