#include "rfcomm.h"
#include <bt_sock.h>
#include <btmanclient.h>	// Security
#include <btsdp.h>		// Service Advertizing
#include <f32file.h>

const TInt KServiceClass = 0x1101;

extern void debugline(const char *a, ...);

static void
SetSecurityOnChannelL(TBool aAuthentication, TBool aEncryption, 
	TBool aAuthorisation, TInt aChannel)
{ 
  // a connection to the security manager
  RBTMan secManager;

  // a security session
  RBTSecuritySettings secSettingsSession;

  // define the security on this port
  secManager.Connect();
  secSettingsSession.Open(secManager);

  // the security settings 
  TBTServiceSecurity serviceSecurity(TUid::Uid(0x101F7058), KSolBtRFCOMM, 0);

  //Define security requirements
  serviceSecurity.SetAuthentication(aAuthentication);    
  serviceSecurity.SetEncryption(aEncryption); 
  serviceSecurity.SetAuthorisation(aAuthorisation);

  serviceSecurity.SetChannelID(aChannel);
  TRequestStatus status;
  secSettingsSession.RegisterService(serviceSecurity, status);
  
  User::WaitForRequest(status); // wait until the security settings are set
}
    

RfComm::~RfComm()
{
  listen.Close();
  sock.Close();
  socketServ.Close();
}

int
RfComm::Open(CConsoleBase *cons, TDes &name, TDesC &destination,
			TRequestStatus &st)
{
  int r;

  socketServ.Connect();
  if((r = listen.Open(socketServ, _L("RFCOMM"))) != KErrNone)
    return r;

  int aPort;
  TLex parse(destination);
  parse.Val(aPort);

  TBTSockAddr addr;
  addr.SetPort(aPort);
  if((r = listen.Bind(addr)) != KErrNone)
    {
      // Perhaps the port is busy. Try it again with a free port
      listen.GetOpt(KRFCOMMGetAvailableServerChannel, KSolBtRFCOMM, aPort);
      addr.SetPort(aPort);
      if((r = listen.Bind(addr)) != KErrNone)
	return r;
    }

  listen.Listen(1);
  if((r = sock.Open(socketServ)) != KErrNone)
    return r;

  listen.Accept(sock, st);
  SetSecurityOnChannelL(EFalse, EFalse, ETrue, aPort);

  TBTDevAddrPckg dap;
  TRequestStatus status;
  listen.Ioctl(KHCILocalAddressIoctl, status, &dap, KSolBtHCI);
  User::WaitForRequest(status);
  TBuf<256> a;
  dap().GetReadable(a);

  cons->Printf(_L("Addr %c%c:%c%c:%c%c:%c%c:%c%c:%c%c Port %d\n"),
	a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],aPort);

  return KErrNone;
}


void
RfComm::Read(TRequestStatus &aStatus, TDes8 &aDes)
{
  sock.Read(aDes, aStatus);
}

void
RfComm::ReadOneOrMore(TRequestStatus &aStatus,TDes8 &aDes)
{
  sock.RecvOneOrMore(aDes, 0, aStatus, iRLen);
}

void
RfComm::Write(TRequestStatus &aStatus, const TDesC8 &aDes)
{
  sock.Write(aDes, aStatus);
}

void
RfComm::Cancel()
{
  sock.CancelAll();
}
