#ifndef COLOUR_EDITOR_H
#define COLOUR_EDITOR_H

#include <gtk/gtk.h>

class ColourEditor {
  typedef void (*CEChangeCallback)(ColourEditor *, void *);

  friend gboolean colour_editor_expose(GtkWidget * widget, GdkEvent * event,
                                       gpointer data);
  friend gboolean colour_editor_clicked(GtkWidget * widget, gpointer data);
  friend gboolean colour_editor_ok_clicked(GtkButton * button, gpointer data);
  friend gboolean colour_editor_cancel_clicked(GtkButton * button,
                                               gpointer data);
  friend gboolean colour_editor_wm_close(GtkWidget * widget, GdkEvent * event,
                                         gpointer data);
  friend void colour_editor_destroy(gpointer colour_editor);

  public:

    ColourEditor(gushort r, gushort g, gushort b);
    ColourEditor(gushort r, gushort g, gushort b, CEChangeCallback, gpointer);
    ~ColourEditor();
    GtkWidget * getPreview();
    gushort getRed();
    gushort getGreen();
    gushort getBlue();
    void setRGB(gushort, gushort, gushort);
    void setSensitive(bool);
    bool isSensitive();

  private:

    GdkColor * colour;
    GtkWidget * preview;
    GtkWidget * editor;
    GtkWidget * wrapper;
    CEChangeCallback change_callback;
    gpointer callback_data;
    bool sensitive;

    void init(gushort red, gushort green, gushort blue);
    void createEditorDialog();
    void setChangeCallback(CEChangeCallback);
    CEChangeCallback getChangeCallback();
};

#endif
