#include <string.h>
#include <stdlib.h>

#include "Entity.h"

static int last_id = 0;

Entity::Entity() {
  name = strdup("");
  description = strdup("");

  setType(EntityNone);
  disabled = false;
  id = last_id++;
  widget = NULL;
  save_entity = true;

  xml = NULL;
  description_buffer = NULL;
}

Entity::~Entity() {
  if (name) {
    free(name);
    name = NULL;
  }
  if (description) {
    free(description);
    description = NULL;
  }

}

void Entity::setName(char * n) {

  if (name)
    free(name);

  name = strdup(n);
}

char * Entity::getName() {
  return name;
}

void Entity::setDescription(char * n) {
  if (description)
    free(description);
  description = strdup(n);
}

char * Entity::getDescription() {
  return description;
}

EntityType Entity::getType() {
  return type;
}

void Entity::setType(EntityType t) {
  type = t;
}

void Entity::setDisabled(bool t) {
  disabled = t;
}

bool Entity::findExecute(EntityType t, char * field, char * value, void * data, bool multiple) {
  return false;
}

void Entity::save(FILE * fp) {
  if (!save_entity)
    return;

  fprintf(fp, "Entity %s\n", getName());
  fprintf(fp, "Description\n");
  fprintf(fp, "%s", getDescription());
  if (getDescription()[strlen(getDescription()) - 1] != '\n')
    fprintf(fp, "\n");
  fprintf(fp, "EndDescription\n");
  fprintf(fp, "EndEntity\n");
}

char * Entity::loadBlock(FILE * fp, char * terminator) {
  static char buf[16384];
  int pos = 0;

  while (true) {
    if (!fgets(buf + pos, 16384, fp)) {
      perror("fgets");
      return NULL;
    }

    if (!strncasecmp(buf + pos, terminator, strlen(terminator))) {
      *(buf + pos) = '\0';
      return buf;
    }
      
    pos += strlen(buf + pos);
  }
}

GtkWidget * Entity::getWidgets() {

  if (widget)
    return widget;

  GtkWidget * label = gtk_label_new(_("This Entity doesn't have an editing interface yet."));
  gtk_widget_show(label);

  widget = label;
  return widget;
}

int Entity::getID() {
  return id;
}

void Entity::apply() {
}

void Entity::destroyWidgets() {
  if (widget) {
    gtk_widget_destroy(widget);
    widget = NULL;
  }
}

void Entity::setSave(bool t) {
  save_entity = t;
}
