#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>

#ifdef MIDI
#include <libkmid/libkmid.h>
#endif

#ifndef WIN32
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <signal.h>
#else
#include <windows.h>
#endif

#include "papaya/system.h"
#include "mudclient.h"

#include "interface.h"
#include "support.h"

#include "Socket.h"

#include "Connection.h"
#include "Prefs.h"
#include "Message.h"

#include "callbacks.h"

#include "PluginHandler.h"
#include "EntityHandler.h"
#include "MUD.h"
#include "BaseWindow.h"

extern PluginHandler * phandler;
extern BaseWindow * mainWindow;
extern EntityHandler * entities;

int papaya_startup(int argc, char * argv[]);
int papaya_shutdown();

#ifdef MALLOC
extern "C" void dmalloc_shutdown(void);
#endif

#ifdef _WINDOWS
int __stdcall WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
  int argc = 1;
  char ** argv;
  argv = (char **)malloc(sizeof(char *) * 2);
  argv[0] = strdup("papaya");
  argv[1] = NULL;
#else
int main (int argc, char *argv[]) {
#endif


  papaya_startup(argc, argv);
  papaya_shutdown();

#ifdef MALLOC
  dmalloc_shutdown();
#endif

#ifdef WIN32
  return 1;
#endif
}


int read_socket_timeout(gpointer data) {
  char * buffer = (char *) malloc(32768);
  Connection * conn = (Connection *)data;
  int res = 0;
  buffer[0] = '\0';
  bool scroll = false;
  bool smooth_scrolling = conn->queryPreferences()->getPreferenceBoolean("SmoothScrolling");

  // If the connection has vanished, don't try to read from it, assume it's
  // completely gone, and return 0 so that we don't get more callbacks on it.

  if (!conn) {
    printf ("Connection missing!\n");
    free(buffer);
    return 0;
  }

  bool pre_insert_run = false;

//  conn->getVT()->preInsert();

  while (1) {

    res = conn->isConnected();
    // Connection failed
    if (res == -1) {
      // Can delete 'conn' here as the connection will have no data in
      // if it is closed at this point.
      printf ("Connection failed getting called.\n");
      conn->failed(0);
      delete conn;
      free(buffer);
      return 0;
    }

    // Not yet connected, but trying.
    if (res == 0) {
      free(buffer);
      return 1;
    }

    // Trying to read when there isn't a Socket for the connection.
    // Assume fatal error on connection.
    if (!conn->getSocket()) {
      // 'conn' has probably already been freed.
      free(buffer);
      return 0;
    }

    // We deliberately read quite a lot smaller than buffer.  Plugins may
    // need to enlarge the buffer.
    res = conn->getSocket()->readLine(16000, buffer);

    // Socket closed for some reason.
    // Close the connection.
    if (res == -1) {
      conn->closed();
      free(buffer);
      return 0;
    }

    if (res == 0) {
      // No more data.  Check if we need to scroll down.
      if (scroll) {
	    conn->getVT()->scroll();
	    scroll = false;
      }
      break;
    }

    phandler->processOutputFilters(conn, buffer);

    entities->findExecute(EntitySystemTrigger, "text", buffer, (void *)conn, true);
    entities->findExecute(EntityTrigger, "text", buffer, (void *)conn, true);
    
    if (strlen(buffer) > 0) {

		if (pre_insert_run == false) {
			pre_insert_run = true;
			conn->getVT()->preInsert();
		}
		
		conn->getVT()->append(buffer);
/*		if (smooth_scrolling)
		  conn->getVT()->scroll(); */
      scroll = true;
    }

    buffer[0] = '\0';
  }
  
  free(buffer);
  return 1;
}

int initialise_network_mud(MUD * mud) {

  // Connection automatically takes care of adding the VT100 object.
  Connection * c = new Connection(mud);
  mainWindow->addConnection(c);

  if (c->connect() == -1) {
    char buf[1024];
    
    c->failed(errno);
    /*
    if (errno == 0)
      sprintf(buf, _("Connection failed to %s port %d: not a HTTP server."), mud->getHostname(), mud->getPort());
    else
      sprintf(buf, _("Connection failed to %s port %d: %s."), mud->getHostname(), mud->getPort(), strerror(errno));

    // @@ If this dialog is modal the stuff after it doesn't get run!
    new Message(_("Error"), buf, false);
    */
    // delete c will do this.
    //    mainWindow->removeConnection(c);

    delete c;
    return 0;
  }

  c->getVT()->use();
  c->getVT()->focus();
  return 1;
}

int initialise_network(char * host, int port) {
  // Create a MUD object to be copied by the Connection object.
  MUD * m = new MUD();

  m->incrRefCount(false);

  m->setHostname(host);
  m->setPort(port);
  m->setName(host);

  // Call the new connection with mud method.
  initialise_network_mud(m);
  return 1;
}

int usage_callback(GtkButton * button, gpointer user_data, gint i) {
#if defined(linux)
  char buf[1024];
  char line[1024];
  int memory = 0;
  sprintf(buf, "/proc/%d/status", getpid());

  FILE * proc = fopen(buf, "r");
  if (!proc)
    return 0;
  while (fgets(line, 1024, proc)) {
    int spare;
    if (sscanf(line, "VmSize:%d kB", &spare) == 1) {
      memory = spare;
    }
  }
  fclose(proc);

  printf(_("Memory usage: %d kB."), memory);
  printf(CRLF);

#else
#ifndef WIN32
  struct rusage use;
  char buf[1024];

  // Get this process's usage stats
  if (getrusage(RUSAGE_SELF, &use) == -1) {
    perror("getrusage");
    return 0;
  }
  
  sprintf(buf, "MEMORY\n======\n"
	       "SHM   : %ld\n"
	       "Data  : %ld\n"
	       "Stack : %ld\n"
               "CPU\n===\n"
	       "User  : %ld\n"
	       "System: %ld\n",
	  use.ru_ixrss, use.ru_idrss, use.ru_isrss,
	  use.ru_utime.tv_usec, use.ru_stime.tv_usec);

  printf("%s", buf);
#endif // !WIN32
#endif // LINUX
  return 1;
}

