/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright 2008 SciberQuest Inc.

*/
#ifndef __pqSQBOVMetaReader_h
#define __pqSQBOVMetaReader_h

#include "pqAutoGeneratedObjectPanel.h"

#include "CartesianExtent.h"

class QSpinBox;
class QLineEdit;

class pqSQBOVMetaReader : public pqAutoGeneratedObjectPanel
{
Q_OBJECT
public:
  pqSQBOVMetaReader(pqProxy *proxy, QWidget *parent);
  ~pqSQBOVMetaReader();

protected slots:
  void UpdateDecompDims();
  void UpdateBlockSize();
  void UpdateBlockCacheSize();
  void UpdateNoBlocksCached();
  void UpdateNoBlocksCachedValidator();

private:
  QString FormatMemoryUsage(unsigned long int n);
  unsigned long int GetLargeBlockSize();
  unsigned long int GetNoBlocks();

private:
  QSpinBox *SubsetUI[6];
  QLineEdit *DecompDims[3];
  QLineEdit *BlockSize;
  QLineEdit *NoBlocksToCache;
  QLineEdit *BlockCacheSize;
  CartesianExtent Subset;
};

#endif
