/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.time;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.renderer.common.nodes.BaseTimeControlledNode;

public class BaseTimeSensor
extends BaseTimeControlledNode
implements VRMLTimeListener,
VRMLSensorNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{53};
    protected static final int FIELD_CYCLE_INTERVAL = 7;
    protected static final int FIELD_FRACTION = 8;
    protected static final int FIELD_TIME = 9;
    protected static final int FIELD_CYCLE_TIME = 10;
    protected static final int FIELD_IS_ACTIVE = 11;
    protected static final int FIELD_IS_PAUSED = 12;
    protected static final int FIELD_ENABLED = 13;
    protected static final int LAST_TIME_SENSOR_INDEX = 13;
    protected static final int NUM_FIELDS = 14;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected double vfCycleTime;
    protected double vfCycleInterval;
    protected float vfFraction;
    protected double vfTime;
    protected boolean vfIsActive;
    protected boolean vfIsPaused;
    protected boolean vfEnabled;
    private long currentCycle;
    private boolean loopForever;
    private long internalStopTime;
    private long internalStartTime;
    private long internalPauseTime;
    private long internalResumeTime;
    private long internalCycleInterval;
    private long pausedTime;
    private long totalPausedTime;
    private double nextStart;
    private double nextStop;
    private boolean justStarted;

    public BaseTimeSensor() {
        super("TimeSensor");
        this.hasChanged = new boolean[14];
        this.vfTime = -1.0;
        this.vfCycleTime = 0.0;
        this.vfPauseTime = 0.0;
        this.vfResumeTime = 0.0;
        this.vfCycleInterval = 1.0;
        this.vfIsActive = false;
        this.vfIsPaused = false;
        this.vfEnabled = true;
        this.vfLoop = false;
        this.internalCycleInterval = 1000L;
        this.currentCycle = -1L;
        this.justStarted = true;
        this.nextStart = -1.0;
        this.nextStop = -1.0;
    }

    public BaseTimeSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLTimeControlledNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("cycleInterval");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCycleInterval = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("pauseTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPauseTime = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("resumeTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfResumeTime = vRMLFieldData.doubleValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        boolean bl = this.loopForever = this.vfLoop && this.vfStopTime <= this.vfStartTime;
        if (this.loopForever) {
            this.nextStart = -1.0;
            this.nextStop = -1.0;
        }
        if (this.nextStop > 0.0) {
            if (this.nextStop < this.vfTime) {
                this.nextStop = this.vfTime;
            }
            this.vfStopTime = this.nextStop;
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
            this.internalStartTime = (long)(this.vfStartTime * 1000.0);
            this.totalPausedTime = 0L;
            this.recalcStopTime();
            this.nextStop = -1.0;
        }
        if (this.nextStart > 0.0) {
            this.vfStartTime = this.nextStart;
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
            this.internalStartTime = (long)(this.vfStartTime * 1000.0);
            this.totalPausedTime = 0L;
            this.recalcStopTime();
            if (!this.inSetup && this.vfEnabled) {
                this.vrmlClock.addTimeListener(this);
            }
            this.nextStart = -1.0;
            this.vfFraction = 0.0f;
        }
        long l = this.vrmlClock.getWallTime();
        this.justStarted = false;
    }

    public double getCycleTime() {
        return this.vfCycleTime;
    }

    public double getCycleInterval() {
        return this.vfCycleInterval;
    }

    public void setCycleInterval(double d) throws InvalidFieldValueException {
        if (this.vfIsActive) {
            return;
        }
        if (d <= 0.0) {
            throw new InvalidFieldValueException("cycleInterval is <= 0");
        }
        if (d != this.vfCycleInterval) {
            this.vfCycleInterval = d;
            if (!this.inSetup) {
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
            }
            this.internalCycleInterval = (long)(this.vfCycleInterval * 1000.0);
            this.loopForever = this.vfLoop && this.vfStopTime <= this.vfStartTime;
            this.recalcStopTime();
        }
    }

    public float getFraction() {
        return this.vfFraction;
    }

    public double getTime() {
        return this.vfTime;
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        if (this.vrmlClock != null) {
            this.vrmlClock.removeTimeListener(this);
        }
        this.vrmlClock = vRMLClock;
        if (this.vrmlClock == null) {
            return;
        }
        this.vfTime = this.vrmlClock.getTime();
        if (!this.inSetup && this.vfEnabled && (this.loopForever || this.vfTime > this.vfStopTime)) {
            this.vrmlClock.addTimeListener(this);
        }
        if (this.nextStart > -1.0 || this.nextStop > -1.0) {
            this.stateManager.addEndOfThisFrameListener(this);
        }
    }

    public void setLoop(boolean bl) {
        if (bl != this.vfLoop) {
            this.vfLoop = bl;
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
            boolean bl2 = this.loopForever = this.vfLoop && this.vfStopTime <= this.vfStartTime;
            if (this.vfEnabled) {
                this.internalStopTime = this.internalStartTime + this.internalCycleInterval;
            } else {
                this.recalcStopTime();
            }
        }
    }

    public void setStartTime(double d) {
        super.setStartTime(d);
        this.nextStart = d;
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
        }
    }

    public void setPauseTime(double d) {
        this.internalPauseTime = (long)(d * 1000.0);
        this.vfPauseTime = d;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    public void setResumeTime(double d) {
        this.internalResumeTime = (long)(d * 1000.0);
        this.vfResumeTime = d;
        this.hasChanged[5] = true;
        this.fireFieldChanged(5);
    }

    public void setStopTime(double d) {
        super.setStopTime(d);
        if (this.vfIsActive && d < this.vfStartTime) {
            return;
        }
        this.nextStop = d;
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.vfEnabled != bl) {
            this.vfEnabled = bl;
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
            if (!this.vfEnabled) {
                this.vfIsActive = false;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
            }
            if (this.vrmlClock != null) {
                if (this.vfEnabled) {
                    this.vrmlClock.addTimeListener(this);
                } else {
                    this.vrmlClock.removeTimeListener(this);
                }
            }
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        boolean bl = this.loopForever = this.vfLoop && this.vfStopTime <= this.vfStartTime;
        if (this.loopForever) {
            this.nextStart = -1.0;
            this.nextStop = -1.0;
        }
        this.internalCycleInterval = (long)(this.vfCycleInterval * 1000.0);
        this.recalcStopTime();
        this.justStarted = true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 13) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 42;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsPaused;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfLoop;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfFraction;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfCycleTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfCycleInterval;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfStartTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfStopTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfPauseTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfResumeTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfLoop);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfFraction);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfCycleTime);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfCycleInterval);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfStartTime);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfStopTime);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfPauseTime);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfResumeTime);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfElapsedTime);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfTime);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfIsPaused);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTimeSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setCycleInterval(d);
                break;
            }
            case 4: {
                this.setPauseTime(d);
                break;
            }
            case 5: {
                this.setResumeTime(d);
                break;
            }
            case 10: {
                throw new InvalidFieldValueException("cycleTime is an outputOnly field");
            }
            case 9: {
                throw new InvalidFieldValueException("time is an outputOnly field");
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                throw new InvalidFieldValueException("Cannot set eventout");
            }
            case 13: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void timeClick(long l) {
        if (!this.vfEnabled) {
            return;
        }
        double d = (double)l * 0.001;
        double d2 = 0.0;
        if (!this.vfIsPaused && l >= this.internalPauseTime && this.internalPauseTime > this.internalResumeTime) {
            this.pausedTime = l;
            this.vfIsPaused = true;
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
        if (this.vfIsPaused && l >= this.internalResumeTime && this.internalResumeTime > this.internalPauseTime) {
            this.totalPausedTime += l - this.pausedTime;
            this.vfIsPaused = false;
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
        if (this.vfIsPaused) {
            return;
        }
        if (l >= this.internalStartTime && l <= this.internalStopTime || this.loopForever) {
            d2 = (float)(l - this.internalStartTime - this.totalPausedTime) / (float)this.internalCycleInterval;
            if (!this.vfIsActive) {
                if (this.loopForever && this.vfStartTime >= this.vfStopTime) {
                    this.internalStartTime = l;
                }
                this.vfIsActive = true;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                this.vfCycleTime = d;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                d2 = (float)(l - this.internalStartTime - this.totalPausedTime) / (float)this.internalCycleInterval;
                this.currentCycle = (long)Math.floor(d2);
                double d3 = d2 % 1.0;
                this.vfFraction = d3 == 0.0 ? 1.0f : (float)d3;
                this.hasChanged[8] = true;
                this.vfIsPaused = false;
                this.pausedTime = 0L;
            } else {
                double d4 = d2 % 1.0;
                float f = this.vfFraction = d4 == 0.0 ? 1.0f : (float)d4;
            }
            if (Math.floor(d2) != (double)this.currentCycle) {
                this.currentCycle = (long)Math.floor(d2);
                this.vfCycleTime = d;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                if (this.vfLoop) {
                    this.recalcStopTime();
                } else {
                    this.internalStopTime = 0L;
                    this.vfIsActive = false;
                    this.hasChanged[11] = true;
                    this.fireFieldChanged(11);
                }
                this.vfFraction = 1.0f;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
            } else {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
            }
            if (this.vfTime != d) {
                this.vfTime = d;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                this.vfElapsedTime = l - this.internalStartTime - this.totalPausedTime;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
            }
        } else if (this.vfIsActive) {
            this.vfIsActive = false;
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
            this.vfTime = (double)this.internalStopTime * 0.001;
            d2 = (float)(this.internalStopTime - this.internalStartTime - this.totalPausedTime) / (float)this.internalCycleInterval;
            double d5 = d2 % 1.0;
            if (d5 > 0.99) {
                d5 = 1.0;
            }
            this.vfFraction = d5 == 0.0 ? 1.0f : (float)d5;
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
            this.vfElapsedTime = l - this.internalStartTime - this.totalPausedTime;
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
            this.vrmlClock.removeTimeListener(this);
        }
    }

    private void recalcStopTime() {
        this.internalStopTime = this.vfStopTime <= this.vfStartTime ? this.internalStartTime + this.internalCycleInterval : (long)(this.vfStopTime * 1000.0);
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[14];
        fieldMap = new HashMap(42);
        BaseTimeSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTimeSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "loop");
        BaseTimeSensor.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFTime", "startTime");
        BaseTimeSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFTime", "stopTime");
        BaseTimeSensor.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFTime", "pauseTime");
        BaseTimeSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFTime", "elapsedTime");
        BaseTimeSensor.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFTime", "resumeTime");
        BaseTimeSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFTime", "time");
        BaseTimeSensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFTime", "cycleTime");
        BaseTimeSensor.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFTime", "cycleInterval");
        BaseTimeSensor.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseTimeSensor.fieldDecl[12] = new VRMLFieldDeclaration(4, "SFBool", "isPaused");
        BaseTimeSensor.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseTimeSensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFFloat", "fraction_changed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("loop", n);
        fieldMap.put("set_loop", n);
        fieldMap.put("loop_changed", n);
        n = new Integer(2);
        fieldMap.put("startTime", n);
        fieldMap.put("set_startTime", n);
        fieldMap.put("startTime_changed", n);
        n = new Integer(3);
        fieldMap.put("stopTime", n);
        fieldMap.put("set_stopTime", n);
        fieldMap.put("stopTime_changed", n);
        n = new Integer(4);
        fieldMap.put("pauseTime", n);
        fieldMap.put("set_pauseTime", n);
        fieldMap.put("pauseTime_changed", n);
        n = new Integer(5);
        fieldMap.put("resumeTime", n);
        fieldMap.put("set_resumeTime", n);
        fieldMap.put("resumeTime_changed", n);
        n = new Integer(7);
        fieldMap.put("cycleInterval", n);
        fieldMap.put("set_cycleInterval", n);
        fieldMap.put("cycleInterval_changed", n);
        n = new Integer(13);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("time", new Integer(9));
        fieldMap.put("cycleTime", new Integer(10));
        fieldMap.put("isActive", new Integer(11));
        fieldMap.put("isPaused", new Integer(12));
        fieldMap.put("fraction_changed", new Integer(8));
        fieldMap.put("elapsedTime", new Integer(6));
    }
}

