/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     filesel.c                                                      *
 *            functions concerning fileselection list widget                 *
 * Author:    Andreas Tille                                                  *
 * Date:      10.09.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include "paul.h"
#include "callback.h"
#include "names.h"

int           UPDATE_IMAGE            = 0;  /* Update in any case if set other than 0           *
                                             * This flag is set, if a new imagelist was created */

static int    PressedRow              = -1;

static void _FileListUpdateActivImage(PAUL *p)
/* do all necessary things to update activ image
 */
{
  static     GList *LastDisplayed = NULL;
  GtkWidget *nbwindow;
  GtkWidget *notebook;
   
  g_return_if_fail ( IS_PAUL(p) );
  if ( !p->activ ) return;  /* if the filelist is cleared completely there is nothing to do */
  g_return_if_fail ( p->show ) ;
  g_return_if_fail ( GTK_IS_WINDOW(p->show) ) ;
  
  if ( LastDisplayed == p->activ && !UPDATE_IMAGE ) return;
  LastDisplayed = p->activ;
  UPDATE_IMAGE  = 0;
  
  ApplyPicture(p->show->window, BILD(LastDisplayed = p->activ));
  if ( !Info(p->opt->f) ) return;
  
  g_return_if_fail ( GTK_IS_SCROLLED_WINDOW(p->w) );
  if ( !(nbwindow = gtk_object_get_user_data(GTK_OBJECT(p->w))) ) {
    FileInfo(p);
    return;
  }
  g_return_if_fail ( GTK_IS_WINDOW(nbwindow) );
  g_return_if_fail ( (notebook = gtk_object_get_user_data(GTK_OBJECT(nbwindow))) );
  g_return_if_fail ( GTK_IS_NOTEBOOK(notebook) );
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), GetListPosition(p->piclist, p->activ));
}

int FileListButtonPressed(GtkWidget *clist, GdkEventButton *event, PAUL *p)
/* enable list item selection for *all* mouse buttons which was disabled
 * since GTK+1.1.2
 * --- Parameter: ---
 * GtkWidget      *clist : filelist
 * GdkEventButton *event : button_press_event
 */
{
  int col;

   
  g_return_val_if_fail ( GTK_IS_CLIST(clist), -1 );
  g_return_val_if_fail ( IS_PAUL(p), -1 );
  g_return_val_if_fail ( event, -1 );
  g_return_val_if_fail ( event->type == GDK_BUTTON_PRESS || event->type == GDK_2BUTTON_PRESS || 
                     event->type == GDK_3BUTTON_PRESS, -1 );
  
  gtk_clist_get_selection_info(GTK_CLIST(clist), (int)event->x, (int)event->y, &PressedRow, &col );  

  if ( event->state & GDK_CONTROL_MASK )  {
    GList     *pl = g_list_nth(p->piclist, PressedRow);
    PICTURE   *new_op = BILD(pl);
    GtkWidget *list;

    /* check if operation image is insensitive.  If so do nothing!! */
    if ( p->opi && GTK_IS_WINDOW(p->opi) ) {
      list = gtk_object_get_user_data(GTK_OBJECT(p->opi));
      if ( GTK_IS_LIST(list) && ( GTK_WIDGET_SENSITIVE(list) == FALSE) ) {
        g_warning(_("Unable to select new %s while it is in use."), operating);
        return 0;
      }
    }

    if ( p->activ == pl ) p->activ = NULL;
    PressedRow = -1;
    if ( p->op ) OperationToList((gpointer *)p, NULL);
    pl = RemoveImageFromFilelist(p, pl);
    /* set new activ image and select this */
    if ( !(p->activ) && (p->activ = pl) ) SelectAndShowActiv(p);
    p->op = new_op;
    CreateOperationImageWindow(p);
    ButtonSensitive(p);
    return 0;
  }

  if ( event->button == 1 ) return 0;
  
  if ( event->button == 2 ) {
    GList   *pl;
    PICTURE *bild;
    int      i;
     
    for ( bild = BILD(pl = p->piclist), i = 0; pl && bild; bild = BILD(pl = pl->next), i++ ) 
      MarkFilename(p->filelist, i, bild->mark |= SEL);

    if ( (pl = (GList *)gtk_clist_get_row_data(GTK_CLIST(p->filelist), PressedRow)) ) 
      p->activ = pl;
    _FileListUpdateActivImage(p);
    ButtonSensitive(p);
    return 0;
  }

  if ( event->button == 3 ) {
    PICTURE *bild;
     
    bild = BILD((GList *)gtk_clist_get_row_data(GTK_CLIST(p->filelist), PressedRow));
    if ( bild->mark & SEL ) 
      MarkFilename(p->filelist, PressedRow, bild->mark &= ~SEL);
    else
      MarkFilename(p->filelist, PressedRow, bild->mark |= SEL);
    
    gtk_clist_select_row(GTK_CLIST(clist), PressedRow, 0);
    return 0;
  }
  return -1;
}

void FileListSelectChild(GtkWidget *list, gint row, gint col, GdkEventButton *event, PAUL *p)
/* do all necessary stuff if a file was selected
 * --- Parameter: ---
 * GtkWidget      *list  : file selection list (p->filelist)
 * gint            row   : selected row
 * gint            col   : selected column (should be 0 in any case)
 * GtkEventButton *event : button_press_event (?)
 * PAUL           *p     : PAUL structure with images
 */
{
  g_return_if_fail ( list );
  g_return_if_fail ( GTK_IS_CLIST(list) );
  g_return_if_fail ( IS_PAUL(p) );
  g_return_if_fail ( col <= 0 );
  if ( event ) g_return_if_fail ( event->type = GDK_BUTTON_RELEASE ) ;
  /* If clist_select_row is triggered then there is no event !! */

  if ( !GTK_CLIST(p->filelist)->rows ) return ;
  
  if ( ANIMATION_SPEED != SINGLE ) {
    g_warning(_("Please avoid selecting images while animation is runnig."));
    return;
  }

  if ( p->activ ) BILD(p->activ)->mark &= ~TMPSEL;
  p->activ  = (GList *)gtk_clist_get_row_data(GTK_CLIST(p->filelist), row);
  if ( p->activ && CheckPicList(p->activ) ) BILD(p->activ)->mark |=  TMPSEL;
  /* It is inteded to check p->activ != NULL first to avoid strange warnings for *
   * the case of no activ picture available (hope, that this case will be vaild  *
   * in the future, but now it is in this actual situation)                      */
  
  if ( UPDATE_IMAGE || PressedRow == -1 || PressedRow == ACT_ROW(p) ) {
    _FileListUpdateActivImage(p);
    PressedRow = -1;
    UPDATE_IMAGE = 0;
  }
  ButtonSensitive(p);
}

void MarkFilename(GtkWidget *clist, int row, char mark)
{
  static GtkStyle *normal = NULL, *selected = NULL;

  g_return_if_fail( clist );
  g_return_if_fail( GTK_IS_CLIST(clist) );
  g_return_if_fail( row >= 0 );
   
  if ( !normal ) {
    GdkColor sel;

    sel.red   = 0;
    sel.green = 56000;
    sel.blue  = 56000;

    normal   = gtk_style_copy(GTK_WIDGET(clist)->style);
    selected = gtk_style_copy(GTK_WIDGET(clist)->style);
    selected->base[GTK_STATE_NORMAL] = sel;
  }

  if ( mark & SEL ) gtk_clist_set_row_style (GTK_CLIST(clist), row, selected);
  else              gtk_clist_set_row_style (GTK_CLIST(clist), row, normal);
}

