/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     gtkuseful.c                                                    *
 *            Useful things for user interactivity more or less independend  *
 *            from paul                                                      *
 * Author:    Andreas Tille                                                  *
 * Date:      23.09.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <ctype.h>
#include <stdlib.h>
#include "paul.h"
 
void AreYouSure(void *data, GtkSignalFunc func, char *question)
/* If the user is sure in dead the function will be executed
 */
{
  static GtkWidget *window = NULL;  /* static is extremely important here!!! */
  GtkWidget *text, *box, *button, *hbox;

  if ( !gtk_main_level() ) {
    int c;
     
    printf(_("%s (Y/N)"), question); 
    fflush(stdout);
    while ( (c = getchar()) != EOF ) {
      if ( toupper(c) == 'N' ) return;
      if ( toupper(c) == 'Y' || toupper(c) == 'J' ) {
        func(NULL, data);
        return;
      }
    }
  }

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
  gtk_window_set_title(GTK_WINDOW(window), _("Are you sure?"));

  box = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(box), 10);
  gtk_container_add(GTK_CONTAINER(window), box);

  text = gtk_label_new(question);
  gtk_box_pack_start(GTK_BOX(box), text, TRUE, TRUE, 0);

  hbox = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 10);
  gtk_box_pack_start(GTK_BOX(box), hbox, TRUE, TRUE, 0);
   
  button = gtk_button_new_with_label(_("Yes"));
  gtk_signal_connect(GTK_OBJECT(button), "clicked", func, data);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), 
                            GTK_OBJECT(window));
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(button);

  button = gtk_button_new_with_label(_("No"));
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), 
                            GTK_OBJECT(window));
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

  gtk_widget_show_all(window);
}

GtkWidget *CreateOkButton(GtkWidget *window, GtkWidget *box, void *userdata, 
                          GtkSignalFunc f1, void *d1, GtkSignalFunc f2, void *d2)
/* OK button with data to connect and two functions to call
 * --- Parameter: ---
 * GtkWidget     *window   : parent window
 * GtkWidget     *box      : box to draw button in
 * void          *userdata : data to connect with button or NULL
 * GtkSignalFunc  f1       : function to call first when clicked
 * void          *d1       : data for f1 call
 * GtkSignalFunc  f2       : second function to call when clicked (in most cases NULL)
 * void          *d2       : data for f2 or NULL
 * --- Return: ---
 * GtkWidget     *CreateOkButton() : button widget or NULL if fail
 */
{
  GtkWidget *button;

  if ( !GTK_IS_WINDOW(window) ) return NULL;
  if ( !GTK_IS_BOX(box) )       return NULL;
   
  button = gtk_button_new_with_label(_("OK"));
  if ( userdata ) gtk_object_set_user_data(GTK_OBJECT(button), userdata);
  if ( f1 ) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(f1), d1);
  if ( f2 ) gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(f2), d2);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(window));
  gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 5);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  return button;
}
			 
GtkWidget *CreateCancelButton(GtkWidget *window, GtkWidget *box)
/* Cancel button with data to connect and two functions to call
 * --- Parameter: ---
 * GtkWidget     *window               : parent window
 * GtkWidget     *box                  : box to draw button in
 * --- Return: ---
 * GtkWidget     *CreateCancelButton() : button widget od NULL if fail
 */
{
  GtkWidget *button;

  if ( !GTK_IS_WINDOW(window) ) return NULL;
  if ( !GTK_IS_BOX(box) )       return NULL;
   
  button = gtk_button_new_with_label(_("Cancel"));
  gtk_signal_connect_object_after(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                  GTK_OBJECT(window));
  /* TRUE, TRUE ensures to allocate the whole space available for the button and is  *
   * necessary for instance to live beneath an OK button                             */
  gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 5);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  return button;
}
			 


