#ifndef INCLUDE_PBBIPC_H
#define INCLUDE_PBBIPC_H
/* ----------------------------------------------------------------------------
 * pbbipc.h
 * definitions for client/server inter process communication.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/types.h>

#include "pbbtaglist.h"

#define CHUNK(a,b,c,d)		((a)<<24 | (b)<<16 | (c)<<8 | (d))

#define SERVERPORTKEY	CHUNK('P', 'B', 'B', 'S')
#define MESSAGETYPE		CHUNK('P', 'B', 'B', 'M')
#define MAXCLIENTS		10
#define MSGMAX			8192      /* from <linux/msg.h>  */

#define LIBMODE_SERVER	1
#define LIBMODE_CLIENT	0

/* action codes */
#define REGISTERCLIENT		1		/* arg = msgport */
#define UNREGISTERCLIENT		2		/* arg = msgport */
#define REGFAILED			3		/* no arg             */
#define CLIENTEXIT			4		/* no arg             */

#define CHANGEVALUE			10		/* arg = taglist */
#define CHANGEERROR			11		/* arg = taglist */
#define WARNING				12		/* arg = taglist */
#define READVALUE			13		/* arg = taglist */

struct pbbmessage {
	long			messagetype;
	int			returnport;
	int			action;
	struct tagitem	taglist[1];
};

/* public prototypes */
int ipc_init (int mode, int reg);
int ipc_exit ();
int ipc_send (int mp, int action, struct tagitem *taglist);
int ipc_receive (void *buffer, size_t bufferlen);

/* client only functions */
int singletag_to_server (int action, tag_t tag, tag_t data);

/* server only functions */
int register_client (int cmsgport);
int unregister_client (int cmsgport);
void singletag_to_clients (int action, tag_t tag, tag_t data);
void distribute_to_clients (int action, struct tagitem *taglist);
int ipc_protect_tag (tag_t tag);
void ipc_filteruser (uid_t uid);
void ipc_filterall ();
void ipc_filterclear ();

/* private prototypes */
int ipc_serverinit ();
int ipc_clientinit (int reg);
int ipc_createport (key_t keyval);
int ipc_findport (key_t keyval);
int ipc_removeport (int mp);
int ipc_putmessage (int mp, struct pbbmessage *msg, size_t len);
int ipc_getmessage (int mp, long type, struct pbbmessage *msg, size_t len);
int ipc_getmessagepart (int mp, long type, struct pbbmessage *msg, size_t len);
uid_t ipc_getportowner (int mp);

/*debug */
void peep_ipc (struct tagitem *taglist);

#endif    /* INCLUDE_PBBIPC_H */
