/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Dialogs
 src/filechoosers.cc
 *******************************************/

#include "filechoosers.hh"

/*** Initalisation of Static Variables ***/
Glib::ustring class_filechoosers::str_current_folder;

/*** Construktor 1 ***/
class_filechoosers::class_filechoosers
(Gtk::Window* pt_parent, 
 Pdfchain::FileChooserType fct){
	 
	 create_filechooser(pt_parent, fct, Pdfchain::FILE_FILTER_NONE, Pdfchain::FILE_FILTER_NONE);
	 return;
 }

/*** Construktor 2 ***/
class_filechoosers::class_filechoosers
(Gtk::Window* pt_parent, 
 Pdfchain::FileChooserType fct,
 Pdfchain::FileFilterType fft1){
	 
	 create_filechooser(pt_parent, fct, fft1, Pdfchain::FILE_FILTER_NONE);
	 return;
 }

/*** Construktor 3 ***/
class_filechoosers::class_filechoosers
(Gtk::Window* pt_parent, 
 Pdfchain::FileChooserType fct,
 Pdfchain::FileFilterType fft1,
 Pdfchain::FileFilterType fft2){
	 
	 create_filechooser(pt_parent, fct, fft1, fft2);
	 return;
 }

/*** Destructor ***/
class_filechoosers::~class_filechoosers(){
	
	delete pt_filechooser;
	delete pt_filefilter1;
	delete pt_filefilter2;
	delete pt_filefilter3;
	delete pt_checkbutton_add_extension;
	delete pt_dialogs;
	
	return;
}



/*** Create Filechooser ***/
void class_filechoosers::create_filechooser
(Gtk::Window* pt_parent,
 Pdfchain::FileChooserType fct,
 Pdfchain::FileFilterType fft1,
 Pdfchain::FileFilterType fft2){
	 
	 // Class Variables Initialisation
	 pt_filechooser               = NULL;
	 pt_filefilter1               = NULL;
	 pt_filefilter2               = NULL;
	 pt_filefilter3               = NULL;
	 pt_checkbutton_add_extension = NULL;
	 
	 // Variables Declaration
	 Glib::ustring str_title;
	 
	 // Create Message Dialogs
	 pt_dialogs = new class_dialogs();
	 
	 // Create Extra Widget
	 pt_checkbutton_add_extension = new Gtk::CheckButton(Text::str_ADD_EXTENSION);
	 pt_checkbutton_add_extension->set_active();
	 
	 // Create FileChooser
	 switch(fct){
		 
		 case Pdfchain::FILE_CHOOSER_OPEN:
			 pt_filechooser = new Gtk::FileChooserDialog("", Gtk::FILE_CHOOSER_ACTION_OPEN);
			 pt_filechooser->set_select_multiple(false);
			 str_title = Text::str_OPEN + ": " + Text::str_PLEASE_CHOOSE_A + " ";
			 break;
			 
		 case Pdfchain::FILE_CHOOSER_OPEN_MULTIPLE:
			 pt_filechooser = new Gtk::FileChooserDialog("", Gtk::FILE_CHOOSER_ACTION_OPEN);
			 pt_filechooser->set_select_multiple(true);
			 str_title = Text::str_OPEN + ": " + Text::str_PLEASE_CHOOSE_SOME + " ";
			 break;
			 
		 case Pdfchain::FILE_CHOOSER_SAVE:
			 pt_filechooser = new Gtk::FileChooserDialog("", Gtk::FILE_CHOOSER_ACTION_SAVE);
			 pt_filechooser->set_select_multiple(false);
			 pt_filechooser->set_extra_widget(*pt_checkbutton_add_extension);
			 str_title = Text::str_SAVE + ": " + Text::str_PLEASE_CHOOSE_A + " ";
			 break;
			 
		 case Pdfchain::FILE_CHOOSER_FOLDER:
			 pt_filechooser = new Gtk::FileChooserDialog("", Gtk::FILE_CHOOSER_ACTION_SELECT_FOLDER);
			 pt_filechooser->set_select_multiple(false);
			 str_title = Text::str_SAVE + ": " + Text::str_PLEASE_CHOOSE_A + " ";
			 break;
			 
		 default:
			 pt_filechooser = NULL;
			 
			 // Error Message
			 pt_dialogs->error_cerr("class_filechoosers::create_filechooser()", Text::err_UNKNOWN_FILE_CHOOSER_TYPE, Text::err_msg_NONE);
			 break;
	 }
	 
	 // Add Widgets to FileChooserDialog
	 if(pt_filechooser != NULL){
		 
		 // Add FileFilter 1
		 switch(fft1){
			 
			 case Pdfchain::FILE_FILTER_PDF:
				 str_title += Text::str_PDF + " ";
				 default_filter = Pdfchain::FILE_FILTER_PDF;
				 pt_filefilter1 = create_filefilter(Pdfchain::FILE_FILTER_PDF);
				 pt_filechooser->add_filter(*pt_filefilter1);
				 break;
				 
			 case Pdfchain::FILE_FILTER_FDF:
				 str_title += Text::str_FDF + " ";
				 default_filter = Pdfchain::FILE_FILTER_FDF;
				 pt_filefilter1 = create_filefilter(Pdfchain::FILE_FILTER_FDF);
				 pt_filechooser->add_filter(*pt_filefilter1);
				 break;
				 
			 case Pdfchain::FILE_FILTER_TXT:
				 str_title += Text::str_TXT + " ";
				 default_filter = Pdfchain::FILE_FILTER_TXT;
				 pt_filefilter1 = create_filefilter(Pdfchain::FILE_FILTER_TXT);
				 pt_filechooser->add_filter(*pt_filefilter1);
				 break;
				 
			 case Pdfchain::FILE_FILTER_DUMP:
				 str_title += Text::str_DUMP + " ";
				 default_filter = Pdfchain::FILE_FILTER_DUMP;
				 pt_filefilter1 = create_filefilter(Pdfchain::FILE_FILTER_DUMP);
				 pt_filechooser->add_filter(*pt_filefilter1);
				 break;
				 
			 case Pdfchain::FILE_FILTER_ANY:
				 str_title += Text::str_ANY + " ";
				 default_filter = Pdfchain::FILE_FILTER_ANY;
				 pt_filefilter1 = create_filefilter(Pdfchain::FILE_FILTER_ANY);
				 pt_filechooser->add_filter(*pt_filefilter1);
				 break;
				 
			 case Pdfchain::FILE_FILTER_NONE:
				 break;
				 
			 default:
				 
				 // Error Message
				 pt_dialogs->error_cerr("class_filechoosers::create_filechooser()", Text::err_UNKNOWN_FILE_FILTER_TYPE, Text::err_msg_NONE);
				 break;
		 }
		 
		 // Add FileFilter 2
		 switch(fft2){
			 
			 case Pdfchain::FILE_FILTER_PDF:
				 pt_filefilter2 = create_filefilter(Pdfchain::FILE_FILTER_PDF);
				 pt_filechooser->add_filter(*pt_filefilter2);
				 break;
				 
			 case Pdfchain::FILE_FILTER_FDF:
				 pt_filefilter2 = create_filefilter(Pdfchain::FILE_FILTER_FDF);
				 pt_filechooser->add_filter(*pt_filefilter2);
				 break;
				 
			 case Pdfchain::FILE_FILTER_TXT:
				 pt_filefilter2 = create_filefilter(Pdfchain::FILE_FILTER_TXT);
				 pt_filechooser->add_filter(*pt_filefilter2);
				 break;
				 
			 case Pdfchain::FILE_FILTER_DUMP:
				 pt_filefilter2 = create_filefilter(Pdfchain::FILE_FILTER_DUMP);
				 pt_filechooser->add_filter(*pt_filefilter2);
				 break;
				 
			 case Pdfchain::FILE_FILTER_ANY:
				 pt_filefilter2 = create_filefilter(Pdfchain::FILE_FILTER_ANY);
				 pt_filechooser->add_filter(*pt_filefilter2);
				 break;
				 
			 case Pdfchain::FILE_FILTER_NONE:
				 break;
				 
			 default:
				 
				 // Error Message
				 pt_dialogs->error_cerr("class_filechoosers::create_filechooser()", Text::err_UNKNOWN_FILE_FILTER_TYPE, Text::err_msg_NONE);
				 break;
		 }
		 
		 // Add FileFilter 2 (default)
		 if((fft1 != Pdfchain::FILE_FILTER_ANY) && (fft2 != Pdfchain::FILE_FILTER_ANY)){
			 
			 pt_filefilter3 = create_filefilter(Pdfchain::FILE_FILTER_ANY);
			 pt_filechooser->add_filter(*pt_filefilter3);
		 }
		 
		 // FileChooserType
		 switch(fct){
			 
			 case Pdfchain::FILE_CHOOSER_OPEN:
				 str_title += Text::str_FILE;
				 break;
				 
			 case Pdfchain::FILE_CHOOSER_OPEN_MULTIPLE:
				 str_title += Text::str_FILES;
				 break;
				 
			 case Pdfchain::FILE_CHOOSER_SAVE:
				 str_title += Text::str_FILE;
				 break;
				 
			 case Pdfchain::FILE_CHOOSER_FOLDER:
				 str_title += Text::str_FOLDER;
				 break;
				 
			 default:
				 str_title += Text::str_FILE;
				 
				 // Error Message
				 pt_dialogs->error_cerr("class_filechoosers::create_filechooser()", Text::err_UNKNOWN_FILE_CHOOSER_TYPE, Text::err_msg_NONE);
				 break;
		 }
		 
		 // Widgets
		 pt_filechooser->add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
		 pt_filechooser->add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
		 
		 // File Chooser Settings
		 pt_filechooser->set_title(str_title);
		 pt_filechooser->set_transient_for(*pt_parent);
		 pt_filechooser->set_current_folder(str_current_folder);
	 }
	 
	 return;
 }

/*** Create FileFilter ***/
Gtk::FileFilter* class_filechoosers::create_filefilter(Pdfchain::FileFilterType fft){
	
	Gtk::FileFilter *pt_filefilter = NULL;
	
	switch(fft){
		
		case Pdfchain::FILE_FILTER_PDF:
			pt_filefilter = new Gtk::FileFilter;
			pt_filefilter->set_name(Text::str_PDF_FILES);
			pt_filefilter->add_mime_type(Extension::mimetype_PDF);
			//pt_filefilter->add_pattern(Extension::pattern_PDF);     // not necesary
			break;
			
		case Pdfchain::FILE_FILTER_FDF:
			pt_filefilter = new Gtk::FileFilter;
			pt_filefilter->set_name(Text::str_FDF_FILES);
			//pt_filefilter->add_mime_type(Extension::mimetype_FDF);  // unknown (is ASCII Text)
			pt_filefilter->add_pattern(Extension::pattern_FDF);
			break;
			
		case Pdfchain::FILE_FILTER_TXT:
			pt_filefilter = new Gtk::FileFilter;
			pt_filefilter->set_name(Text::str_TXT_FILES);
			pt_filefilter->add_mime_type(Extension::mimetype_TXT);
			//pt_filefilter->add_pattern(Extension::pattern_TXT);     // not necesary
			break;
			
		case Pdfchain::FILE_FILTER_DUMP:
			pt_filefilter = new Gtk::FileFilter;
			pt_filefilter->set_name(Text::str_DUMP_FILES);
			//pt_filefilter->add_mime_type(Extension::mimetype_DUMP); // unknown (is ASCII Text)
			pt_filefilter->add_pattern(Extension::pattern_DUMP);
			break;
			
		case Pdfchain::FILE_FILTER_ANY:
			pt_filefilter = new Gtk::FileFilter;
			pt_filefilter->set_name(Text::str_ANY_FILES);
			//pt_filefilter->add_mime_type(Extension::mimetype_ANY);  // unknown
			pt_filefilter->add_pattern(Extension::pattern_ANY);
			break;
			
		case Pdfchain::FILE_FILTER_NONE:
			pt_filefilter = NULL;
			break;
			
		default:
			pt_filefilter = NULL;
			
			// Error Message
			pt_dialogs->error_cerr("class_filechoosers::create_filefilter()", Text::err_UNKNOWN_FILE_FILTER_TYPE, Text::err_msg_NONE);
			break;
	}
	
	return pt_filefilter;
}



/*** Run (returns filename) ***/
Glib::ustring class_filechoosers::run(){
	
	Glib::ustring str_filename;
	
	if(pt_filechooser != NULL){
		
		switch(pt_filechooser->run()){
			
			case(Gtk::RESPONSE_OK):
				pt_filechooser->hide();
				str_current_folder = pt_filechooser->get_current_folder();
				str_filename       = pt_filechooser->get_filename();
				
				// If FileChooserType is "SAVE"
				if(pt_filechooser->Gtk::FileChooser::get_action() == Gtk::FILE_CHOOSER_ACTION_SAVE){
					
					// If Checkbutton "Add Extension" is active -> Add File Extension (if not given)
					if(pt_checkbutton_add_extension->property_active() == true)
						str_filename = add_extension(str_filename);
					
					// If File Exists -> Ask for overwriting file
					if(Gio::File::create_for_path(str_filename)->query_exists() == true){
						
						// Qustion Message Dialog
						switch(pt_dialogs->question_message(pt_filechooser, Text::str_SAVE, Text::msg_FILE_OVERWRITE)){
							
							case Gtk::RESPONSE_YES:
								break;
								
							case Gtk::RESPONSE_NO:
							case Gtk::RESPONSE_CLOSE:
								str_filename.clear();
								break;
								
							default:
								str_filename.clear();
								
								// Error Message
								pt_dialogs->error_cerr("class_filechooser::run()", Text::err_UNKNOWN_BUTTON, Text::err_msg_NO);
								
								break;
						}
					}
					
					// Invalidate Spaces
					//str_filename = quoting_special_chars(str_filename);
				}
				
				break;
				
			case(Gtk::RESPONSE_CANCEL):
			case(Gtk::RESPONSE_CLOSE):
				str_filename.clear();
				break;
				
			default:
				str_filename.clear();
				
				// Error Message
				pt_dialogs->error_cerr("class_filechooser::run()", Text::err_UNKNOWN_BUTTON, Text::err_msg_CANCEL);
				break;
		} 
	}
	
	return str_filename;
}

/*** Run Multiple (retruns pointer of filechooserdialog ***/
Gtk::FileChooserDialog* class_filechoosers::run_multiple(){
	
	if(pt_filechooser != NULL){
		
		int response = pt_filechooser->run();
		pt_filechooser->hide();
		
		switch(response){
			
			case(Gtk::RESPONSE_OK):
				str_current_folder = pt_filechooser->get_current_folder();
				break;
				
			case(Gtk::RESPONSE_CANCEL):
			case(Gtk::RESPONSE_CLOSE):
				return NULL;
				break;
				
			default:
				
				// Error Message
				pt_dialogs->error_cerr("class_dialogs::filechooser_open_multiple()", Text::err_UNKNOWN_BUTTON, Text::err_msg_CANCEL);
				return NULL;
				break;
		}
	}
	
	return pt_filechooser;
}



/*** Add File Extension (if not given) ***/
Glib::ustring class_filechoosers::add_extension(Glib::ustring str_filename){
	
	Glib::ustring::size_type str_length = str_filename.length();
	
	switch(default_filter){
		
		case Pdfchain::FILE_FILTER_PDF:
			if(str_filename.compare(str_length - 4, str_length, Extension::ext_PDF) != 0)
				str_filename.append(Extension::ext_PDF);
			break;
			
		case Pdfchain::FILE_FILTER_FDF:
			if(str_filename.compare(str_length - 4, str_length, Extension::ext_FDF) != 0)
				str_filename.append(Extension::ext_FDF);
			break;
			
		case Pdfchain::FILE_FILTER_TXT:
			if(str_filename.compare(str_length - 4, str_length, Extension::ext_TXT) != 0)
				str_filename.append(Extension::ext_TXT);
			break;
			
		case Pdfchain::FILE_FILTER_DUMP:
			if(str_filename.compare(str_length - 5, str_length, Extension::ext_DUMP) != 0)
				str_filename.append(Extension::ext_DUMP);
			break;
			
		case Pdfchain::FILE_FILTER_ANY:
		case Pdfchain::FILE_FILTER_NONE:
			break;
			
		default:
			pt_dialogs->error_cerr("class_filechoosers::add_extension()", Text::err_UNKNOWN_FILE_FILTER_TYPE, Text::err_msg_NONE);
			break;
	}
	
	return str_filename;
}

/*** Clear ***/
void class_filechoosers::clear(){
	
	pt_checkbutton_add_extension->set_active(true);
	str_current_folder.clear();
	return;
}
