#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2008 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;

namespace PdfSharp.Fonts
{
  /// <summary>
  /// Testing only
  /// </summary>
  public sealed class AdobeGlyphListForNewFonts
  {
    AdobeGlyphListForNewFonts() { }

    /// <summary>
    /// LATIN CAPITAL LETTER A
    /// </summary>
    public const char A = '\u0041';

    /// <summary>
    /// LATIN CAPITAL LETTER AE
    /// </summary>
    public const char AE = '\u00C6';

    /// <summary>
    /// LATIN CAPITAL LETTER AE WITH ACUTE
    /// </summary>
    public const char AEacute = '\u01FC';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH ACUTE
    /// </summary>
    public const char Aacute = '\u00C1';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH BREVE
    /// </summary>
    public const char Abreve = '\u0102';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    /// </summary>
    public const char Acircumflex = '\u00C2';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH DIAERESIS
    /// </summary>
    public const char Adieresis = '\u00C4';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH GRAVE
    /// </summary>
    public const char Agrave = '\u00C0';

    /// <summary>
    /// GREEK CAPITAL LETTER ALPHA
    /// </summary>
    public const char Alpha = '\u0391';

    /// <summary>
    /// GREEK CAPITAL LETTER ALPHA WITH TONOS
    /// </summary>
    public const char Alphatonos = '\u0386';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH MACRON
    /// </summary>
    public const char Amacron = '\u0100';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH OGONEK
    /// </summary>
    public const char Aogonek = '\u0104';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH RING ABOVE
    /// </summary>
    public const char Aring = '\u00C5';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
    /// </summary>
    public const char Aringacute = '\u01FA';

    /// <summary>
    /// LATIN CAPITAL LETTER A WITH TILDE
    /// </summary>
    public const char Atilde = '\u00C3';

    /// <summary>
    /// LATIN CAPITAL LETTER B
    /// </summary>
    public const char B = '\u0042';

    /// <summary>
    /// GREEK CAPITAL LETTER BETA
    /// </summary>
    public const char Beta = '\u0392';

    /// <summary>
    /// LATIN CAPITAL LETTER C
    /// </summary>
    public const char C = '\u0043';

    /// <summary>
    /// LATIN CAPITAL LETTER C WITH ACUTE
    /// </summary>
    public const char Cacute = '\u0106';

    /// <summary>
    /// LATIN CAPITAL LETTER C WITH CARON
    /// </summary>
    public const char Ccaron = '\u010C';

    /// <summary>
    /// LATIN CAPITAL LETTER C WITH CEDILLA
    /// </summary>
    public const char Ccedilla = '\u00C7';

    /// <summary>
    /// LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    /// </summary>
    public const char Ccircumflex = '\u0108';

    /// <summary>
    /// LATIN CAPITAL LETTER C WITH DOT ABOVE
    /// </summary>
    public const char Cdotaccent = '\u010A';

    /// <summary>
    /// GREEK CAPITAL LETTER CHI
    /// </summary>
    public const char Chi = '\u03A7';

    /// <summary>
    /// LATIN CAPITAL LETTER D
    /// </summary>
    public const char D = '\u0044';

    /// <summary>
    /// LATIN CAPITAL LETTER D WITH CARON
    /// </summary>
    public const char Dcaron = '\u010E';

    /// <summary>
    /// LATIN CAPITAL LETTER D WITH STROKE
    /// </summary>
    public const char Dcroat = '\u0110';

    /// <summary>
    /// INCREMENT
    /// </summary>
    public const char Delta = '\u2206';

    /// <summary>
    /// LATIN CAPITAL LETTER E
    /// </summary>
    public const char E = '\u0045';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH ACUTE
    /// </summary>
    public const char Eacute = '\u00C9';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH BREVE
    /// </summary>
    public const char Ebreve = '\u0114';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH CARON
    /// </summary>
    public const char Ecaron = '\u011A';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    /// </summary>
    public const char Ecircumflex = '\u00CA';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH DIAERESIS
    /// </summary>
    public const char Edieresis = '\u00CB';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH DOT ABOVE
    /// </summary>
    public const char Edotaccent = '\u0116';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH GRAVE
    /// </summary>
    public const char Egrave = '\u00C8';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH MACRON
    /// </summary>
    public const char Emacron = '\u0112';

    /// <summary>
    /// LATIN CAPITAL LETTER ENG
    /// </summary>
    public const char Eng = '\u014A';

    /// <summary>
    /// LATIN CAPITAL LETTER E WITH OGONEK
    /// </summary>
    public const char Eogonek = '\u0118';

    /// <summary>
    /// GREEK CAPITAL LETTER EPSILON
    /// </summary>
    public const char Epsilon = '\u0395';

    /// <summary>
    /// GREEK CAPITAL LETTER EPSILON WITH TONOS
    /// </summary>
    public const char Epsilontonos = '\u0388';

    /// <summary>
    /// GREEK CAPITAL LETTER ETA
    /// </summary>
    public const char Eta = '\u0397';

    /// <summary>
    /// GREEK CAPITAL LETTER ETA WITH TONOS
    /// </summary>
    public const char Etatonos = '\u0389';

    /// <summary>
    /// LATIN CAPITAL LETTER ETH
    /// </summary>
    public const char Eth = '\u00D0';

    /// <summary>
    /// EURO SIGN
    /// </summary>
    public const char Euro = '\u20AC';

    /// <summary>
    /// LATIN CAPITAL LETTER F
    /// </summary>
    public const char F = '\u0046';

    /// <summary>
    /// LATIN CAPITAL LETTER G
    /// </summary>
    public const char G = '\u0047';

    /// <summary>
    /// GREEK CAPITAL LETTER GAMMA
    /// </summary>
    public const char Gamma = '\u0393';

    /// <summary>
    /// LATIN CAPITAL LETTER G WITH BREVE
    /// </summary>
    public const char Gbreve = '\u011E';

    /// <summary>
    /// LATIN CAPITAL LETTER G WITH CARON
    /// </summary>
    public const char Gcaron = '\u01E6';

    /// <summary>
    /// LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    /// </summary>
    public const char Gcircumflex = '\u011C';

    /// <summary>
    /// LATIN CAPITAL LETTER G WITH CEDILLA
    /// </summary>
    public const char Gcommaaccent = '\u0122';

    /// <summary>
    /// LATIN CAPITAL LETTER G WITH DOT ABOVE
    /// </summary>
    public const char Gdotaccent = '\u0120';

    /// <summary>
    /// LATIN CAPITAL LETTER H
    /// </summary>
    public const char H = '\u0048';

    /// <summary>
    /// BLACK CIRCLE
    /// </summary>
    public const char H18533 = '\u25CF';

    /// <summary>
    /// BLACK SMALL SQUARE
    /// </summary>
    public const char H18543 = '\u25AA';

    /// <summary>
    /// WHITE SMALL SQUARE
    /// </summary>
    public const char H18551 = '\u25AB';

    /// <summary>
    /// WHITE SQUARE
    /// </summary>
    public const char H22073 = '\u25A1';

    /// <summary>
    /// LATIN CAPITAL LETTER H WITH STROKE
    /// </summary>
    public const char Hbar = '\u0126';

    /// <summary>
    /// LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    /// </summary>
    public const char Hcircumflex = '\u0124';

    /// <summary>
    /// LATIN CAPITAL LETTER I
    /// </summary>
    public const char I = '\u0049';

    /// <summary>
    /// LATIN CAPITAL LIGATURE IJ
    /// </summary>
    public const char IJ = '\u0132';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH ACUTE
    /// </summary>
    public const char Iacute = '\u00CD';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH BREVE
    /// </summary>
    public const char Ibreve = '\u012C';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    /// </summary>
    public const char Icircumflex = '\u00CE';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH DIAERESIS
    /// </summary>
    public const char Idieresis = '\u00CF';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH DOT ABOVE
    /// </summary>
    public const char Idotaccent = '\u0130';

    /// <summary>
    /// BLACK-LETTER CAPITAL I
    /// </summary>
    public const char Ifraktur = '\u2111';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH GRAVE
    /// </summary>
    public const char Igrave = '\u00CC';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH MACRON
    /// </summary>
    public const char Imacron = '\u012A';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH OGONEK
    /// </summary>
    public const char Iogonek = '\u012E';

    /// <summary>
    /// GREEK CAPITAL LETTER IOTA
    /// </summary>
    public const char Iota = '\u0399';

    /// <summary>
    /// GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    /// </summary>
    public const char Iotadieresis = '\u03AA';

    /// <summary>
    /// GREEK CAPITAL LETTER IOTA WITH TONOS
    /// </summary>
    public const char Iotatonos = '\u038A';

    /// <summary>
    /// LATIN CAPITAL LETTER I WITH TILDE
    /// </summary>
    public const char Itilde = '\u0128';

    /// <summary>
    /// LATIN CAPITAL LETTER J
    /// </summary>
    public const char J = '\u004A';

    /// <summary>
    /// LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    /// </summary>
    public const char Jcircumflex = '\u0134';

    /// <summary>
    /// LATIN CAPITAL LETTER K
    /// </summary>
    public const char K = '\u004B';

    /// <summary>
    /// GREEK CAPITAL LETTER KAPPA
    /// </summary>
    public const char Kappa = '\u039A';

    /// <summary>
    /// LATIN CAPITAL LETTER K WITH CEDILLA
    /// </summary>
    public const char Kcommaaccent = '\u0136';

    /// <summary>
    /// LATIN CAPITAL LETTER L
    /// </summary>
    public const char L = '\u004C';

    /// <summary>
    /// LATIN CAPITAL LETTER L WITH ACUTE
    /// </summary>
    public const char Lacute = '\u0139';

    /// <summary>
    /// GREEK CAPITAL LETTER LAMDA
    /// </summary>
    public const char Lambda = '\u039B';

    /// <summary>
    /// LATIN CAPITAL LETTER L WITH CARON
    /// </summary>
    public const char Lcaron = '\u013D';

    /// <summary>
    /// LATIN CAPITAL LETTER L WITH CEDILLA
    /// </summary>
    public const char Lcommaaccent = '\u013B';

    /// <summary>
    /// LATIN CAPITAL LETTER L WITH MIDDLE DOT
    /// </summary>
    public const char Ldot = '\u013F';

    /// <summary>
    /// LATIN CAPITAL LETTER L WITH STROKE
    /// </summary>
    public const char Lslash = '\u0141';

    /// <summary>
    /// LATIN CAPITAL LETTER M
    /// </summary>
    public const char M = '\u004D';

    /// <summary>
    /// GREEK CAPITAL LETTER MU
    /// </summary>
    public const char Mu = '\u039C';

    /// <summary>
    /// LATIN CAPITAL LETTER N
    /// </summary>
    public const char N = '\u004E';

    /// <summary>
    /// LATIN CAPITAL LETTER N WITH ACUTE
    /// </summary>
    public const char Nacute = '\u0143';

    /// <summary>
    /// LATIN CAPITAL LETTER N WITH CARON
    /// </summary>
    public const char Ncaron = '\u0147';

    /// <summary>
    /// LATIN CAPITAL LETTER N WITH CEDILLA
    /// </summary>
    public const char Ncommaaccent = '\u0145';

    /// <summary>
    /// LATIN CAPITAL LETTER N WITH TILDE
    /// </summary>
    public const char Ntilde = '\u00D1';

    /// <summary>
    /// GREEK CAPITAL LETTER NU
    /// </summary>
    public const char Nu = '\u039D';

    /// <summary>
    /// LATIN CAPITAL LETTER O
    /// </summary>
    public const char O = '\u004F';

    /// <summary>
    /// LATIN CAPITAL LIGATURE OE
    /// </summary>
    public const char OE = '\u0152';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH ACUTE
    /// </summary>
    public const char Oacute = '\u00D3';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH BREVE
    /// </summary>
    public const char Obreve = '\u014E';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    /// </summary>
    public const char Ocircumflex = '\u00D4';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH DIAERESIS
    /// </summary>
    public const char Odieresis = '\u00D6';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH GRAVE
    /// </summary>
    public const char Ograve = '\u00D2';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH HORN
    /// </summary>
    public const char Ohorn = '\u01A0';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    /// </summary>
    public const char Ohungarumlaut = '\u0150';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH MACRON
    /// </summary>
    public const char Omacron = '\u014C';

    /// <summary>
    /// OHM SIGN
    /// </summary>
    public const char Omega = '\u2126';

    /// <summary>
    /// GREEK CAPITAL LETTER OMEGA WITH TONOS
    /// </summary>
    public const char Omegatonos = '\u038F';

    /// <summary>
    /// GREEK CAPITAL LETTER OMICRON
    /// </summary>
    public const char Omicron = '\u039F';

    /// <summary>
    /// GREEK CAPITAL LETTER OMICRON WITH TONOS
    /// </summary>
    public const char Omicrontonos = '\u038C';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH STROKE
    /// </summary>
    public const char Oslash = '\u00D8';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    /// </summary>
    public const char Oslashacute = '\u01FE';

    /// <summary>
    /// LATIN CAPITAL LETTER O WITH TILDE
    /// </summary>
    public const char Otilde = '\u00D5';

    /// <summary>
    /// LATIN CAPITAL LETTER P
    /// </summary>
    public const char P = '\u0050';

    /// <summary>
    /// GREEK CAPITAL LETTER PHI
    /// </summary>
    public const char Phi = '\u03A6';

    /// <summary>
    /// GREEK CAPITAL LETTER PI
    /// </summary>
    public const char Pi = '\u03A0';

    /// <summary>
    /// GREEK CAPITAL LETTER PSI
    /// </summary>
    public const char Psi = '\u03A8';

    /// <summary>
    /// LATIN CAPITAL LETTER Q
    /// </summary>
    public const char Q = '\u0051';

    /// <summary>
    /// LATIN CAPITAL LETTER R
    /// </summary>
    public const char R = '\u0052';

    /// <summary>
    /// LATIN CAPITAL LETTER R WITH ACUTE
    /// </summary>
    public const char Racute = '\u0154';

    /// <summary>
    /// LATIN CAPITAL LETTER R WITH CARON
    /// </summary>
    public const char Rcaron = '\u0158';

    /// <summary>
    /// LATIN CAPITAL LETTER R WITH CEDILLA
    /// </summary>
    public const char Rcommaaccent = '\u0156';

    /// <summary>
    /// BLACK-LETTER CAPITAL R
    /// </summary>
    public const char Rfraktur = '\u211C';

    /// <summary>
    /// GREEK CAPITAL LETTER RHO
    /// </summary>
    public const char Rho = '\u03A1';

    /// <summary>
    /// LATIN CAPITAL LETTER S
    /// </summary>
    public const char S = '\u0053';

    /// <summary>
    /// BOX DRAWINGS LIGHT DOWN AND RIGHT
    /// </summary>
    public const char SF010000 = '\u250C';

    /// <summary>
    /// BOX DRAWINGS LIGHT UP AND RIGHT
    /// </summary>
    public const char SF020000 = '\u2514';

    /// <summary>
    /// BOX DRAWINGS LIGHT DOWN AND LEFT
    /// </summary>
    public const char SF030000 = '\u2510';

    /// <summary>
    /// BOX DRAWINGS LIGHT UP AND LEFT
    /// </summary>
    public const char SF040000 = '\u2518';

    /// <summary>
    /// BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    /// </summary>
    public const char SF050000 = '\u253C';

    /// <summary>
    /// BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    /// </summary>
    public const char SF060000 = '\u252C';

    /// <summary>
    /// BOX DRAWINGS LIGHT UP AND HORIZONTAL
    /// </summary>
    public const char SF070000 = '\u2534';

    /// <summary>
    /// BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    /// </summary>
    public const char SF080000 = '\u251C';

    /// <summary>
    /// BOX DRAWINGS LIGHT VERTICAL AND LEFT
    /// </summary>
    public const char SF090000 = '\u2524';

    /// <summary>
    /// BOX DRAWINGS LIGHT HORIZONTAL
    /// </summary>
    public const char SF100000 = '\u2500';

    /// <summary>
    /// BOX DRAWINGS LIGHT VERTICAL
    /// </summary>
    public const char SF110000 = '\u2502';

    /// <summary>
    /// BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    /// </summary>
    public const char SF190000 = '\u2561';

    /// <summary>
    /// BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    /// </summary>
    public const char SF200000 = '\u2562';

    /// <summary>
    /// BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    /// </summary>
    public const char SF210000 = '\u2556';

    /// <summary>
    /// BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    /// </summary>
    public const char SF220000 = '\u2555';

    /// <summary>
    /// BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    /// </summary>
    public const char SF230000 = '\u2563';

    /// <summary>
    /// BOX DRAWINGS DOUBLE VERTICAL
    /// </summary>
    public const char SF240000 = '\u2551';

    /// <summary>
    /// BOX DRAWINGS DOUBLE DOWN AND LEFT
    /// </summary>
    public const char SF250000 = '\u2557';

    /// <summary>
    /// BOX DRAWINGS DOUBLE UP AND LEFT
    /// </summary>
    public const char SF260000 = '\u255D';

    /// <summary>
    /// BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    /// </summary>
    public const char SF270000 = '\u255C';

    /// <summary>
    /// BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    /// </summary>
    public const char SF280000 = '\u255B';

    /// <summary>
    /// BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    /// </summary>
    public const char SF360000 = '\u255E';

    /// <summary>
    /// BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    /// </summary>
    public const char SF370000 = '\u255F';

    /// <summary>
    /// BOX DRAWINGS DOUBLE UP AND RIGHT
    /// </summary>
    public const char SF380000 = '\u255A';

    /// <summary>
    /// BOX DRAWINGS DOUBLE DOWN AND RIGHT
    /// </summary>
    public const char SF390000 = '\u2554';

    /// <summary>
    /// BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    /// </summary>
    public const char SF400000 = '\u2569';

    /// <summary>
    /// BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    /// </summary>
    public const char SF410000 = '\u2566';

    /// <summary>
    /// BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    /// </summary>
    public const char SF420000 = '\u2560';

    /// <summary>
    /// BOX DRAWINGS DOUBLE HORIZONTAL
    /// </summary>
    public const char SF430000 = '\u2550';

    /// <summary>
    /// BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    /// </summary>
    public const char SF440000 = '\u256C';

    /// <summary>
    /// BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    /// </summary>
    public const char SF450000 = '\u2567';

    /// <summary>
    /// BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    /// </summary>
    public const char SF460000 = '\u2568';

    /// <summary>
    /// BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    /// </summary>
    public const char SF470000 = '\u2564';

    /// <summary>
    /// BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    /// </summary>
    public const char SF480000 = '\u2565';

    /// <summary>
    /// BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    /// </summary>
    public const char SF490000 = '\u2559';

    /// <summary>
    /// BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    /// </summary>
    public const char SF500000 = '\u2558';

    /// <summary>
    /// BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    /// </summary>
    public const char SF510000 = '\u2552';

    /// <summary>
    /// BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    /// </summary>
    public const char SF520000 = '\u2553';

    /// <summary>
    /// BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    /// </summary>
    public const char SF530000 = '\u256B';

    /// <summary>
    /// BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    /// </summary>
    public const char SF540000 = '\u256A';

    /// <summary>
    /// LATIN CAPITAL LETTER S WITH ACUTE
    /// </summary>
    public const char Sacute = '\u015A';

    /// <summary>
    /// LATIN CAPITAL LETTER S WITH CARON
    /// </summary>
    public const char Scaron = '\u0160';

    /// <summary>
    /// LATIN CAPITAL LETTER S WITH CEDILLA
    /// </summary>
    public const char Scedilla = '\u015E';

    /// <summary>
    /// LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    /// </summary>
    public const char Scircumflex = '\u015C';

    /// <summary>
    /// LATIN CAPITAL LETTER S WITH COMMA BELOW
    /// </summary>
    public const char Scommaaccent = '\u0218';

    /// <summary>
    /// GREEK CAPITAL LETTER SIGMA
    /// </summary>
    public const char Sigma = '\u03A3';

    /// <summary>
    /// LATIN CAPITAL LETTER T
    /// </summary>
    public const char T = '\u0054';

    /// <summary>
    /// GREEK CAPITAL LETTER TAU
    /// </summary>
    public const char Tau = '\u03A4';

    /// <summary>
    /// LATIN CAPITAL LETTER T WITH STROKE
    /// </summary>
    public const char Tbar = '\u0166';

    /// <summary>
    /// LATIN CAPITAL LETTER T WITH CARON
    /// </summary>
    public const char Tcaron = '\u0164';

    /// <summary>
    /// LATIN CAPITAL LETTER T WITH CEDILLA
    /// </summary>
    public const char Tcommaaccent = '\u0162';

    /// <summary>
    /// GREEK CAPITAL LETTER THETA
    /// </summary>
    public const char Theta = '\u0398';

    /// <summary>
    /// LATIN CAPITAL LETTER THORN
    /// </summary>
    public const char Thorn = '\u00DE';

    /// <summary>
    /// LATIN CAPITAL LETTER U
    /// </summary>
    public const char U = '\u0055';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH ACUTE
    /// </summary>
    public const char Uacute = '\u00DA';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH BREVE
    /// </summary>
    public const char Ubreve = '\u016C';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    /// </summary>
    public const char Ucircumflex = '\u00DB';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH DIAERESIS
    /// </summary>
    public const char Udieresis = '\u00DC';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH GRAVE
    /// </summary>
    public const char Ugrave = '\u00D9';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH HORN
    /// </summary>
    public const char Uhorn = '\u01AF';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    /// </summary>
    public const char Uhungarumlaut = '\u0170';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH MACRON
    /// </summary>
    public const char Umacron = '\u016A';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH OGONEK
    /// </summary>
    public const char Uogonek = '\u0172';

    /// <summary>
    /// GREEK CAPITAL LETTER UPSILON
    /// </summary>
    public const char Upsilon = '\u03A5';

    /// <summary>
    /// GREEK UPSILON WITH HOOK SYMBOL
    /// </summary>
    public const char Upsilon1 = '\u03D2';

    /// <summary>
    /// GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    /// </summary>
    public const char Upsilondieresis = '\u03AB';

    /// <summary>
    /// GREEK CAPITAL LETTER UPSILON WITH TONOS
    /// </summary>
    public const char Upsilontonos = '\u038E';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH RING ABOVE
    /// </summary>
    public const char Uring = '\u016E';

    /// <summary>
    /// LATIN CAPITAL LETTER U WITH TILDE
    /// </summary>
    public const char Utilde = '\u0168';

    /// <summary>
    /// LATIN CAPITAL LETTER V
    /// </summary>
    public const char V = '\u0056';

    /// <summary>
    /// LATIN CAPITAL LETTER W
    /// </summary>
    public const char W = '\u0057';

    /// <summary>
    /// LATIN CAPITAL LETTER W WITH ACUTE
    /// </summary>
    public const char Wacute = '\u1E82';

    /// <summary>
    /// LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    /// </summary>
    public const char Wcircumflex = '\u0174';

    /// <summary>
    /// LATIN CAPITAL LETTER W WITH DIAERESIS
    /// </summary>
    public const char Wdieresis = '\u1E84';

    /// <summary>
    /// LATIN CAPITAL LETTER W WITH GRAVE
    /// </summary>
    public const char Wgrave = '\u1E80';

    /// <summary>
    /// LATIN CAPITAL LETTER X
    /// </summary>
    public const char X = '\u0058';

    /// <summary>
    /// GREEK CAPITAL LETTER XI
    /// </summary>
    public const char Xi = '\u039E';

    /// <summary>
    /// LATIN CAPITAL LETTER Y
    /// </summary>
    public const char Y = '\u0059';

    /// <summary>
    /// LATIN CAPITAL LETTER Y WITH ACUTE
    /// </summary>
    public const char Yacute = '\u00DD';

    /// <summary>
    /// LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    /// </summary>
    public const char Ycircumflex = '\u0176';

    /// <summary>
    /// LATIN CAPITAL LETTER Y WITH DIAERESIS
    /// </summary>
    public const char Ydieresis = '\u0178';

    /// <summary>
    /// LATIN CAPITAL LETTER Y WITH GRAVE
    /// </summary>
    public const char Ygrave = '\u1EF2';

    /// <summary>
    /// LATIN CAPITAL LETTER Z
    /// </summary>
    public const char Z = '\u005A';

    /// <summary>
    /// LATIN CAPITAL LETTER Z WITH ACUTE
    /// </summary>
    public const char Zacute = '\u0179';

    /// <summary>
    /// LATIN CAPITAL LETTER Z WITH CARON
    /// </summary>
    public const char Zcaron = '\u017D';

    /// <summary>
    /// LATIN CAPITAL LETTER Z WITH DOT ABOVE
    /// </summary>
    public const char Zdotaccent = '\u017B';

    /// <summary>
    /// GREEK CAPITAL LETTER ZETA
    /// </summary>
    public const char Zeta = '\u0396';

    /// <summary>
    /// LATIN SMALL LETTER A
    /// </summary>
    public const char a = '\u0061';

    /// <summary>
    /// LATIN SMALL LETTER A WITH ACUTE
    /// </summary>
    public const char aacute = '\u00E1';

    /// <summary>
    /// LATIN SMALL LETTER A WITH BREVE
    /// </summary>
    public const char abreve = '\u0103';

    /// <summary>
    /// LATIN SMALL LETTER A WITH CIRCUMFLEX
    /// </summary>
    public const char acircumflex = '\u00E2';

    /// <summary>
    /// ACUTE ACCENT
    /// </summary>
    public const char acute = '\u00B4';

    /// <summary>
    /// COMBINING ACUTE ACCENT
    /// </summary>
    public const char acutecomb = '\u0301';

    /// <summary>
    /// LATIN SMALL LETTER A WITH DIAERESIS
    /// </summary>
    public const char adieresis = '\u00E4';

    /// <summary>
    /// LATIN SMALL LETTER AE
    /// </summary>
    public const char ae = '\u00E6';

    /// <summary>
    /// LATIN SMALL LETTER AE WITH ACUTE
    /// </summary>
    public const char aeacute = '\u01FD';

    /// <summary>
    /// HORIZONTAL BAR
    /// </summary>
    public const char afii00208 = '\u2015';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER A
    /// </summary>
    public const char afii10017 = '\u0410';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER BE
    /// </summary>
    public const char afii10018 = '\u0411';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER VE
    /// </summary>
    public const char afii10019 = '\u0412';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER GHE
    /// </summary>
    public const char afii10020 = '\u0413';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER DE
    /// </summary>
    public const char afii10021 = '\u0414';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER IE
    /// </summary>
    public const char afii10022 = '\u0415';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER IO
    /// </summary>
    public const char afii10023 = '\u0401';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER ZHE
    /// </summary>
    public const char afii10024 = '\u0416';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER ZE
    /// </summary>
    public const char afii10025 = '\u0417';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER I
    /// </summary>
    public const char afii10026 = '\u0418';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER SHORT I
    /// </summary>
    public const char afii10027 = '\u0419';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER KA
    /// </summary>
    public const char afii10028 = '\u041A';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER EL
    /// </summary>
    public const char afii10029 = '\u041B';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER EM
    /// </summary>
    public const char afii10030 = '\u041C';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER EN
    /// </summary>
    public const char afii10031 = '\u041D';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER O
    /// </summary>
    public const char afii10032 = '\u041E';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER PE
    /// </summary>
    public const char afii10033 = '\u041F';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER ER
    /// </summary>
    public const char afii10034 = '\u0420';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER ES
    /// </summary>
    public const char afii10035 = '\u0421';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER TE
    /// </summary>
    public const char afii10036 = '\u0422';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER U
    /// </summary>
    public const char afii10037 = '\u0423';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER EF
    /// </summary>
    public const char afii10038 = '\u0424';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER HA
    /// </summary>
    public const char afii10039 = '\u0425';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER TSE
    /// </summary>
    public const char afii10040 = '\u0426';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER CHE
    /// </summary>
    public const char afii10041 = '\u0427';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER SHA
    /// </summary>
    public const char afii10042 = '\u0428';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER SHCHA
    /// </summary>
    public const char afii10043 = '\u0429';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER HARD SIGN
    /// </summary>
    public const char afii10044 = '\u042A';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER YERU
    /// </summary>
    public const char afii10045 = '\u042B';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER SOFT SIGN
    /// </summary>
    public const char afii10046 = '\u042C';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER E
    /// </summary>
    public const char afii10047 = '\u042D';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER YU
    /// </summary>
    public const char afii10048 = '\u042E';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER YA
    /// </summary>
    public const char afii10049 = '\u042F';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER GHE WITH UPTURN
    /// </summary>
    public const char afii10050 = '\u0490';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER DJE
    /// </summary>
    public const char afii10051 = '\u0402';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER GJE
    /// </summary>
    public const char afii10052 = '\u0403';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER UKRAINIAN IE
    /// </summary>
    public const char afii10053 = '\u0404';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER DZE
    /// </summary>
    public const char afii10054 = '\u0405';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    /// </summary>
    public const char afii10055 = '\u0406';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER YI
    /// </summary>
    public const char afii10056 = '\u0407';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER JE
    /// </summary>
    public const char afii10057 = '\u0408';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER LJE
    /// </summary>
    public const char afii10058 = '\u0409';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER NJE
    /// </summary>
    public const char afii10059 = '\u040A';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER TSHE
    /// </summary>
    public const char afii10060 = '\u040B';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER KJE
    /// </summary>
    public const char afii10061 = '\u040C';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER SHORT U
    /// </summary>
    public const char afii10062 = '\u040E';

    /// <summary>
    /// CYRILLIC SMALL LETTER A
    /// </summary>
    public const char afii10065 = '\u0430';

    /// <summary>
    /// CYRILLIC SMALL LETTER BE
    /// </summary>
    public const char afii10066 = '\u0431';

    /// <summary>
    /// CYRILLIC SMALL LETTER VE
    /// </summary>
    public const char afii10067 = '\u0432';

    /// <summary>
    /// CYRILLIC SMALL LETTER GHE
    /// </summary>
    public const char afii10068 = '\u0433';

    /// <summary>
    /// CYRILLIC SMALL LETTER DE
    /// </summary>
    public const char afii10069 = '\u0434';

    /// <summary>
    /// CYRILLIC SMALL LETTER IE
    /// </summary>
    public const char afii10070 = '\u0435';

    /// <summary>
    /// CYRILLIC SMALL LETTER IO
    /// </summary>
    public const char afii10071 = '\u0451';

    /// <summary>
    /// CYRILLIC SMALL LETTER ZHE
    /// </summary>
    public const char afii10072 = '\u0436';

    /// <summary>
    /// CYRILLIC SMALL LETTER ZE
    /// </summary>
    public const char afii10073 = '\u0437';

    /// <summary>
    /// CYRILLIC SMALL LETTER I
    /// </summary>
    public const char afii10074 = '\u0438';

    /// <summary>
    /// CYRILLIC SMALL LETTER SHORT I
    /// </summary>
    public const char afii10075 = '\u0439';

    /// <summary>
    /// CYRILLIC SMALL LETTER KA
    /// </summary>
    public const char afii10076 = '\u043A';

    /// <summary>
    /// CYRILLIC SMALL LETTER EL
    /// </summary>
    public const char afii10077 = '\u043B';

    /// <summary>
    /// CYRILLIC SMALL LETTER EM
    /// </summary>
    public const char afii10078 = '\u043C';

    /// <summary>
    /// CYRILLIC SMALL LETTER EN
    /// </summary>
    public const char afii10079 = '\u043D';

    /// <summary>
    /// CYRILLIC SMALL LETTER O
    /// </summary>
    public const char afii10080 = '\u043E';

    /// <summary>
    /// CYRILLIC SMALL LETTER PE
    /// </summary>
    public const char afii10081 = '\u043F';

    /// <summary>
    /// CYRILLIC SMALL LETTER ER
    /// </summary>
    public const char afii10082 = '\u0440';

    /// <summary>
    /// CYRILLIC SMALL LETTER ES
    /// </summary>
    public const char afii10083 = '\u0441';

    /// <summary>
    /// CYRILLIC SMALL LETTER TE
    /// </summary>
    public const char afii10084 = '\u0442';

    /// <summary>
    /// CYRILLIC SMALL LETTER U
    /// </summary>
    public const char afii10085 = '\u0443';

    /// <summary>
    /// CYRILLIC SMALL LETTER EF
    /// </summary>
    public const char afii10086 = '\u0444';

    /// <summary>
    /// CYRILLIC SMALL LETTER HA
    /// </summary>
    public const char afii10087 = '\u0445';

    /// <summary>
    /// CYRILLIC SMALL LETTER TSE
    /// </summary>
    public const char afii10088 = '\u0446';

    /// <summary>
    /// CYRILLIC SMALL LETTER CHE
    /// </summary>
    public const char afii10089 = '\u0447';

    /// <summary>
    /// CYRILLIC SMALL LETTER SHA
    /// </summary>
    public const char afii10090 = '\u0448';

    /// <summary>
    /// CYRILLIC SMALL LETTER SHCHA
    /// </summary>
    public const char afii10091 = '\u0449';

    /// <summary>
    /// CYRILLIC SMALL LETTER HARD SIGN
    /// </summary>
    public const char afii10092 = '\u044A';

    /// <summary>
    /// CYRILLIC SMALL LETTER YERU
    /// </summary>
    public const char afii10093 = '\u044B';

    /// <summary>
    /// CYRILLIC SMALL LETTER SOFT SIGN
    /// </summary>
    public const char afii10094 = '\u044C';

    /// <summary>
    /// CYRILLIC SMALL LETTER E
    /// </summary>
    public const char afii10095 = '\u044D';

    /// <summary>
    /// CYRILLIC SMALL LETTER YU
    /// </summary>
    public const char afii10096 = '\u044E';

    /// <summary>
    /// CYRILLIC SMALL LETTER YA
    /// </summary>
    public const char afii10097 = '\u044F';

    /// <summary>
    /// CYRILLIC SMALL LETTER GHE WITH UPTURN
    /// </summary>
    public const char afii10098 = '\u0491';

    /// <summary>
    /// CYRILLIC SMALL LETTER DJE
    /// </summary>
    public const char afii10099 = '\u0452';

    /// <summary>
    /// CYRILLIC SMALL LETTER GJE
    /// </summary>
    public const char afii10100 = '\u0453';

    /// <summary>
    /// CYRILLIC SMALL LETTER UKRAINIAN IE
    /// </summary>
    public const char afii10101 = '\u0454';

    /// <summary>
    /// CYRILLIC SMALL LETTER DZE
    /// </summary>
    public const char afii10102 = '\u0455';

    /// <summary>
    /// CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    /// </summary>
    public const char afii10103 = '\u0456';

    /// <summary>
    /// CYRILLIC SMALL LETTER YI
    /// </summary>
    public const char afii10104 = '\u0457';

    /// <summary>
    /// CYRILLIC SMALL LETTER JE
    /// </summary>
    public const char afii10105 = '\u0458';

    /// <summary>
    /// CYRILLIC SMALL LETTER LJE
    /// </summary>
    public const char afii10106 = '\u0459';

    /// <summary>
    /// CYRILLIC SMALL LETTER NJE
    /// </summary>
    public const char afii10107 = '\u045A';

    /// <summary>
    /// CYRILLIC SMALL LETTER TSHE
    /// </summary>
    public const char afii10108 = '\u045B';

    /// <summary>
    /// CYRILLIC SMALL LETTER KJE
    /// </summary>
    public const char afii10109 = '\u045C';

    /// <summary>
    /// CYRILLIC SMALL LETTER SHORT U
    /// </summary>
    public const char afii10110 = '\u045E';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER DZHE
    /// </summary>
    public const char afii10145 = '\u040F';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER YAT
    /// </summary>
    public const char afii10146 = '\u0462';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER FITA
    /// </summary>
    public const char afii10147 = '\u0472';

    /// <summary>
    /// CYRILLIC CAPITAL LETTER IZHITSA
    /// </summary>
    public const char afii10148 = '\u0474';

    /// <summary>
    /// CYRILLIC SMALL LETTER DZHE
    /// </summary>
    public const char afii10193 = '\u045F';

    /// <summary>
    /// CYRILLIC SMALL LETTER YAT
    /// </summary>
    public const char afii10194 = '\u0463';

    /// <summary>
    /// CYRILLIC SMALL LETTER FITA
    /// </summary>
    public const char afii10195 = '\u0473';

    /// <summary>
    /// CYRILLIC SMALL LETTER IZHITSA
    /// </summary>
    public const char afii10196 = '\u0475';

    /// <summary>
    /// CYRILLIC SMALL LETTER SCHWA
    /// </summary>
    public const char afii10846 = '\u04D9';

    /// <summary>
    /// LEFT-TO-RIGHT MARK
    /// </summary>
    public const char afii299 = '\u200E';

    /// <summary>
    /// RIGHT-TO-LEFT MARK
    /// </summary>
    public const char afii300 = '\u200F';

    /// <summary>
    /// ZERO WIDTH JOINER
    /// </summary>
    public const char afii301 = '\u200D';

    /// <summary>
    /// ARABIC PERCENT SIGN
    /// </summary>
    public const char afii57381 = '\u066A';

    /// <summary>
    /// ARABIC COMMA
    /// </summary>
    public const char afii57388 = '\u060C';

    /// <summary>
    /// ARABIC-INDIC DIGIT ZERO
    /// </summary>
    public const char afii57392 = '\u0660';

    /// <summary>
    /// ARABIC-INDIC DIGIT ONE
    /// </summary>
    public const char afii57393 = '\u0661';

    /// <summary>
    /// ARABIC-INDIC DIGIT TWO
    /// </summary>
    public const char afii57394 = '\u0662';

    /// <summary>
    /// ARABIC-INDIC DIGIT THREE
    /// </summary>
    public const char afii57395 = '\u0663';

    /// <summary>
    /// ARABIC-INDIC DIGIT FOUR
    /// </summary>
    public const char afii57396 = '\u0664';

    /// <summary>
    /// ARABIC-INDIC DIGIT FIVE
    /// </summary>
    public const char afii57397 = '\u0665';

    /// <summary>
    /// ARABIC-INDIC DIGIT SIX
    /// </summary>
    public const char afii57398 = '\u0666';

    /// <summary>
    /// ARABIC-INDIC DIGIT SEVEN
    /// </summary>
    public const char afii57399 = '\u0667';

    /// <summary>
    /// ARABIC-INDIC DIGIT EIGHT
    /// </summary>
    public const char afii57400 = '\u0668';

    /// <summary>
    /// ARABIC-INDIC DIGIT NINE
    /// </summary>
    public const char afii57401 = '\u0669';

    /// <summary>
    /// ARABIC SEMICOLON
    /// </summary>
    public const char afii57403 = '\u061B';

    /// <summary>
    /// ARABIC QUESTION MARK
    /// </summary>
    public const char afii57407 = '\u061F';

    /// <summary>
    /// ARABIC LETTER HAMZA
    /// </summary>
    public const char afii57409 = '\u0621';

    /// <summary>
    /// ARABIC LETTER ALEF WITH MADDA ABOVE
    /// </summary>
    public const char afii57410 = '\u0622';

    /// <summary>
    /// ARABIC LETTER ALEF WITH HAMZA ABOVE
    /// </summary>
    public const char afii57411 = '\u0623';

    /// <summary>
    /// ARABIC LETTER WAW WITH HAMZA ABOVE
    /// </summary>
    public const char afii57412 = '\u0624';

    /// <summary>
    /// ARABIC LETTER ALEF WITH HAMZA BELOW
    /// </summary>
    public const char afii57413 = '\u0625';

    /// <summary>
    /// ARABIC LETTER YEH WITH HAMZA ABOVE
    /// </summary>
    public const char afii57414 = '\u0626';

    /// <summary>
    /// ARABIC LETTER ALEF
    /// </summary>
    public const char afii57415 = '\u0627';

    /// <summary>
    /// ARABIC LETTER BEH
    /// </summary>
    public const char afii57416 = '\u0628';

    /// <summary>
    /// ARABIC LETTER TEH MARBUTA
    /// </summary>
    public const char afii57417 = '\u0629';

    /// <summary>
    /// ARABIC LETTER TEH
    /// </summary>
    public const char afii57418 = '\u062A';

    /// <summary>
    /// ARABIC LETTER THEH
    /// </summary>
    public const char afii57419 = '\u062B';

    /// <summary>
    /// ARABIC LETTER JEEM
    /// </summary>
    public const char afii57420 = '\u062C';

    /// <summary>
    /// ARABIC LETTER HAH
    /// </summary>
    public const char afii57421 = '\u062D';

    /// <summary>
    /// ARABIC LETTER KHAH
    /// </summary>
    public const char afii57422 = '\u062E';

    /// <summary>
    /// ARABIC LETTER DAL
    /// </summary>
    public const char afii57423 = '\u062F';

    /// <summary>
    /// ARABIC LETTER THAL
    /// </summary>
    public const char afii57424 = '\u0630';

    /// <summary>
    /// ARABIC LETTER REH
    /// </summary>
    public const char afii57425 = '\u0631';

    /// <summary>
    /// ARABIC LETTER ZAIN
    /// </summary>
    public const char afii57426 = '\u0632';

    /// <summary>
    /// ARABIC LETTER SEEN
    /// </summary>
    public const char afii57427 = '\u0633';

    /// <summary>
    /// ARABIC LETTER SHEEN
    /// </summary>
    public const char afii57428 = '\u0634';

    /// <summary>
    /// ARABIC LETTER SAD
    /// </summary>
    public const char afii57429 = '\u0635';

    /// <summary>
    /// ARABIC LETTER DAD
    /// </summary>
    public const char afii57430 = '\u0636';

    /// <summary>
    /// ARABIC LETTER TAH
    /// </summary>
    public const char afii57431 = '\u0637';

    /// <summary>
    /// ARABIC LETTER ZAH
    /// </summary>
    public const char afii57432 = '\u0638';

    /// <summary>
    /// ARABIC LETTER AIN
    /// </summary>
    public const char afii57433 = '\u0639';

    /// <summary>
    /// ARABIC LETTER GHAIN
    /// </summary>
    public const char afii57434 = '\u063A';

    /// <summary>
    /// ARABIC TATWEEL
    /// </summary>
    public const char afii57440 = '\u0640';

    /// <summary>
    /// ARABIC LETTER FEH
    /// </summary>
    public const char afii57441 = '\u0641';

    /// <summary>
    /// ARABIC LETTER QAF
    /// </summary>
    public const char afii57442 = '\u0642';

    /// <summary>
    /// ARABIC LETTER KAF
    /// </summary>
    public const char afii57443 = '\u0643';

    /// <summary>
    /// ARABIC LETTER LAM
    /// </summary>
    public const char afii57444 = '\u0644';

    /// <summary>
    /// ARABIC LETTER MEEM
    /// </summary>
    public const char afii57445 = '\u0645';

    /// <summary>
    /// ARABIC LETTER NOON
    /// </summary>
    public const char afii57446 = '\u0646';

    /// <summary>
    /// ARABIC LETTER WAW
    /// </summary>
    public const char afii57448 = '\u0648';

    /// <summary>
    /// ARABIC LETTER ALEF MAKSURA
    /// </summary>
    public const char afii57449 = '\u0649';

    /// <summary>
    /// ARABIC LETTER YEH
    /// </summary>
    public const char afii57450 = '\u064A';

    /// <summary>
    /// ARABIC FATHATAN
    /// </summary>
    public const char afii57451 = '\u064B';

    /// <summary>
    /// ARABIC DAMMATAN
    /// </summary>
    public const char afii57452 = '\u064C';

    /// <summary>
    /// ARABIC KASRATAN
    /// </summary>
    public const char afii57453 = '\u064D';

    /// <summary>
    /// ARABIC FATHA
    /// </summary>
    public const char afii57454 = '\u064E';

    /// <summary>
    /// ARABIC DAMMA
    /// </summary>
    public const char afii57455 = '\u064F';

    /// <summary>
    /// ARABIC KASRA
    /// </summary>
    public const char afii57456 = '\u0650';

    /// <summary>
    /// ARABIC SHADDA
    /// </summary>
    public const char afii57457 = '\u0651';

    /// <summary>
    /// ARABIC SUKUN
    /// </summary>
    public const char afii57458 = '\u0652';

    /// <summary>
    /// ARABIC LETTER HEH
    /// </summary>
    public const char afii57470 = '\u0647';

    /// <summary>
    /// ARABIC LETTER VEH
    /// </summary>
    public const char afii57505 = '\u06A4';

    /// <summary>
    /// ARABIC LETTER PEH
    /// </summary>
    public const char afii57506 = '\u067E';

    /// <summary>
    /// ARABIC LETTER TCHEH
    /// </summary>
    public const char afii57507 = '\u0686';

    /// <summary>
    /// ARABIC LETTER JEH
    /// </summary>
    public const char afii57508 = '\u0698';

    /// <summary>
    /// ARABIC LETTER GAF
    /// </summary>
    public const char afii57509 = '\u06AF';

    /// <summary>
    /// ARABIC LETTER TTEH
    /// </summary>
    public const char afii57511 = '\u0679';

    /// <summary>
    /// ARABIC LETTER DDAL
    /// </summary>
    public const char afii57512 = '\u0688';

    /// <summary>
    /// ARABIC LETTER RREH
    /// </summary>
    public const char afii57513 = '\u0691';

    /// <summary>
    /// ARABIC LETTER NOON GHUNNA
    /// </summary>
    public const char afii57514 = '\u06BA';

    /// <summary>
    /// ARABIC LETTER YEH BARREE
    /// </summary>
    public const char afii57519 = '\u06D2';

    /// <summary>
    /// ARABIC LETTER AE
    /// </summary>
    public const char afii57534 = '\u06D5';

    /// <summary>
    /// NEW SHEQEL SIGN
    /// </summary>
    public const char afii57636 = '\u20AA';

    /// <summary>
    /// HEBREW PUNCTUATION MAQAF
    /// </summary>
    public const char afii57645 = '\u05BE';

    /// <summary>
    /// HEBREW PUNCTUATION SOF PASUQ
    /// </summary>
    public const char afii57658 = '\u05C3';

    /// <summary>
    /// HEBREW LETTER ALEF
    /// </summary>
    public const char afii57664 = '\u05D0';

    /// <summary>
    /// HEBREW LETTER BET
    /// </summary>
    public const char afii57665 = '\u05D1';

    /// <summary>
    /// HEBREW LETTER GIMEL
    /// </summary>
    public const char afii57666 = '\u05D2';

    /// <summary>
    /// HEBREW LETTER DALET
    /// </summary>
    public const char afii57667 = '\u05D3';

    /// <summary>
    /// HEBREW LETTER HE
    /// </summary>
    public const char afii57668 = '\u05D4';

    /// <summary>
    /// HEBREW LETTER VAV
    /// </summary>
    public const char afii57669 = '\u05D5';

    /// <summary>
    /// HEBREW LETTER ZAYIN
    /// </summary>
    public const char afii57670 = '\u05D6';

    /// <summary>
    /// HEBREW LETTER HET
    /// </summary>
    public const char afii57671 = '\u05D7';

    /// <summary>
    /// HEBREW LETTER TET
    /// </summary>
    public const char afii57672 = '\u05D8';

    /// <summary>
    /// HEBREW LETTER YOD
    /// </summary>
    public const char afii57673 = '\u05D9';

    /// <summary>
    /// HEBREW LETTER FINAL KAF
    /// </summary>
    public const char afii57674 = '\u05DA';

    /// <summary>
    /// HEBREW LETTER KAF
    /// </summary>
    public const char afii57675 = '\u05DB';

    /// <summary>
    /// HEBREW LETTER LAMED
    /// </summary>
    public const char afii57676 = '\u05DC';

    /// <summary>
    /// HEBREW LETTER FINAL MEM
    /// </summary>
    public const char afii57677 = '\u05DD';

    /// <summary>
    /// HEBREW LETTER MEM
    /// </summary>
    public const char afii57678 = '\u05DE';

    /// <summary>
    /// HEBREW LETTER FINAL NUN
    /// </summary>
    public const char afii57679 = '\u05DF';

    /// <summary>
    /// HEBREW LETTER NUN
    /// </summary>
    public const char afii57680 = '\u05E0';

    /// <summary>
    /// HEBREW LETTER SAMEKH
    /// </summary>
    public const char afii57681 = '\u05E1';

    /// <summary>
    /// HEBREW LETTER AYIN
    /// </summary>
    public const char afii57682 = '\u05E2';

    /// <summary>
    /// HEBREW LETTER FINAL PE
    /// </summary>
    public const char afii57683 = '\u05E3';

    /// <summary>
    /// HEBREW LETTER PE
    /// </summary>
    public const char afii57684 = '\u05E4';

    /// <summary>
    /// HEBREW LETTER FINAL TSADI
    /// </summary>
    public const char afii57685 = '\u05E5';

    /// <summary>
    /// HEBREW LETTER TSADI
    /// </summary>
    public const char afii57686 = '\u05E6';

    /// <summary>
    /// HEBREW LETTER QOF
    /// </summary>
    public const char afii57687 = '\u05E7';

    /// <summary>
    /// HEBREW LETTER RESH
    /// </summary>
    public const char afii57688 = '\u05E8';

    /// <summary>
    /// HEBREW LETTER SHIN
    /// </summary>
    public const char afii57689 = '\u05E9';

    /// <summary>
    /// HEBREW LETTER TAV
    /// </summary>
    public const char afii57690 = '\u05EA';

    /// <summary>
    /// HEBREW LIGATURE YIDDISH DOUBLE VAV
    /// </summary>
    public const char afii57716 = '\u05F0';

    /// <summary>
    /// HEBREW LIGATURE YIDDISH VAV YOD
    /// </summary>
    public const char afii57717 = '\u05F1';

    /// <summary>
    /// HEBREW LIGATURE YIDDISH DOUBLE YOD
    /// </summary>
    public const char afii57718 = '\u05F2';

    /// <summary>
    /// HEBREW POINT HIRIQ
    /// </summary>
    public const char afii57793 = '\u05B4';

    /// <summary>
    /// HEBREW POINT TSERE
    /// </summary>
    public const char afii57794 = '\u05B5';

    /// <summary>
    /// HEBREW POINT SEGOL
    /// </summary>
    public const char afii57795 = '\u05B6';

    /// <summary>
    /// HEBREW POINT QUBUTS
    /// </summary>
    public const char afii57796 = '\u05BB';

    /// <summary>
    /// HEBREW POINT QAMATS
    /// </summary>
    public const char afii57797 = '\u05B8';

    /// <summary>
    /// HEBREW POINT PATAH
    /// </summary>
    public const char afii57798 = '\u05B7';

    /// <summary>
    /// HEBREW POINT SHEVA
    /// </summary>
    public const char afii57799 = '\u05B0';

    /// <summary>
    /// HEBREW POINT HATAF PATAH
    /// </summary>
    public const char afii57800 = '\u05B2';

    /// <summary>
    /// HEBREW POINT HATAF SEGOL
    /// </summary>
    public const char afii57801 = '\u05B1';

    /// <summary>
    /// HEBREW POINT HATAF QAMATS
    /// </summary>
    public const char afii57802 = '\u05B3';

    /// <summary>
    /// HEBREW POINT SIN DOT
    /// </summary>
    public const char afii57803 = '\u05C2';

    /// <summary>
    /// HEBREW POINT SHIN DOT
    /// </summary>
    public const char afii57804 = '\u05C1';

    /// <summary>
    /// HEBREW POINT HOLAM
    /// </summary>
    public const char afii57806 = '\u05B9';

    /// <summary>
    /// HEBREW POINT DAGESH OR MAPIQ
    /// </summary>
    public const char afii57807 = '\u05BC';

    /// <summary>
    /// HEBREW POINT METEG
    /// </summary>
    public const char afii57839 = '\u05BD';

    /// <summary>
    /// HEBREW POINT RAFE
    /// </summary>
    public const char afii57841 = '\u05BF';

    /// <summary>
    /// HEBREW PUNCTUATION PASEQ
    /// </summary>
    public const char afii57842 = '\u05C0';

    /// <summary>
    /// MODIFIER LETTER APOSTROPHE
    /// </summary>
    public const char afii57929 = '\u02BC';

    /// <summary>
    /// CARE OF
    /// </summary>
    public const char afii61248 = '\u2105';

    /// <summary>
    /// SCRIPT SMALL L
    /// </summary>
    public const char afii61289 = '\u2113';

    /// <summary>
    /// NUMERO SIGN
    /// </summary>
    public const char afii61352 = '\u2116';

    /// <summary>
    /// POP DIRECTIONAL FORMATTING
    /// </summary>
    public const char afii61573 = '\u202C';

    /// <summary>
    /// LEFT-TO-RIGHT OVERRIDE
    /// </summary>
    public const char afii61574 = '\u202D';

    /// <summary>
    /// RIGHT-TO-LEFT OVERRIDE
    /// </summary>
    public const char afii61575 = '\u202E';

    /// <summary>
    /// ZERO WIDTH NON-JOINER
    /// </summary>
    public const char afii61664 = '\u200C';

    /// <summary>
    /// ARABIC FIVE POINTED STAR
    /// </summary>
    public const char afii63167 = '\u066D';

    /// <summary>
    /// MODIFIER LETTER REVERSED COMMA
    /// </summary>
    public const char afii64937 = '\u02BD';

    /// <summary>
    /// LATIN SMALL LETTER A WITH GRAVE
    /// </summary>
    public const char agrave = '\u00E0';

    /// <summary>
    /// ALEF SYMBOL
    /// </summary>
    public const char aleph = '\u2135';

    /// <summary>
    /// GREEK SMALL LETTER ALPHA
    /// </summary>
    public const char alpha = '\u03B1';

    /// <summary>
    /// GREEK SMALL LETTER ALPHA WITH TONOS
    /// </summary>
    public const char alphatonos = '\u03AC';

    /// <summary>
    /// LATIN SMALL LETTER A WITH MACRON
    /// </summary>
    public const char amacron = '\u0101';

    /// <summary>
    /// AMPERSAND
    /// </summary>
    public const char ampersand = '\u0026';

    /// <summary>
    /// ANGLE
    /// </summary>
    public const char angle = '\u2220';

    /// <summary>
    /// LEFT-POINTING ANGLE BRACKET
    /// </summary>
    public const char angleleft = '\u2329';

    /// <summary>
    /// RIGHT-POINTING ANGLE BRACKET
    /// </summary>
    public const char angleright = '\u232A';

    /// <summary>
    /// GREEK ANO TELEIA
    /// </summary>
    public const char anoteleia = '\u0387';

    /// <summary>
    /// LATIN SMALL LETTER A WITH OGONEK
    /// </summary>
    public const char aogonek = '\u0105';

    /// <summary>
    /// ALMOST EQUAL TO
    /// </summary>
    public const char approxequal = '\u2248';

    /// <summary>
    /// LATIN SMALL LETTER A WITH RING ABOVE
    /// </summary>
    public const char aring = '\u00E5';

    /// <summary>
    /// LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
    /// </summary>
    public const char aringacute = '\u01FB';

    /// <summary>
    /// LEFT RIGHT ARROW
    /// </summary>
    public const char arrowboth = '\u2194';

    /// <summary>
    /// LEFT RIGHT DOUBLE ARROW
    /// </summary>
    public const char arrowdblboth = '\u21D4';

    /// <summary>
    /// DOWNWARDS DOUBLE ARROW
    /// </summary>
    public const char arrowdbldown = '\u21D3';

    /// <summary>
    /// LEFTWARDS DOUBLE ARROW
    /// </summary>
    public const char arrowdblleft = '\u21D0';

    /// <summary>
    /// RIGHTWARDS DOUBLE ARROW
    /// </summary>
    public const char arrowdblright = '\u21D2';

    /// <summary>
    /// UPWARDS DOUBLE ARROW
    /// </summary>
    public const char arrowdblup = '\u21D1';

    /// <summary>
    /// DOWNWARDS ARROW
    /// </summary>
    public const char arrowdown = '\u2193';

    /// <summary>
    /// LEFTWARDS ARROW
    /// </summary>
    public const char arrowleft = '\u2190';

    /// <summary>
    /// RIGHTWARDS ARROW
    /// </summary>
    public const char arrowright = '\u2192';

    /// <summary>
    /// UPWARDS ARROW
    /// </summary>
    public const char arrowup = '\u2191';

    /// <summary>
    /// UP DOWN ARROW
    /// </summary>
    public const char arrowupdn = '\u2195';

    /// <summary>
    /// UP DOWN ARROW WITH BASE
    /// </summary>
    public const char arrowupdnbse = '\u21A8';

    // EXTENDER
    //public const char ARROW                   = '\u;arrowvertex;VERTICAL' 

    /// <summary>
    /// CIRCUMFLEX ACCENT                                      
    /// </summary>
    public const char asciicircum = '\u005E';

    /// <summary>
    /// TILDE
    /// </summary>
    public const char asciitilde = '\u007E';

    /// <summary>
    /// ASTERISK
    /// </summary>
    public const char asterisk = '\u002A';

    /// <summary>
    /// ASTERISK OPERATOR
    /// </summary>
    public const char asteriskmath = '\u2217';

    /// <summary>
    /// COMMERCIAL AT
    /// </summary>
    public const char at = '\u0040';

    /// <summary>
    /// LATIN SMALL LETTER A WITH TILDE
    /// </summary>
    public const char atilde = '\u00E3';

    /// <summary>
    /// LATIN SMALL LETTER B
    /// </summary>
    public const char b = '\u0062';

    /// <summary>
    /// REVERSE SOLIDUS
    /// </summary>
    public const char backslash = '\u005C';

    /// <summary>
    /// VERTICAL LINE
    /// </summary>
    public const char bar = '\u007C';

    /// <summary>
    /// GREEK SMALL LETTER BETA
    /// </summary>
    public const char beta = '\u03B2';

    /// <summary>
    /// FULL BLOCK
    /// </summary>
    public const char block = '\u2588';

    /// <summary>
    /// LEFT CURLY BRACKET
    /// </summary>
    public const char braceleft = '\u007B';

    /// <summary>
    /// RIGHT CURLY BRACKET
    /// </summary>
    public const char braceright = '\u007D';

    /// <summary>
    /// LEFT SQUARE BRACKET
    /// </summary>
    public const char bracketleft = '\u005B';

    /// <summary>
    /// RIGHT SQUARE BRACKET
    /// </summary>
    public const char bracketright = '\u005D';

    /// <summary>
    /// BREVE
    /// </summary>
    public const char breve = '\u02D8';

    /// <summary>
    /// BROKEN BAR
    /// </summary>
    public const char brokenbar = '\u00A6';

    /// <summary>
    /// BULLET
    /// </summary>
    public const char bullet = '\u2022';

    /// <summary>
    /// LATIN SMALL LETTER C
    /// </summary>
    public const char c = '\u0063';

    /// <summary>
    /// LATIN SMALL LETTER C WITH ACUTE
    /// </summary>
    public const char cacute = '\u0107';

    /// <summary>
    /// CARON
    /// </summary>
    public const char caron = '\u02C7';

    /// <summary>
    /// DOWNWARDS ARROW WITH CORNER LEFTWARDS
    /// </summary>
    public const char carriagereturn = '\u21B5';

    /// <summary>
    /// LATIN SMALL LETTER C WITH CARON
    /// </summary>
    public const char ccaron = '\u010D';

    /// <summary>
    /// LATIN SMALL LETTER C WITH CEDILLA
    /// </summary>
    public const char ccedilla = '\u00E7';

    /// <summary>
    /// LATIN SMALL LETTER C WITH CIRCUMFLEX
    /// </summary>
    public const char ccircumflex = '\u0109';

    /// <summary>
    /// LATIN SMALL LETTER C WITH DOT ABOVE
    /// </summary>
    public const char cdotaccent = '\u010B';

    /// <summary>
    /// CEDILLA
    /// </summary>
    public const char cedilla = '\u00B8';

    /// <summary>
    /// CENT SIGN
    /// </summary>
    public const char cent = '\u00A2';

    /// <summary>
    /// GREEK SMALL LETTER CHI
    /// </summary>
    public const char chi = '\u03C7';

    /// <summary>
    /// WHITE CIRCLE
    /// </summary>
    public const char circle = '\u25CB';

    /// <summary>
    /// CIRCLED TIMES
    /// </summary>
    public const char circlemultiply = '\u2297';

    /// <summary>
    /// CIRCLED PLUS
    /// </summary>
    public const char circleplus = '\u2295';

    /// <summary>
    /// MODIFIER LETTER CIRCUMFLEX ACCENT
    /// </summary>
    public const char circumflex = '\u02C6';

    /// <summary>
    /// BLACK CLUB SUIT
    /// </summary>
    public const char club = '\u2663';

    /// <summary>
    /// COLON
    /// </summary>
    public const char colon = '\u003A';

    /// <summary>
    /// COLON SIGN
    /// </summary>
    public const char colonmonetary = '\u20A1';

    /// <summary>
    /// COMMA
    /// </summary>
    public const char comma = '\u002C';

    /// <summary>
    /// APPROXIMATELY EQUAL TO
    /// </summary>
    public const char congruent = '\u2245';

    /// <summary>
    /// COPYRIGHT SIGN
    /// </summary>
    public const char copyright = '\u00A9';

    /// <summary>
    /// CURRENCY SIGN
    /// </summary>
    public const char currency = '\u00A4';

    /// <summary>
    /// LATIN SMALL LETTER D
    /// </summary>
    public const char d = '\u0064';

    /// <summary>
    /// DAGGER
    /// </summary>
    public const char dagger = '\u2020';

    /// <summary>
    /// DOUBLE DAGGER
    /// </summary>
    public const char daggerdbl = '\u2021';

    /// <summary>
    /// LATIN SMALL LETTER D WITH CARON
    /// </summary>
    public const char dcaron = '\u010F';

    /// <summary>
    /// LATIN SMALL LETTER D WITH STROKE
    /// </summary>
    public const char dcroat = '\u0111';

    /// <summary>
    /// DEGREE SIGN
    /// </summary>
    public const char degree = '\u00B0';

    /// <summary>
    /// GREEK SMALL LETTER DELTA
    /// </summary>
    public const char delta = '\u03B4';

    /// <summary>
    /// BLACK DIAMOND SUIT
    /// </summary>
    public const char diamond = '\u2666';

    /// <summary>
    /// DIAERESIS
    /// </summary>
    public const char dieresis = '\u00A8';

    /// <summary>
    /// GREEK DIALYTIKA TONOS
    /// </summary>
    public const char dieresistonos = '\u0385';

    /// <summary>
    /// DIVISION SIGN
    /// </summary>
    public const char divide = '\u00F7';

    /// <summary>
    /// DARK SHADE
    /// </summary>
    public const char dkshade = '\u2593';

    /// <summary>
    /// LOWER HALF BLOCK
    /// </summary>
    public const char dnblock = '\u2584';

    /// <summary>
    /// DOLLAR SIGN
    /// </summary>
    public const char dollar = '\u0024';

    /// <summary>
    /// DONG SIGN
    /// </summary>
    public const char dong = '\u20AB';

    /// <summary>
    /// DOT ABOVE
    /// </summary>
    public const char dotaccent = '\u02D9';

    /// <summary>
    /// COMBINING DOT BELOW
    /// </summary>
    public const char dotbelowcomb = '\u0323';

    /// <summary>
    /// LATIN SMALL LETTER DOTLESS I
    /// </summary>
    public const char dotlessi = '\u0131';

    /// <summary>
    /// DOT OPERATOR
    /// </summary>
    public const char dotmath = '\u22C5';

    /// <summary>
    /// LATIN SMALL LETTER E
    /// </summary>
    public const char e = '\u0065';

    /// <summary>
    /// LATIN SMALL LETTER E WITH ACUTE
    /// </summary>
    public const char eacute = '\u00E9';

    /// <summary>
    /// LATIN SMALL LETTER E WITH BREVE
    /// </summary>
    public const char ebreve = '\u0115';

    /// <summary>
    /// LATIN SMALL LETTER E WITH CARON
    /// </summary>
    public const char ecaron = '\u011B';

    /// <summary>
    /// LATIN SMALL LETTER E WITH CIRCUMFLEX
    /// </summary>
    public const char ecircumflex = '\u00EA';

    /// <summary>
    /// LATIN SMALL LETTER E WITH DIAERESIS
    /// </summary>
    public const char edieresis = '\u00EB';

    /// <summary>
    /// LATIN SMALL LETTER E WITH DOT ABOVE
    /// </summary>
    public const char edotaccent = '\u0117';

    /// <summary>
    /// LATIN SMALL LETTER E WITH GRAVE
    /// </summary>
    public const char egrave = '\u00E8';

    /// <summary>
    /// DIGIT EIGHT
    /// </summary>
    public const char eight = '\u0038';

    /// <summary>
    /// ELEMENT OF
    /// </summary>
    public const char element = '\u2208';

    /// <summary>
    /// HORIZONTAL ELLIPSIS
    /// </summary>
    public const char ellipsis = '\u2026';

    /// <summary>
    /// LATIN SMALL LETTER E WITH MACRON
    /// </summary>
    public const char emacron = '\u0113';

    /// <summary>
    /// EM DASH
    /// </summary>
    public const char emdash = '\u2014';

    /// <summary>
    /// EMPTY SET
    /// </summary>
    public const char emptyset = '\u2205';

    /// <summary>
    /// EN DASH
    /// </summary>
    public const char endash = '\u2013';

    /// <summary>
    /// LATIN SMALL LETTER ENG
    /// </summary>
    public const char eng = '\u014B';

    /// <summary>
    /// LATIN SMALL LETTER E WITH OGONEK
    /// </summary>
    public const char eogonek = '\u0119';

    /// <summary>
    /// GREEK SMALL LETTER EPSILON
    /// </summary>
    public const char epsilon = '\u03B5';

    /// <summary>
    /// GREEK SMALL LETTER EPSILON WITH TONOS
    /// </summary>
    public const char epsilontonos = '\u03AD';

    /// <summary>
    /// EQUALS SIGN
    /// </summary>
    public const char equal = '\u003D';

    /// <summary>
    /// IDENTICAL TO
    /// </summary>
    public const char equivalence = '\u2261';

    /// <summary>
    /// ESTIMATED SYMBOL
    /// </summary>
    public const char estimated = '\u212E';

    /// <summary>
    /// GREEK SMALL LETTER ETA
    /// </summary>
    public const char eta = '\u03B7';

    /// <summary>
    /// GREEK SMALL LETTER ETA WITH TONOS
    /// </summary>
    public const char etatonos = '\u03AE';

    /// <summary>
    /// LATIN SMALL LETTER ETH
    /// </summary>
    public const char eth = '\u00F0';

    /// <summary>
    /// EXCLAMATION MARK
    /// </summary>
    public const char exclam = '\u0021';

    /// <summary>
    /// DOUBLE EXCLAMATION MARK
    /// </summary>
    public const char exclamdbl = '\u203C';

    /// <summary>
    /// INVERTED EXCLAMATION MARK
    /// </summary>
    public const char exclamdown = '\u00A1';

    /// <summary>
    /// THERE EXISTS
    /// </summary>
    public const char existential = '\u2203';

    /// <summary>
    /// LATIN SMALL LETTER F
    /// </summary>
    public const char f = '\u0066';

    /// <summary>
    /// FEMALE SIGN
    /// </summary>
    public const char female = '\u2640';

    /// <summary>
    /// FIGURE DASH
    /// </summary>
    public const char figuredash = '\u2012';

    /// <summary>
    /// BLACK SQUARE
    /// </summary>
    public const char filledbox = '\u25A0';

    /// <summary>
    /// BLACK RECTANGLE
    /// </summary>
    public const char filledrect = '\u25AC';

    /// <summary>
    /// DIGIT FIVE
    /// </summary>
    public const char five = '\u0035';

    /// <summary>
    /// VULGAR FRACTION FIVE EIGHTHS
    /// </summary>
    public const char fiveeighths = '\u215D';

    /// <summary>
    /// LATIN SMALL LETTER F WITH HOOK
    /// </summary>
    public const char florin = '\u0192';

    /// <summary>
    /// DIGIT FOUR
    /// </summary>
    public const char four = '\u0034';

    /// <summary>
    /// FRACTION SLASH
    /// </summary>
    public const char fraction = '\u2044';

    /// <summary>
    /// FRENCH FRANC SIGN
    /// </summary>
    public const char franc = '\u20A3';

    /// <summary>
    /// LATIN SMALL LETTER G
    /// </summary>
    public const char g = '\u0067';

    /// <summary>
    /// GREEK SMALL LETTER GAMMA
    /// </summary>
    public const char gamma = '\u03B3';

    /// <summary>
    /// LATIN SMALL LETTER G WITH BREVE
    /// </summary>
    public const char gbreve = '\u011F';

    /// <summary>
    /// LATIN SMALL LETTER G WITH CARON
    /// </summary>
    public const char gcaron = '\u01E7';

    /// <summary>
    /// LATIN SMALL LETTER G WITH CIRCUMFLEX
    /// </summary>
    public const char gcircumflex = '\u011D';

    /// <summary>
    /// LATIN SMALL LETTER G WITH CEDILLA
    /// </summary>
    public const char gcommaaccent = '\u0123';

    /// <summary>
    /// LATIN SMALL LETTER G WITH DOT ABOVE
    /// </summary>
    public const char gdotaccent = '\u0121';

    /// <summary>
    /// LATIN SMALL LETTER SHARP S
    /// </summary>
    public const char germandbls = '\u00DF';

    /// <summary>
    /// NABLA
    /// </summary>
    public const char gradient = '\u2207';

    /// <summary>
    /// GRAVE ACCENT
    /// </summary>
    public const char grave = '\u0060';

    /// <summary>
    /// COMBINING GRAVE ACCENT
    /// </summary>
    public const char gravecomb = '\u0300';

    /// <summary>
    /// GREATER-THAN SIGN
    /// </summary>
    public const char greater = '\u003E';

    /// <summary>
    /// GREATER-THAN OR EQUAL TO
    /// </summary>
    public const char greaterequal = '\u2265';

    /// <summary>
    /// LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    /// </summary>
    public const char guillemotleft = '\u00AB';

    /// <summary>
    /// RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    /// </summary>
    public const char guillemotright = '\u00BB';

    /// <summary>
    /// SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    /// </summary>
    public const char guilsinglleft = '\u2039';

    /// <summary>
    /// SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    /// </summary>
    public const char guilsinglright = '\u203A';

    /// <summary>
    /// LATIN SMALL LETTER H
    /// </summary>
    public const char h = '\u0068';

    /// <summary>
    /// LATIN SMALL LETTER H WITH STROKE
    /// </summary>
    public const char hbar = '\u0127';

    /// <summary>
    /// LATIN SMALL LETTER H WITH CIRCUMFLEX
    /// </summary>
    public const char hcircumflex = '\u0125';

    /// <summary>
    /// BLACK HEART SUIT
    /// </summary>
    public const char heart = '\u2665';

    /// <summary>
    /// COMBINING HOOK ABOVE
    /// </summary>
    public const char hookabovecomb = '\u0309';

    /// <summary>
    /// HOUSE
    /// </summary>
    public const char house = '\u2302';

    /// <summary>
    /// DOUBLE ACUTE ACCENT
    /// </summary>
    public const char hungarumlaut = '\u02DD';

    /// <summary>
    /// HYPHEN-MINUS
    /// </summary>
    public const char hyphen = '\u002D';

    /// <summary>
    /// LATIN SMALL LETTER I
    /// </summary>
    public const char i = '\u0069';

    /// <summary>
    /// LATIN SMALL LETTER I WITH ACUTE
    /// </summary>
    public const char iacute = '\u00ED';

    /// <summary>
    /// LATIN SMALL LETTER I WITH BREVE
    /// </summary>
    public const char ibreve = '\u012D';

    /// <summary>
    /// LATIN SMALL LETTER I WITH CIRCUMFLEX
    /// </summary>
    public const char icircumflex = '\u00EE';

    /// <summary>
    /// LATIN SMALL LETTER I WITH DIAERESIS
    /// </summary>
    public const char idieresis = '\u00EF';

    /// <summary>
    /// LATIN SMALL LETTER I WITH GRAVE
    /// </summary>
    public const char igrave = '\u00EC';

    /// <summary>
    /// LATIN SMALL LIGATURE IJ
    /// </summary>
    public const char ij = '\u0133';

    /// <summary>
    /// LATIN SMALL LETTER I WITH MACRON
    /// </summary>
    public const char imacron = '\u012B';

    /// <summary>
    /// INFINITY
    /// </summary>
    public const char infinity = '\u221E';

    /// <summary>
    /// INTEGRAL
    /// </summary>
    public const char integral = '\u222B';

    /// <summary>
    /// BOTTOM HALF INTEGRAL
    /// </summary>
    public const char integralbt = '\u2321';

    /// <summary>
    /// TOP HALF INTEGRAL
    /// </summary>
    public const char integraltp = '\u2320';

    /// <summary>
    /// INTERSECTION
    /// </summary>
    public const char intersection = '\u2229';

    /// <summary>
    /// INVERSE BULLET
    /// </summary>
    public const char invbullet = '\u25D8';

    /// <summary>
    /// INVERSE WHITE CIRCLE
    /// </summary>
    public const char invcircle = '\u25D9';

    /// <summary>
    /// BLACK SMILING FACE
    /// </summary>
    public const char invsmileface = '\u263B';

    /// <summary>
    /// LATIN SMALL LETTER I WITH OGONEK
    /// </summary>
    public const char iogonek = '\u012F';

    /// <summary>
    /// GREEK SMALL LETTER IOTA
    /// </summary>
    public const char iota = '\u03B9';

    /// <summary>
    /// GREEK SMALL LETTER IOTA WITH DIALYTIKA
    /// </summary>
    public const char iotadieresis = '\u03CA';

    /// <summary>
    /// GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    /// </summary>
    public const char iotadieresistonos = '\u0390';

    /// <summary>
    /// GREEK SMALL LETTER IOTA WITH TONOS
    /// </summary>
    public const char iotatonos = '\u03AF';

    /// <summary>
    /// LATIN SMALL LETTER I WITH TILDE
    /// </summary>
    public const char itilde = '\u0129';

    /// <summary>
    /// LATIN SMALL LETTER J
    /// </summary>
    public const char j = '\u006A';

    /// <summary>
    /// LATIN SMALL LETTER J WITH CIRCUMFLEX
    /// </summary>
    public const char jcircumflex = '\u0135';

    /// <summary>
    /// LATIN SMALL LETTER K
    /// </summary>
    public const char k = '\u006B';

    /// <summary>
    /// GREEK SMALL LETTER KAPPA
    /// </summary>
    public const char kappa = '\u03BA';

    /// <summary>
    /// LATIN SMALL LETTER K WITH CEDILLA
    /// </summary>
    public const char kcommaaccent = '\u0137';

    /// <summary>
    /// LATIN SMALL LETTER KRA
    /// </summary>
    public const char kgreenlandic = '\u0138';

    /// <summary>
    /// LATIN SMALL LETTER L
    /// </summary>
    public const char l = '\u006C';

    /// <summary>
    /// LATIN SMALL LETTER L WITH ACUTE
    /// </summary>
    public const char lacute = '\u013A';

    /// <summary>
    /// GREEK SMALL LETTER LAMDA
    /// </summary>
    public const char lambda = '\u03BB';

    /// <summary>
    /// LATIN SMALL LETTER L WITH CARON
    /// </summary>
    public const char lcaron = '\u013E';

    /// <summary>
    /// LATIN SMALL LETTER L WITH CEDILLA
    /// </summary>
    public const char lcommaaccent = '\u013C';

    /// <summary>
    /// LATIN SMALL LETTER L WITH MIDDLE DOT
    /// </summary>
    public const char ldot = '\u0140';

    /// <summary>
    /// LESS-THAN SIGN
    /// </summary>
    public const char less = '\u003C';

    /// <summary>
    /// LESS-THAN OR EQUAL TO
    /// </summary>
    public const char lessequal = '\u2264';

    /// <summary>
    /// LEFT HALF BLOCK
    /// </summary>
    public const char lfblock = '\u258C';

    /// <summary>
    /// LIRA SIGN
    /// </summary>
    public const char lira = '\u20A4';

    /// <summary>
    /// LOGICAL AND
    /// </summary>
    public const char logicaland = '\u2227';

    /// <summary>
    /// NOT SIGN
    /// </summary>
    public const char logicalnot = '\u00AC';

    /// <summary>
    /// LOGICAL OR
    /// </summary>
    public const char logicalor = '\u2228';

    /// <summary>
    /// LATIN SMALL LETTER LONG S
    /// </summary>
    public const char longs = '\u017F';

    /// <summary>
    /// LOZENGE
    /// </summary>
    public const char lozenge = '\u25CA';

    /// <summary>
    /// LATIN SMALL LETTER L WITH STROKE
    /// </summary>
    public const char lslash = '\u0142';

    /// <summary>
    /// LIGHT SHADE
    /// </summary>
    public const char ltshade = '\u2591';

    /// <summary>
    /// LATIN SMALL LETTER M
    /// </summary>
    public const char m = '\u006D';

    /// <summary>
    /// MACRON
    /// </summary>
    public const char macron = '\u00AF';

    /// <summary>
    /// MALE SIGN
    /// </summary>
    public const char male = '\u2642';

    /// <summary>
    /// MINUS SIGN
    /// </summary>
    public const char minus = '\u2212';

    /// <summary>
    /// PRIME
    /// </summary>
    public const char minute = '\u2032';

    /// <summary>
    /// MICRO SIGN
    /// </summary>
    public const char mu = '\u00B5';

    /// <summary>
    /// MULTIPLICATION SIGN
    /// </summary>
    public const char multiply = '\u00D7';

    /// <summary>
    /// EIGHTH NOTE
    /// </summary>
    public const char musicalnote = '\u266A';

    /// <summary>
    /// BEAMED EIGHTH NOTES
    /// </summary>
    public const char musicalnotedbl = '\u266B';

    /// <summary>
    /// LATIN SMALL LETTER N
    /// </summary>
    public const char n = '\u006E';

    /// <summary>
    /// LATIN SMALL LETTER N WITH ACUTE
    /// </summary>
    public const char nacute = '\u0144';

    /// <summary>
    /// LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    /// </summary>
    public const char napostrophe = '\u0149';

    /// <summary>
    /// LATIN SMALL LETTER N WITH CARON
    /// </summary>
    public const char ncaron = '\u0148';

    /// <summary>
    /// LATIN SMALL LETTER N WITH CEDILLA
    /// </summary>
    public const char ncommaaccent = '\u0146';

    /// <summary>
    /// DIGIT NINE
    /// </summary>
    public const char nine = '\u0039';

    /// <summary>
    /// NOT AN ELEMENT OF
    /// </summary>
    public const char notelement = '\u2209';

    /// <summary>
    /// NOT EQUAL TO
    /// </summary>
    public const char notequal = '\u2260';

    /// <summary>
    /// NOT A SUBSET OF
    /// </summary>
    public const char notsubset = '\u2284';

    /// <summary>
    /// LATIN SMALL LETTER N WITH TILDE
    /// </summary>
    public const char ntilde = '\u00F1';

    /// <summary>
    /// GREEK SMALL LETTER NU
    /// </summary>
    public const char nu = '\u03BD';

    /// <summary>
    /// NUMBER SIGN
    /// </summary>
    public const char numbersign = '\u0023';

    /// <summary>
    /// LATIN SMALL LETTER O
    /// </summary>
    public const char o = '\u006F';

    /// <summary>
    /// LATIN SMALL LETTER O WITH ACUTE
    /// </summary>
    public const char oacute = '\u00F3';

    /// <summary>
    /// LATIN SMALL LETTER O WITH BREVE
    /// </summary>
    public const char obreve = '\u014F';

    /// <summary>
    /// LATIN SMALL LETTER O WITH CIRCUMFLEX
    /// </summary>
    public const char ocircumflex = '\u00F4';

    /// <summary>
    /// LATIN SMALL LETTER O WITH DIAERESIS
    /// </summary>
    public const char odieresis = '\u00F6';

    /// <summary>
    /// LATIN SMALL LIGATURE OE
    /// </summary>
    public const char oe = '\u0153';

    /// <summary>
    /// OGONEK
    /// </summary>
    public const char ogonek = '\u02DB';

    /// <summary>
    /// LATIN SMALL LETTER O WITH GRAVE
    /// </summary>
    public const char ograve = '\u00F2';

    /// <summary>
    /// LATIN SMALL LETTER O WITH HORN
    /// </summary>
    public const char ohorn = '\u01A1';

    /// <summary>
    /// LATIN SMALL LETTER O WITH DOUBLE ACUTE
    /// </summary>
    public const char ohungarumlaut = '\u0151';

    /// <summary>
    /// LATIN SMALL LETTER O WITH MACRON
    /// </summary>
    public const char omacron = '\u014D';

    /// <summary>
    /// GREEK SMALL LETTER OMEGA
    /// </summary>
    public const char omega = '\u03C9';

    /// <summary>
    /// GREEK PI SYMBOL
    /// </summary>
    public const char omega1 = '\u03D6';

    /// <summary>
    /// GREEK SMALL LETTER OMEGA WITH TONOS
    /// </summary>
    public const char omegatonos = '\u03CE';

    /// <summary>
    /// GREEK SMALL LETTER OMICRON
    /// </summary>
    public const char omicron = '\u03BF';

    /// <summary>
    /// GREEK SMALL LETTER OMICRON WITH TONOS
    /// </summary>
    public const char omicrontonos = '\u03CC';

    /// <summary>
    /// DIGIT ONE
    /// </summary>
    public const char one = '\u0031';

    /// <summary>
    /// ONE DOT LEADER
    /// </summary>
    public const char onedotenleader = '\u2024';

    /// <summary>
    /// VULGAR FRACTION ONE EIGHTH
    /// </summary>
    public const char oneeighth = '\u215B';

    /// <summary>
    /// VULGAR FRACTION ONE HALF
    /// </summary>
    public const char onehalf = '\u00BD';

    /// <summary>
    /// VULGAR FRACTION ONE QUARTER
    /// </summary>
    public const char onequarter = '\u00BC';

    /// <summary>
    /// VULGAR FRACTION ONE THIRD
    /// </summary>
    public const char onethird = '\u2153';

    /// <summary>
    /// WHITE BULLET
    /// </summary>
    public const char openbullet = '\u25E6';

    /// <summary>
    /// FEMININE ORDINAL INDICATOR
    /// </summary>
    public const char ordfeminine = '\u00AA';

    /// <summary>
    /// MASCULINE ORDINAL INDICATOR
    /// </summary>
    public const char ordmasculine = '\u00BA';

    /// <summary>
    /// RIGHT ANGLE
    /// </summary>
    public const char orthogonal = '\u221F';

    /// <summary>
    /// LATIN SMALL LETTER O WITH STROKE
    /// </summary>
    public const char oslash = '\u00F8';

    /// <summary>
    /// LATIN SMALL LETTER O WITH STROKE AND ACUTE
    /// </summary>
    public const char oslashacute = '\u01FF';

    /// <summary>
    /// LATIN SMALL LETTER O WITH TILDE
    /// </summary>
    public const char otilde = '\u00F5';

    /// <summary>
    /// LATIN SMALL LETTER P
    /// </summary>
    public const char p = '\u0070';

    /// <summary>
    /// PILCROW SIGN
    /// </summary>
    public const char paragraph = '\u00B6';

    /// <summary>
    /// LEFT PARENTHESIS
    /// </summary>
    public const char parenleft = '\u0028';

    /// <summary>
    /// RIGHT PARENTHESIS
    /// </summary>
    public const char parenright = '\u0029';

    /// <summary>
    /// PARTIAL DIFFERENTIAL
    /// </summary>
    public const char partialdiff = '\u2202';

    /// <summary>
    /// PERCENT SIGN
    /// </summary>
    public const char percent = '\u0025';

    /// <summary>
    /// FULL STOP
    /// </summary>
    public const char period = '\u002E';

    /// <summary>
    /// MIDDLE DOT
    /// </summary>
    public const char periodcentered = '\u00B7';

    /// <summary>
    /// UP TACK
    /// </summary>
    public const char perpendicular = '\u22A5';

    /// <summary>
    /// PER MILLE SIGN
    /// </summary>
    public const char perthousand = '\u2030';

    /// <summary>
    /// PESETA SIGN
    /// </summary>
    public const char peseta = '\u20A7';

    /// <summary>
    /// GREEK SMALL LETTER PHI
    /// </summary>
    public const char phi = '\u03C6';

    /// <summary>
    /// GREEK PHI SYMBOL
    /// </summary>
    public const char phi1 = '\u03D5';

    /// <summary>
    /// GREEK SMALL LETTER PI
    /// </summary>
    public const char pi = '\u03C0';

    /// <summary>
    /// PLUS SIGN
    /// </summary>
    public const char plus = '\u002B';

    /// <summary>
    /// PLUS-MINUS SIGN
    /// </summary>
    public const char plusminus = '\u00B1';

    /// <summary>
    /// PRESCRIPTION TAKE
    /// </summary>
    public const char prescription = '\u211E';

    /// <summary>
    /// N-ARY PRODUCT
    /// </summary>
    public const char product = '\u220F';

    /// <summary>
    /// SUBSET OF
    /// </summary>
    public const char propersubset = '\u2282';

    /// <summary>
    /// SUPERSET OF
    /// </summary>
    public const char propersuperset = '\u2283';

    /// <summary>
    /// PROPORTIONAL TO
    /// </summary>
    public const char proportional = '\u221D';

    /// <summary>
    /// GREEK SMALL LETTER PSI
    /// </summary>
    public const char psi = '\u03C8';

    /// <summary>
    /// LATIN SMALL LETTER Q
    /// </summary>
    public const char q = '\u0071';

    /// <summary>
    /// QUESTION MARK
    /// </summary>
    public const char question = '\u003F';

    /// <summary>
    /// INVERTED QUESTION MARK
    /// </summary>
    public const char questiondown = '\u00BF';

    /// <summary>
    /// QUOTATION MARK
    /// </summary>
    public const char quotedbl = '\u0022';

    /// <summary>
    /// DOUBLE LOW-9 QUOTATION MARK
    /// </summary>
    public const char quotedblbase = '\u201E';

    /// <summary>
    /// LEFT DOUBLE QUOTATION MARK
    /// </summary>
    public const char quotedblleft = '\u201C';

    /// <summary>
    /// RIGHT DOUBLE QUOTATION MARK
    /// </summary>
    public const char quotedblright = '\u201D';

    /// <summary>
    /// LEFT SINGLE QUOTATION MARK
    /// </summary>
    public const char quoteleft = '\u2018';

    /// <summary>
    /// SINGLE HIGH-REVERSED-9 QUOTATION MARK
    /// </summary>
    public const char quotereversed = '\u201B';

    /// <summary>
    /// RIGHT SINGLE QUOTATION MARK
    /// </summary>
    public const char quoteright = '\u2019';

    /// <summary>
    /// SINGLE LOW-9 QUOTATION MARK
    /// </summary>
    public const char quotesinglbase = '\u201A';

    /// <summary>
    /// APOSTROPHE
    /// </summary>
    public const char quotesingle = '\u0027';

    /// <summary>
    /// LATIN SMALL LETTER R
    /// </summary>
    public const char r = '\u0072';

    /// <summary>
    /// LATIN SMALL LETTER R WITH ACUTE
    /// </summary>
    public const char racute = '\u0155';

    /// <summary>
    /// SQUARE ROOT
    /// </summary>
    public const char radical = '\u221A';

    /// <summary>
    /// LATIN SMALL LETTER R WITH CARON
    /// </summary>
    public const char rcaron = '\u0159';

    /// <summary>
    /// LATIN SMALL LETTER R WITH CEDILLA
    /// </summary>
    public const char rcommaaccent = '\u0157';

    /// <summary>
    /// SUBSET OF OR EQUAL TO
    /// </summary>
    public const char reflexsubset = '\u2286';

    /// <summary>
    /// SUPERSET OF OR EQUAL TO
    /// </summary>
    public const char reflexsuperset = '\u2287';

    /// <summary>
    /// REGISTERED SIGN
    /// </summary>
    public const char registered = '\u00AE';

    /// <summary>
    /// REVERSED NOT SIGN
    /// </summary>
    public const char revlogicalnot = '\u2310';

    /// <summary>
    /// GREEK SMALL LETTER RHO
    /// </summary>
    public const char rho = '\u03C1';

    /// <summary>
    /// RING ABOVE
    /// </summary>
    public const char ring = '\u02DA';

    /// <summary>
    /// RIGHT HALF BLOCK
    /// </summary>
    public const char rtblock = '\u2590';

    /// <summary>
    /// LATIN SMALL LETTER S
    /// </summary>
    public const char s = '\u0073';

    /// <summary>
    /// LATIN SMALL LETTER S WITH ACUTE
    /// </summary>
    public const char sacute = '\u015B';

    /// <summary>
    /// LATIN SMALL LETTER S WITH CARON
    /// </summary>
    public const char scaron = '\u0161';

    /// <summary>
    /// LATIN SMALL LETTER S WITH CEDILLA
    /// </summary>
    public const char scedilla = '\u015F';

    /// <summary>
    /// LATIN SMALL LETTER S WITH CIRCUMFLEX
    /// </summary>
    public const char scircumflex = '\u015D';

    /// <summary>
    /// LATIN SMALL LETTER S WITH COMMA BELOW
    /// </summary>
    public const char scommaaccent = '\u0219';

    /// <summary>
    /// DOUBLE PRIME
    /// </summary>
    public const char second = '\u2033';

    /// <summary>
    /// SECTION SIGN
    /// </summary>
    public const char section = '\u00A7';

    /// <summary>
    /// SEMICOLON
    /// </summary>
    public const char semicolon = '\u003B';

    /// <summary>
    /// DIGIT SEVEN
    /// </summary>
    public const char seven = '\u0037';

    /// <summary>
    /// VULGAR FRACTION SEVEN EIGHTHS
    /// </summary>
    public const char seveneighths = '\u215E';

    /// <summary>
    /// MEDIUM SHADE
    /// </summary>
    public const char shade = '\u2592';

    /// <summary>
    /// GREEK SMALL LETTER SIGMA
    /// </summary>
    public const char sigma = '\u03C3';

    /// <summary>
    /// GREEK SMALL LETTER FINAL SIGMA
    /// </summary>
    public const char sigma1 = '\u03C2';

    /// <summary>
    /// TILDE OPERATOR
    /// </summary>
    public const char similar = '\u223C';

    /// <summary>
    /// DIGIT SIX
    /// </summary>
    public const char six = '\u0036';

    /// <summary>
    /// SOLIDUS
    /// </summary>
    public const char slash = '\u002F';

    /// <summary>
    /// WHITE SMILING FACE
    /// </summary>
    public const char smileface = '\u263A';

    /// <summary>
    /// SPACE
    /// </summary>
    public const char space = '\u0020';

    /// <summary>
    /// BLACK SPADE SUIT
    /// </summary>
    public const char spade = '\u2660';

    /// <summary>
    /// POUND SIGN
    /// </summary>
    public const char sterling = '\u00A3';

    /// <summary>
    /// CONTAINS AS MEMBER
    /// </summary>
    public const char suchthat = '\u220B';

    /// <summary>
    /// N-ARY SUMMATION
    /// </summary>
    public const char summation = '\u2211';

    /// <summary>
    /// WHITE SUN WITH RAYS
    /// </summary>
    public const char sun = '\u263C';

    /// <summary>
    /// LATIN SMALL LETTER T
    /// </summary>
    public const char t = '\u0074';

    /// <summary>
    /// GREEK SMALL LETTER TAU
    /// </summary>
    public const char tau = '\u03C4';

    /// <summary>
    /// LATIN SMALL LETTER T WITH STROKE
    /// </summary>
    public const char tbar = '\u0167';

    /// <summary>
    /// LATIN SMALL LETTER T WITH CARON
    /// </summary>
    public const char tcaron = '\u0165';

    /// <summary>
    /// LATIN SMALL LETTER T WITH CEDILLA
    /// </summary>
    public const char tcommaaccent = '\u0163';

    /// <summary>
    /// THEREFORE
    /// </summary>
    public const char therefore = '\u2234';

    /// <summary>
    /// GREEK SMALL LETTER THETA
    /// </summary>
    public const char theta = '\u03B8';

    /// <summary>
    /// GREEK THETA SYMBOL
    /// </summary>
    public const char theta1 = '\u03D1';

    /// <summary>
    /// LATIN SMALL LETTER THORN
    /// </summary>
    public const char thorn = '\u00FE';

    /// <summary>
    /// DIGIT THREE
    /// </summary>
    public const char three = '\u0033';

    /// <summary>
    /// VULGAR FRACTION THREE EIGHTHS
    /// </summary>
    public const char threeeighths = '\u215C';

    /// <summary>
    /// VULGAR FRACTION THREE QUARTERS
    /// </summary>
    public const char threequarters = '\u00BE';

    /// <summary>
    /// SMALL TILDE
    /// </summary>
    public const char tilde = '\u02DC';

    /// <summary>
    /// COMBINING TILDE
    /// </summary>
    public const char tildecomb = '\u0303';

    /// <summary>
    /// GREEK TONOS
    /// </summary>
    public const char tonos = '\u0384';

    /// <summary>
    /// TRADE MARK SIGN
    /// </summary>
    public const char trademark = '\u2122';

    /// <summary>
    /// BLACK DOWN-POINTING TRIANGLE
    /// </summary>
    public const char triagdn = '\u25BC';

    /// <summary>
    /// BLACK LEFT-POINTING POINTER
    /// </summary>
    public const char triaglf = '\u25C4';

    /// <summary>
    /// BLACK RIGHT-POINTING POINTER
    /// </summary>
    public const char triagrt = '\u25BA';

    /// <summary>
    /// BLACK UP-POINTING TRIANGLE
    /// </summary>
    public const char triagup = '\u25B2';

    /// <summary>
    /// DIGIT TWO
    /// </summary>
    public const char two = '\u0032';

    /// <summary>
    /// TWO DOT LEADER
    /// </summary>
    public const char twodotenleader = '\u2025';

    /// <summary>
    /// VULGAR FRACTION TWO THIRDS
    /// </summary>
    public const char twothirds = '\u2154';

    /// <summary>
    /// LATIN SMALL LETTER U
    /// </summary>
    public const char u = '\u0075';

    /// <summary>
    /// LATIN SMALL LETTER U WITH ACUTE
    /// </summary>
    public const char uacute = '\u00FA';

    /// <summary>
    /// LATIN SMALL LETTER U WITH BREVE
    /// </summary>
    public const char ubreve = '\u016D';

    /// <summary>
    /// LATIN SMALL LETTER U WITH CIRCUMFLEX
    /// </summary>
    public const char ucircumflex = '\u00FB';

    /// <summary>
    /// LATIN SMALL LETTER U WITH DIAERESIS
    /// </summary>
    public const char udieresis = '\u00FC';

    /// <summary>
    /// LATIN SMALL LETTER U WITH GRAVE
    /// </summary>
    public const char ugrave = '\u00F9';

    /// <summary>
    /// LATIN SMALL LETTER U WITH HORN
    /// </summary>
    public const char uhorn = '\u01B0';

    /// <summary>
    /// LATIN SMALL LETTER U WITH DOUBLE ACUTE
    /// </summary>
    public const char uhungarumlaut = '\u0171';

    /// <summary>
    /// LATIN SMALL LETTER U WITH MACRON
    /// </summary>
    public const char umacron = '\u016B';

    /// <summary>
    /// LOW LINE
    /// </summary>
    public const char underscore = '\u005F';

    /// <summary>
    /// DOUBLE LOW LINE
    /// </summary>
    public const char underscoredbl = '\u2017';

    /// <summary>
    /// UNION
    /// </summary>
    public const char union = '\u222A';

    /// <summary>
    /// FOR ALL
    /// </summary>
    public const char universal = '\u2200';

    /// <summary>
    /// LATIN SMALL LETTER U WITH OGONEK
    /// </summary>
    public const char uogonek = '\u0173';

    /// <summary>
    /// UPPER HALF BLOCK
    /// </summary>
    public const char upblock = '\u2580';

    /// <summary>
    /// GREEK SMALL LETTER UPSILON
    /// </summary>
    public const char upsilon = '\u03C5';

    /// <summary>
    /// GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    /// </summary>
    public const char upsilondieresis = '\u03CB';

    /// <summary>
    /// GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    /// </summary>
    public const char upsilondieresistonos = '\u03B0';

    /// <summary>
    /// GREEK SMALL LETTER UPSILON WITH TONOS
    /// </summary>
    public const char upsilontonos = '\u03CD';

    /// <summary>
    /// LATIN SMALL LETTER U WITH RING ABOVE
    /// </summary>
    public const char uring = '\u016F';

    /// <summary>
    /// LATIN SMALL LETTER U WITH TILDE
    /// </summary>
    public const char utilde = '\u0169';

    /// <summary>
    /// LATIN SMALL LETTER V
    /// </summary>
    public const char v = '\u0076';

    /// <summary>
    /// LATIN SMALL LETTER W
    /// </summary>
    public const char w = '\u0077';

    /// <summary>
    /// LATIN SMALL LETTER W WITH ACUTE
    /// </summary>
    public const char wacute = '\u1E83';

    /// <summary>
    /// LATIN SMALL LETTER W WITH CIRCUMFLEX
    /// </summary>
    public const char wcircumflex = '\u0175';

    /// <summary>
    /// LATIN SMALL LETTER W WITH DIAERESIS
    /// </summary>
    public const char wdieresis = '\u1E85';

    /// <summary>
    /// SCRIPT CAPITAL P
    /// </summary>
    public const char weierstrass = '\u2118';

    /// <summary>
    /// LATIN SMALL LETTER W WITH GRAVE
    /// </summary>
    public const char wgrave = '\u1E81';

    /// <summary>
    /// LATIN SMALL LETTER X
    /// </summary>
    public const char x = '\u0078';

    /// <summary>
    /// GREEK SMALL LETTER XI
    /// </summary>
    public const char xi = '\u03BE';

    /// <summary>
    /// LATIN SMALL LETTER Y
    /// </summary>
    public const char y = '\u0079';

    /// <summary>
    /// LATIN SMALL LETTER Y WITH ACUTE
    /// </summary>
    public const char yacute = '\u00FD';

    /// <summary>
    /// LATIN SMALL LETTER Y WITH CIRCUMFLEX
    /// </summary>
    public const char ycircumflex = '\u0177';

    /// <summary>
    /// LATIN SMALL LETTER Y WITH DIAERESIS
    /// </summary>
    public const char ydieresis = '\u00FF';

    /// <summary>
    /// YEN SIGN
    /// </summary>
    public const char yen = '\u00A5';

    /// <summary>
    /// LATIN SMALL LETTER Y WITH GRAVE
    /// </summary>
    public const char ygrave = '\u1EF3';

    /// <summary>
    /// LATIN SMALL LETTER Z
    /// </summary>
    public const char z = '\u007A';

    /// <summary>
    /// LATIN SMALL LETTER Z WITH ACUTE
    /// </summary>
    public const char zacute = '\u017A';

    /// <summary>
    /// LATIN SMALL LETTER Z WITH CARON
    /// </summary>
    public const char zcaron = '\u017E';

    /// <summary>
    /// LATIN SMALL LETTER Z WITH DOT ABOVE
    /// </summary>
    public const char zdotaccent = '\u017C';

    /// <summary>
    /// DIGIT ZERO
    /// </summary>
    public const char zero = '\u0030';

    /// <summary>
    /// GREEK SMALL LETTER ZETA
    /// </summary>
    public const char zeta = '\u03B6';
  }
}
